/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.mixins.transformers.client.gui.drag_drop_gui;

import gg.essential.config.EssentialConfig;
import gg.essential.event.gui.GuiDrawScreenEvent;
import gg.essential.mixins.impl.client.gui.EssentialEntryAtScreenPosAccess;
import gg.essential.mixins.impl.client.gui.EssentialGuiDraggableEntryScreen;
import gg.essential.mixins.impl.client.gui.EssentialGuiScreenBeforeClose;
import gg.essential.mixins.impl.client.gui.EssentialPostScreenDrawHook;
import gg.essential.mixins.impl.client.gui.GuiDragDropEntryHandler;
import gg.essential.mixins.transformers.client.gui.AbstractListAccessor;
import gg.essential.mixins.transformers.client.gui.PackLoadingManagerAccessor;
import java.util.List;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.packs.PackSelectionModel;
import net.minecraft.client.gui.screens.packs.PackSelectionScreen;
import net.minecraft.client.gui.screens.packs.TransferableSelectionList;
import net.minecraft.server.packs.repository.Pack;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PackSelectionScreen.class})
public abstract class Mixin_DragDropUI_ResourcePacksScreen
extends Screen
implements EssentialPostScreenDrawHook,
EssentialGuiDraggableEntryScreen<TransferableSelectionList.PackEntry>,
EssentialGuiScreenBeforeClose {
    @Unique
    @Nullable
    private GuiDragDropEntryHandler<TransferableSelectionList.PackEntry> guiDragHandler = null;
    @Shadow
    private TransferableSelectionList f_99977_;
    @Shadow
    private TransferableSelectionList f_99978_;
    @Final
    @Shadow
    private PackSelectionModel f_99973_;

    @Unique
    private List<TransferableSelectionList.PackEntry> getAvailablePacksList() {
        return ((AbstractListAccessor)this.f_99977_).essential$getChildrenList();
    }

    @Unique
    private List<TransferableSelectionList.PackEntry> getSelectedPacksList() {
        return ((AbstractListAccessor)this.f_99978_).essential$getChildrenList();
    }

    @Unique
    private TransferableSelectionList getAvailableResourcePacksWidget() {
        return this.f_99977_;
    }

    @Unique
    private TransferableSelectionList getSelectedResourcePacksWidget() {
        return this.f_99978_;
    }

    @Unique
    private void markChanged() {
        ((PackLoadingManagerAccessor)this.f_99973_).essential$getChangeRunnable().run();
    }

    @Override
    @Nullable
    public GuiDragDropEntryHandler<TransferableSelectionList.PackEntry> essential$getDragHandlerOrNull() {
        return this.guiDragHandler;
    }

    @Unique
    private void drawDraggedEntry(GuiDrawScreenEvent event) {
        assert (this.guiDragHandler != null);
        GuiDragDropEntryHandler.ScreenPosition mousePos = new GuiDragDropEntryHandler.ScreenPosition(event.getMouseX(), event.getMouseY());
        if (this.isPosWithinBoundsOf(this.getAvailableResourcePacksWidget(), mousePos) && ((AbstractListAccessor)this.getAvailableResourcePacksWidget()).essential$getMaxScroll() != 0) {
            this.guiDragHandler.scrollIfDraggingNearTopOrBottom(mousePos.y(), (AbstractSelectionList)this.getAvailableResourcePacksWidget());
        } else if (this.isPosWithinBoundsOf(this.getSelectedResourcePacksWidget(), mousePos) && ((AbstractListAccessor)this.getSelectedResourcePacksWidget()).essential$getMaxScroll() != 0) {
            this.guiDragHandler.scrollIfDraggingNearTopOrBottom(mousePos.y(), (AbstractSelectionList)this.getSelectedResourcePacksWidget());
        }
        this.guiDragHandler.drawDraggedEntryWithinBounds(event, this.getAvailableResourcePacksWidget().m_5759_(), ((AbstractListAccessor)this.getAvailableResourcePacksWidget()).essential$getItemHeight() - 4, 0, 0, 2, 1, this.f_96543_, this.f_96544_);
    }

    @Inject(method={"init"}, at={@At(value="HEAD")})
    private void clearDragHandler(CallbackInfo ci) {
        if (this.guiDragHandler != null) {
            this.guiDragHandler.close(this.getAvailablePacksList(), this.getSelectedPacksList());
            this.guiDragHandler = null;
        }
    }

    @Inject(method={"init"}, at={@At(value="TAIL")})
    private void initDragHandler(CallbackInfo ci) {
        if (EssentialConfig.INSTANCE.getEssentialEnabled()) {
            this.guiDragHandler = new GuiDragDropEntryHandler<TransferableSelectionList.PackEntry>((Screen)((PackSelectionScreen)this), this::markChanged, () -> {}, this::dropDraggedEntry, this::updateIndicatorsForChangedDragPos, this::drawDraggedEntry, (a, b) -> {}, () -> {
                this.getAvailableResourcePacksWidget().m_6987_(null);
                this.getSelectedResourcePacksWidget().m_6987_(null);
            }, GuiDragDropEntryHandler.initResourcePackIndicator((PackSelectionScreen)this));
        }
    }

    @Unique
    private void dropDraggedEntry() {
        assert (this.guiDragHandler != null);
        this.guiDragHandler.placeDraggedEntryAtIndicatorOrReleaseToOrigin(this.getAvailablePacksList(), this.getSelectedPacksList(), (entry, fromIndex, toIndex, fromLeftList, toLeftList) -> {
            List<Pack> right_enabledList = ((PackLoadingManagerAccessor)this.f_99973_).essential$getEnabledList();
            List<Pack> left_disabledList = ((PackLoadingManagerAccessor)this.f_99973_).essential$getDisabledList();
            Pack entryData = (fromLeftList ? left_disabledList : right_enabledList).remove(fromIndex);
            if (toLeftList) {
                left_disabledList.add(toIndex, entryData);
            } else {
                right_enabledList.add(toIndex, entryData);
            }
        }, (toLeftList, entry, index2) -> {
            if (toLeftList.booleanValue()) {
                this.getAvailableResourcePacksWidget().m_6987_((AbstractSelectionList.Entry)entry);
            } else {
                this.getSelectedResourcePacksWidget().m_6987_((AbstractSelectionList.Entry)entry);
            }
        });
    }

    @Unique
    private boolean isPosWithinBoundsOf(TransferableSelectionList list, GuiDragDropEntryHandler.ScreenPosition pos) {
        int header2 = ((AbstractListAccessor)list).essential$getHeaderHeight();
        double top = ((AbstractListAccessor)list).essential$getTop();
        int bottom = ((AbstractListAccessor)list).essential$getBottom();
        int left2 = ((AbstractListAccessor)list).essential$getLeft();
        int right = ((AbstractListAccessor)list).essential$getRight();
        double visualHeaderSpace = (double)(header2 + 4) - list.m_93517_();
        if (visualHeaderSpace > 0.0) {
            top += visualHeaderSpace;
        }
        return pos.y() >= top && pos.y() <= (double)bottom && pos.x() >= (double)left2 && pos.x() <= (double)right;
    }

    @Unique
    private void updateIndicatorsForChangedDragPos(GuiDragDropEntryHandler.ScreenPosition dragPos) {
        assert (this.guiDragHandler != null);
        if (this.isPosWithinBoundsOf(this.getAvailableResourcePacksWidget(), dragPos)) {
            this.guiDragHandler.handleIndicatorForNonReorderingList(this.getAvailablePacksList(), this.getSelectedPacksList());
        } else if (this.isPosWithinBoundsOf(this.getSelectedResourcePacksWidget(), dragPos)) {
            this.guiDragHandler.placeIndicatorInListAtIndex(this.getSelectedPacksList(), this.getSelectedPacksList().indexOf(((EssentialEntryAtScreenPosAccess)this.getSelectedResourcePacksWidget()).essential$getEntryAtScreenPosition(dragPos.x(), dragPos.y())), this.getAvailablePacksList(), this.getCountOfImmovableTopEntries(), this.getCountOfImmovableBottomEntries());
        } else {
            this.guiDragHandler.placeIndicatorWhenOutsideOfLists(this.getAvailablePacksList(), this.getSelectedPacksList());
        }
    }

    @Unique
    private int getCountOfImmovableBottomEntries() {
        List<Pack> selectedList = ((PackLoadingManagerAccessor)this.f_99973_).essential$getEnabledList();
        if (selectedList.isEmpty()) {
            return 0;
        }
        for (int i2 = 0; i2 < selectedList.size(); ++i2) {
            Pack packInfo = selectedList.get(selectedList.size() - 1 - i2);
            if (packInfo.m_10450_() && packInfo.m_10451_() == Pack.Position.BOTTOM) continue;
            return i2;
        }
        return selectedList.size();
    }

    @Unique
    private int getCountOfImmovableTopEntries() {
        List<Pack> selectedList = ((PackLoadingManagerAccessor)this.f_99973_).essential$getEnabledList();
        if (selectedList.isEmpty()) {
            return 0;
        }
        for (int i2 = 0; i2 < selectedList.size(); ++i2) {
            Pack packInfo = selectedList.get(i2);
            if (packInfo.m_10450_() && packInfo.m_10451_() == Pack.Position.TOP) continue;
            return i2;
        }
        return selectedList.size();
    }

    @Override
    public void essential$beforeClose() {
        if (this.guiDragHandler != null) {
            this.guiDragHandler.close(this.getAvailablePacksList(), this.getSelectedPacksList());
            this.guiDragHandler = null;
        }
    }

    @Override
    public int essential$getQuickSwapIndex() {
        return this.getCountOfImmovableTopEntries();
    }

    protected Mixin_DragDropUI_ResourcePacksScreen() {
        super(null);
    }
}

