/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.mixins.transformers.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import gg.essential.cosmetics.CosmeticsRenderState;
import gg.essential.cosmetics.EssentialModelRenderer;
import gg.essential.gui.emotes.EmoteWheel;
import gg.essential.handlers.OnlineIndicator;
import gg.essential.lib.kotgl.matrix.matrices.Mat4;
import gg.essential.mixins.impl.client.entity.AbstractClientPlayerExt;
import gg.essential.mixins.impl.client.renderer.entity.PlayerEntityRendererExt;
import gg.essential.mod.cosmetics.SkinLayer;
import gg.essential.model.EnumPart;
import gg.essential.model.backend.minecraft.MinecraftRenderBackend;
import gg.essential.universal.UMatrixStack;
import gg.essential.util.GLUtil;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlayerRenderer.class})
public abstract class MixinRenderPlayer
extends LivingEntityRenderer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>>
implements PlayerEntityRendererExt {
    @Unique
    protected EssentialModelRenderer essentialModelRenderer;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void initEssentialCosmeticsLayer(CallbackInfo ci) {
        this.essentialModelRenderer = new EssentialModelRenderer((PlayerRenderer)this);
        this.f_115291_.add(this.essentialModelRenderer);
    }

    @Override
    public EssentialModelRenderer essential$getEssentialModelRenderer() {
        return this.essentialModelRenderer;
    }

    @Override
    public Iterable<?> essential$getFeatures() {
        return this.f_115291_;
    }

    @Inject(method={"setModelProperties"}, at={@At(value="RETURN")})
    private void disableOuterLayerWhereCoveredByCosmetic(AbstractClientPlayer player2, CallbackInfo ci) {
        Set<SkinLayer> coveredLayers = ((AbstractClientPlayerExt)player2).getCosmeticsState().getCoveredLayers();
        PlayerModel model = (PlayerModel)this.m_7200_();
        model.f_102809_.f_104207_ = model.f_102809_.f_104207_ & !coveredLayers.contains((Object)SkinLayer.HAT);
        model.f_103378_.f_104207_ = model.f_103378_.f_104207_ & !coveredLayers.contains((Object)SkinLayer.JACKET);
        model.f_103374_.f_104207_ = model.f_103374_.f_104207_ & !coveredLayers.contains((Object)SkinLayer.LEFT_SLEEVE);
        model.f_103375_.f_104207_ = model.f_103375_.f_104207_ & !coveredLayers.contains((Object)SkinLayer.RIGHT_SLEEVE);
        model.f_103376_.f_104207_ = model.f_103376_.f_104207_ & !coveredLayers.contains((Object)SkinLayer.LEFT_PANTS_LEG);
        model.f_103377_.f_104207_ = model.f_103377_.f_104207_ & !coveredLayers.contains((Object)SkinLayer.RIGHT_PANTS_LEG);
    }

    @Inject(method={"renderLeftHand"}, at={@At(value="HEAD")})
    private void isRenderingLeftArm(CallbackInfo ci) {
        EmoteWheel.isPlayerArmRendering = true;
        this.resetTransforms();
    }

    @Inject(method={"renderLeftHand"}, at={@At(value="RETURN")})
    private void renderLeftArm(PoseStack vMatrixStack, MultiBufferSource buffers, int combinedLight, AbstractClientPlayer player2, CallbackInfo ci) {
        UMatrixStack matrixStack = new UMatrixStack(vMatrixStack);
        MinecraftRenderBackend.VertexConsumerProvider vertexConsumerProvider = new MinecraftRenderBackend.VertexConsumerProvider(buffers, combinedLight);
        ((PlayerModel)this.m_7200_()).f_102610_ = false;
        CosmeticsRenderState.Live cState = new CosmeticsRenderState.Live(player2);
        this.essentialModelRenderer.render(matrixStack, vertexConsumerProvider, cState, EnumSet.of(EnumPart.LEFT_ARM), false);
        EmoteWheel.isPlayerArmRendering = false;
    }

    @Inject(method={"renderRightHand"}, at={@At(value="HEAD")})
    private void isRenderingRightArm(CallbackInfo ci) {
        EmoteWheel.isPlayerArmRendering = true;
        this.resetTransforms();
    }

    @Inject(method={"renderRightHand"}, at={@At(value="RETURN")})
    private void renderRightArm(PoseStack vMatrixStack, MultiBufferSource buffers, int combinedLight, AbstractClientPlayer player2, CallbackInfo ci) {
        UMatrixStack matrixStack = new UMatrixStack(vMatrixStack);
        MinecraftRenderBackend.VertexConsumerProvider vertexConsumerProvider = new MinecraftRenderBackend.VertexConsumerProvider(buffers, combinedLight);
        ((PlayerModel)this.m_7200_()).f_102610_ = false;
        CosmeticsRenderState.Live cState = new CosmeticsRenderState.Live(player2);
        this.essentialModelRenderer.render(matrixStack, vertexConsumerProvider, cState, EnumSet.of(EnumPart.RIGHT_ARM), false);
        EmoteWheel.isPlayerArmRendering = false;
    }

    @Inject(method={"renderNameTag(Lnet/minecraft/client/player/AbstractClientPlayer;Lnet/minecraft/network/chat/Component;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/entity/LivingEntityRenderer;renderNameTag(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/network/chat/Component;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V", ordinal=1)})
    private void setNametagEntity(CallbackInfo ci) {
        OnlineIndicator.currentlyDrawingPlayerEntityName.set(true);
    }

    @Override
    public Mat4 essential$getTransform(AbstractClientPlayer player2, float yaw, float partialTicks) {
        PoseStack stack = new PoseStack();
        this.m_7523_(player2, stack, (float)player2.f_19797_ + partialTicks, yaw, partialTicks);
        return GLUtil.INSTANCE.glGetMatrix(stack, 1.0f);
    }

    @Unique
    private void resetTransforms() {
    }

    @Shadow
    protected abstract void m_7523_(AbstractClientPlayer var1, PoseStack var2, float var3, float var4, float var5);

    public MixinRenderPlayer() {
        super(null, null, 0.0f);
    }
}

