/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.network.connectionmanager.coins;

import gg.essential.gui.image.EssentialAssetImageFactory;
import gg.essential.mod.EssentialAsset;
import gg.essential.network.connectionmanager.cosmetics.AssetLoader;
import gg.essential.util.CurrencyKt;
import java.util.Currency;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0018\b\u0086\b\u0018\u00002\u00020\u0001BO\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0005\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u0011J\t\u0010$\u001a\u00020\u0003H\u00c6\u0003J\t\u0010%\u001a\u00020\u0005H\u00c6\u0003J\t\u0010&\u001a\u00020\u0007H\u00c6\u0003J\t\u0010'\u001a\u00020\tH\u00c6\u0003J\t\u0010(\u001a\u00020\u0005H\u00c6\u0003J\t\u0010)\u001a\u00020\fH\u00c6\u0003J\t\u0010*\u001a\u00020\u000eH\u00c6\u0003J\t\u0010+\u001a\u00020\u000eH\u00c6\u0003J\t\u0010,\u001a\u00020\u000eH\u00c6\u0003Jc\u0010-\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u00052\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u000e2\b\b\u0002\u0010\u0010\u001a\u00020\u000eH\u00c6\u0001J\u0013\u0010.\u001a\u00020\u000e2\b\u0010/\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u000e\u00100\u001a\u00020\u00002\u0006\u00101\u001a\u00020\u0005J\t\u00102\u001a\u00020\u0005H\u00d6\u0001J\t\u00103\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0018R\u0011\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010 R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010 R\u0011\u0010\u0010\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010 R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0015R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#\u00a8\u00064"}, d2={"Lgg/essential/network/connectionmanager/coins/CoinBundle;", "", "id", "", "numberOfCoins", "", "currency", "Ljava/util/Currency;", "price", "", "extraPercent", "iconAsset", "Lgg/essential/mod/EssentialAsset;", "isHighlighted", "", "isExchangeBundle", "isSpecificAmount", "(Ljava/lang/String;ILjava/util/Currency;DILgg/essential/mod/EssentialAsset;ZZZ)V", "getCurrency", "()Ljava/util/Currency;", "getExtraPercent", "()I", "formattedPrice", "getFormattedPrice", "()Ljava/lang/String;", "getIconAsset", "()Lgg/essential/mod/EssentialAsset;", "iconFactory", "Lgg/essential/gui/image/EssentialAssetImageFactory;", "getIconFactory", "()Lgg/essential/gui/image/EssentialAssetImageFactory;", "getId", "()Z", "getNumberOfCoins", "getPrice", "()D", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "other", "getBundleForNumberOfCoins", "coins", "hashCode", "toString", "essential-gui-essential"})
public final class CoinBundle {
    @NotNull
    private final String id;
    private final int numberOfCoins;
    @NotNull
    private final Currency currency;
    private final double price;
    private final int extraPercent;
    @NotNull
    private final EssentialAsset iconAsset;
    private final boolean isHighlighted;
    private final boolean isExchangeBundle;
    private final boolean isSpecificAmount;
    @NotNull
    private final EssentialAssetImageFactory iconFactory;
    @NotNull
    private final String formattedPrice;

    public CoinBundle(@NotNull String id2, int numberOfCoins, @NotNull Currency currency2, double price2, int extraPercent, @NotNull EssentialAsset iconAsset, boolean isHighlighted, boolean isExchangeBundle, boolean isSpecificAmount) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        Intrinsics.checkNotNullParameter((Object)currency2, (String)"currency");
        Intrinsics.checkNotNullParameter((Object)iconAsset, (String)"iconAsset");
        this.id = id2;
        this.numberOfCoins = numberOfCoins;
        this.currency = currency2;
        this.price = price2;
        this.extraPercent = extraPercent;
        this.iconAsset = iconAsset;
        this.isHighlighted = isHighlighted;
        this.isExchangeBundle = isExchangeBundle;
        this.isSpecificAmount = isSpecificAmount;
        this.iconFactory = new EssentialAssetImageFactory(this.iconAsset, null, 2, null);
        this.iconFactory.primeCache(AssetLoader.Priority.Low);
        this.formattedPrice = CurrencyKt.format(this.currency, this.price);
    }

    public /* synthetic */ CoinBundle(String string, int n, Currency currency2, double d, int n2, EssentialAsset essentialAsset, boolean bl, boolean bl2, boolean bl3, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 0x100) != 0) {
            bl3 = false;
        }
        this(string, n, currency2, d, n2, essentialAsset, bl, bl2, bl3);
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    public final int getNumberOfCoins() {
        return this.numberOfCoins;
    }

    @NotNull
    public final Currency getCurrency() {
        return this.currency;
    }

    public final double getPrice() {
        return this.price;
    }

    public final int getExtraPercent() {
        return this.extraPercent;
    }

    @NotNull
    public final EssentialAsset getIconAsset() {
        return this.iconAsset;
    }

    public final boolean isHighlighted() {
        return this.isHighlighted;
    }

    public final boolean isExchangeBundle() {
        return this.isExchangeBundle;
    }

    public final boolean isSpecificAmount() {
        return this.isSpecificAmount;
    }

    @NotNull
    public final EssentialAssetImageFactory getIconFactory() {
        return this.iconFactory;
    }

    @NotNull
    public final String getFormattedPrice() {
        return this.formattedPrice;
    }

    @NotNull
    public final CoinBundle getBundleForNumberOfCoins(int coins) {
        double precision = Math.pow(10.0, this.currency.getDefaultFractionDigits());
        return CoinBundle.copy$default(this, null, coins, null, Math.rint(this.price / (double)this.numberOfCoins * (double)coins * precision) / precision, 0, null, false, false, true, 245, null);
    }

    @NotNull
    public final String component1() {
        return this.id;
    }

    public final int component2() {
        return this.numberOfCoins;
    }

    @NotNull
    public final Currency component3() {
        return this.currency;
    }

    public final double component4() {
        return this.price;
    }

    public final int component5() {
        return this.extraPercent;
    }

    @NotNull
    public final EssentialAsset component6() {
        return this.iconAsset;
    }

    public final boolean component7() {
        return this.isHighlighted;
    }

    public final boolean component8() {
        return this.isExchangeBundle;
    }

    public final boolean component9() {
        return this.isSpecificAmount;
    }

    @NotNull
    public final CoinBundle copy(@NotNull String id2, int numberOfCoins, @NotNull Currency currency2, double price2, int extraPercent, @NotNull EssentialAsset iconAsset, boolean isHighlighted, boolean isExchangeBundle, boolean isSpecificAmount) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        Intrinsics.checkNotNullParameter((Object)currency2, (String)"currency");
        Intrinsics.checkNotNullParameter((Object)iconAsset, (String)"iconAsset");
        return new CoinBundle(id2, numberOfCoins, currency2, price2, extraPercent, iconAsset, isHighlighted, isExchangeBundle, isSpecificAmount);
    }

    public static /* synthetic */ CoinBundle copy$default(CoinBundle coinBundle, String string, int n, Currency currency2, double d, int n2, EssentialAsset essentialAsset, boolean bl, boolean bl2, boolean bl3, int n3, Object object) {
        if ((n3 & 1) != 0) {
            string = coinBundle.id;
        }
        if ((n3 & 2) != 0) {
            n = coinBundle.numberOfCoins;
        }
        if ((n3 & 4) != 0) {
            currency2 = coinBundle.currency;
        }
        if ((n3 & 8) != 0) {
            d = coinBundle.price;
        }
        if ((n3 & 0x10) != 0) {
            n2 = coinBundle.extraPercent;
        }
        if ((n3 & 0x20) != 0) {
            essentialAsset = coinBundle.iconAsset;
        }
        if ((n3 & 0x40) != 0) {
            bl = coinBundle.isHighlighted;
        }
        if ((n3 & 0x80) != 0) {
            bl2 = coinBundle.isExchangeBundle;
        }
        if ((n3 & 0x100) != 0) {
            bl3 = coinBundle.isSpecificAmount;
        }
        return coinBundle.copy(string, n, currency2, d, n2, essentialAsset, bl, bl2, bl3);
    }

    @NotNull
    public String toString() {
        return "CoinBundle(id=" + this.id + ", numberOfCoins=" + this.numberOfCoins + ", currency=" + this.currency + ", price=" + this.price + ", extraPercent=" + this.extraPercent + ", iconAsset=" + this.iconAsset + ", isHighlighted=" + this.isHighlighted + ", isExchangeBundle=" + this.isExchangeBundle + ", isSpecificAmount=" + this.isSpecificAmount + ')';
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = result * 31 + Integer.hashCode(this.numberOfCoins);
        result = result * 31 + this.currency.hashCode();
        result = result * 31 + Double.hashCode(this.price);
        result = result * 31 + Integer.hashCode(this.extraPercent);
        result = result * 31 + this.iconAsset.hashCode();
        result = result * 31 + Boolean.hashCode(this.isHighlighted);
        result = result * 31 + Boolean.hashCode(this.isExchangeBundle);
        result = result * 31 + Boolean.hashCode(this.isSpecificAmount);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CoinBundle)) {
            return false;
        }
        CoinBundle coinBundle = (CoinBundle)other;
        if (!Intrinsics.areEqual((Object)this.id, (Object)coinBundle.id)) {
            return false;
        }
        if (this.numberOfCoins != coinBundle.numberOfCoins) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.currency, (Object)coinBundle.currency)) {
            return false;
        }
        if (Double.compare(this.price, coinBundle.price) != 0) {
            return false;
        }
        if (this.extraPercent != coinBundle.extraPercent) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.iconAsset, (Object)coinBundle.iconAsset)) {
            return false;
        }
        if (this.isHighlighted != coinBundle.isHighlighted) {
            return false;
        }
        if (this.isExchangeBundle != coinBundle.isExchangeBundle) {
            return false;
        }
        return this.isSpecificAmount == coinBundle.isSpecificAmount;
    }
}

