/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.network.connectionmanager.social;

import com.google.common.collect.Maps;
import gg.essential.connectionmanager.common.packet.social.SocialDiscordRequestJoinServerPacket;
import gg.essential.connectionmanager.common.packet.social.SocialInviteToServerCancelPacket;
import gg.essential.connectionmanager.common.packet.social.SocialInviteToServerPacket;
import gg.essential.event.network.server.ServerLeaveEvent;
import gg.essential.lib.kbrewster.eventbus.Subscribe;
import gg.essential.network.connectionmanager.ConnectionManager;
import gg.essential.network.connectionmanager.NetworkedManager;
import gg.essential.network.connectionmanager.social.handler.SocialDiscordRequestJoinServerPacketHandler;
import gg.essential.network.connectionmanager.social.handler.SocialInviteToServerCancelPacketHandler;
import gg.essential.network.connectionmanager.social.handler.SocialInviteToServerPacketHandler;
import gg.essential.util.UUIDUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.collections.SetsKt;
import org.jetbrains.annotations.NotNull;

public class SocialManager
implements NetworkedManager {
    @NotNull
    private final Map<UUID, String> incomingServerInvites = Maps.newConcurrentMap();
    @NotNull
    private final Map<String, Set<UUID>> invitedFriends = Maps.newConcurrentMap();
    @NotNull
    private final ConnectionManager connectionManager;

    public SocialManager(@NotNull ConnectionManager connectionManager) {
        connectionManager.registerPacketHandler(SocialInviteToServerPacket.class, new SocialInviteToServerPacketHandler());
        connectionManager.registerPacketHandler(SocialInviteToServerCancelPacket.class, new SocialInviteToServerCancelPacketHandler(this));
        connectionManager.registerPacketHandler(SocialDiscordRequestJoinServerPacket.class, new SocialDiscordRequestJoinServerPacketHandler());
        this.connectionManager = connectionManager;
    }

    @NotNull
    public Map<UUID, String> getIncomingServerInvites() {
        return this.incomingServerInvites;
    }

    public void addIncomingServerInvite(@NotNull UUID uuid, @NotNull String address) {
        this.incomingServerInvites.put(uuid, address);
    }

    public void removeIncomingServerInvite(@NotNull UUID uuid) {
        this.incomingServerInvites.remove(uuid);
    }

    public Set<UUID> getInvitesOnServer(String server) {
        return this.invitedFriends.getOrDefault(server, Collections.emptySet());
    }

    private void sendInvitesForServer(String server, Set<UUID> friends2) {
        friends2.forEach(uuid -> this.connectionManager.send(new SocialInviteToServerPacket((UUID)uuid, server)));
    }

    private void revokeInvites(Set<UUID> friends2) {
        friends2.forEach(uuid -> this.connectionManager.send(new SocialInviteToServerCancelPacket((UUID)uuid)));
    }

    public void setInvitedFriendsOnServer(String server, Set<UUID> friends2) {
        friends2 = new HashSet<UUID>(friends2);
        friends2.remove(UUIDUtil.getClientUUID());
        friends2 = Collections.unmodifiableSet(friends2);
        Set<UUID> previousValue = this.invitedFriends.put(server, friends2);
        Set<UUID> previousInvites = previousValue != null ? previousValue : Collections.emptySet();
        this.revokeInvites(SetsKt.minus(previousInvites, friends2));
        this.sendInvitesForServer(server, SetsKt.minus(friends2, previousInvites));
    }

    public void reinviteFriendsOnServer(String server, Set<UUID> friends2) {
        Set<UUID> invites = this.getInvitesOnServer(server);
        this.setInvitedFriendsOnServer(server, SetsKt.minus(invites, friends2));
        this.setInvitedFriendsOnServer(server, SetsKt.plus(invites, friends2));
    }

    @Override
    public void resetState() {
        this.invitedFriends.forEach((ignored, uuids) -> this.revokeInvites((Set<UUID>)uuids));
        this.invitedFriends.clear();
        this.incomingServerInvites.clear();
    }

    @Subscribe
    public void onServerLeave(ServerLeaveEvent event) {
        this.invitedFriends.forEach((ignored, uuids) -> this.revokeInvites((Set<UUID>)uuids));
        this.invitedFriends.clear();
    }
}

