/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.quic.backend;

import gg.essential.quic.backend.QuicBackend;
import gg.essential.quic.backend.QuicListener;
import gg.essential.util.classloader.RelaunchClassLoader;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;

public class QuicBackendLoader {
    public static final QuicBackendLoader INSTANCE = new QuicBackendLoader();
    private static final String IMPL_CLASS_NAME = "gg.essential.quic.backend.QuicBackendImpl";
    private static URL extractedBundleJar;
    private final RelaunchClassLoader loader = new RelaunchClassLoader(new URL[]{QuicBackendLoader.findExtractedBundleJar()}, QuicBackendLoader.class.getClassLoader());

    public QuicBackendLoader() {
        this.loader.addPackageExclusion("org.slf4j.");
        this.loader.addPackageExclusion("org~slf4j~".replace('~', '.'));
        this.loader.addClassExclusion(QuicBackend.class.getName());
        this.loader.addClassExclusion(QuicListener.class.getName());
        this.loader.setResourceFilter(name2 -> name2.startsWith("META-INF/native/"));
    }

    private static URL findExtractedBundleJar() {
        if (extractedBundleJar == null) {
            try {
                URL bundledJar = QuicBackendLoader.class.getResource("/gg/essential/sps/quic/jvm/netty.jar");
                if (bundledJar == null) {
                    throw new IllegalStateException("Failed to find netty bundle jar");
                }
                Path tmpPath = Files.createTempFile("essential-netty", ".jar", new FileAttribute[0]);
                tmpPath.toFile().deleteOnExit();
                try (InputStream is = bundledJar.openStream();){
                    Files.copy(is, tmpPath, StandardCopyOption.REPLACE_EXISTING);
                }
                extractedBundleJar = tmpPath.toUri().toURL();
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to load netty bundle jar");
            }
        }
        return extractedBundleJar;
    }

    public QuicBackend createImpl(Logger logger2, QuicListener listener2) {
        try {
            Class<?> quicImplClass = this.loader.loadClass(IMPL_CLASS_NAME);
            Constructor<?> constructor = quicImplClass.getDeclaredConstructor(Logger.class, QuicListener.class);
            return (QuicBackend)constructor.newInstance(logger2, listener2);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

