/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.util;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import gg.essential.universal.UGraphics;
import gg.essential.universal.UMatrixStack;
import gg.essential.universal.UResolution;
import gg.essential.universal.render.DrawCallBuilder;
import gg.essential.universal.render.URenderPipeline;
import gg.essential.universal.shader.BlendState;
import gg.essential.universal.vertex.UBufferBuilder;
import gg.essential.universal.vertex.UBuiltBuffer;
import gg.essential.util.GlFrameBuffer;
import gg.essential.util.GlFrameBufferImpl;
import gg.essential.util.GlGpuTexture;
import gg.essential.util.OwnedGlGpuTexture;
import gg.essential.util.image.GpuTexture;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL30;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0012\u0018\u0000 >2\u00020\u0001:\u0001>B'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u001d\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u000e\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\f\u0010\u000fJ'\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000f\u0010\u0017\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J?\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u0003\u001a\u00020\u00122\u0006\u0010\u0004\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u000f\u0010 \u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b \u0010\u0018J\u001f\u0010!\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b!\u0010\"J#\u0010%\u001a\u00028\u0000\"\u0004\b\u0000\u0010#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00028\u00000\nH\u0016\u00a2\u0006\u0004\b%\u0010&J/\u0010(\u001a\u00020\u000b2\u001e\u0010$\u001a\u001a\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u000b0'H\u0016\u00a2\u0006\u0004\b(\u0010)J+\u0010*\u001a\u00028\u0000\"\u0004\b\u0000\u0010#2\u0006\u0010\u000e\u001a\u00020\u00022\f\u0010$\u001a\b\u0012\u0004\u0012\u00028\u00000\nH\u0002\u00a2\u0006\u0004\b*\u0010+R\u0014\u0010\u0006\u001a\u00020\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010,R\u0014\u0010\u0007\u001a\u00020\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010,R\"\u0010.\u001a\u00020-8\u0016@\u0016X\u0096.\u00a2\u0006\u0012\n\u0004\b.\u0010/\u001a\u0004\b0\u00101\"\u0004\b2\u00103R$\u00105\u001a\u00020\u00022\u0006\u00104\u001a\u00020\u00028\u0016@RX\u0096\u000e\u00a2\u0006\f\n\u0004\b5\u00106\u001a\u0004\b7\u00108R$\u0010\u0004\u001a\u00020\u00022\u0006\u00104\u001a\u00020\u00028\u0016@RX\u0096\u000e\u00a2\u0006\f\n\u0004\b\u0004\u00106\u001a\u0004\b9\u00108R\"\u0010:\u001a\u00020-8\u0016@\u0016X\u0096.\u00a2\u0006\u0012\n\u0004\b:\u0010/\u001a\u0004\b;\u00101\"\u0004\b<\u00103R$\u0010\u0003\u001a\u00020\u00022\u0006\u00104\u001a\u00020\u00028\u0016@RX\u0096\u000e\u00a2\u0006\f\n\u0004\b\u0003\u00106\u001a\u0004\b=\u00108\u00a8\u0006?"}, d2={"Lgg/essential/util/GlFrameBufferImpl;", "Lgg/essential/util/GlFrameBuffer;", "", "width", "height", "Lgg/essential/util/image/GpuTexture$Format;", "colorFormat", "depthFormat", "<init>", "(IILgg/essential/util/image/GpuTexture$Format;Lgg/essential/util/image/GpuTexture$Format;)V", "Lkotlin/Function0;", "", "bind", "()Lkotlin/jvm/functions/Function0;", "glId", "(I)Lkotlin/jvm/functions/Function0;", "Ljava/awt/Color;", "clearColor", "", "clearDepth", "clearStencil", "clear", "(Ljava/awt/Color;DI)V", "delete", "()V", "Lgg/essential/universal/UMatrixStack;", "matrixStack", "x", "y", "color", "drawTexture", "(Lgg/essential/universal/UMatrixStack;DDDDLjava/awt/Color;)V", "init", "resize", "(II)V", "T", "block", "use", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "Lkotlin/Function3;", "useAsRenderTarget", "(Lkotlin/jvm/functions/Function3;)V", "withFrameBuffer", "(ILkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "Lgg/essential/util/image/GpuTexture$Format;", "Lgg/essential/util/GlGpuTexture;", "depthStencil", "Lgg/essential/util/GlGpuTexture;", "getDepthStencil", "()Lgg/essential/util/GlGpuTexture;", "setDepthStencil", "(Lgg/essential/util/GlGpuTexture;)V", "<set-?>", "frameBuffer", "I", "getFrameBuffer", "()I", "getHeight", "texture", "getTexture", "setTexture", "getWidth", "Companion", "Essential 1.20.1-forge"})
public final class GlFrameBufferImpl
implements GlFrameBuffer {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final GpuTexture.Format colorFormat;
    @NotNull
    private final GpuTexture.Format depthFormat;
    private int width;
    private int height;
    private int frameBuffer;
    public GlGpuTexture texture;
    public GlGpuTexture depthStencil;
    @NotNull
    private static final URenderPipeline PIPELINE;

    public GlFrameBufferImpl(int width2, int height2, @NotNull GpuTexture.Format colorFormat, @NotNull GpuTexture.Format depthFormat) {
        Intrinsics.checkNotNullParameter((Object)((Object)colorFormat), (String)"colorFormat");
        Intrinsics.checkNotNullParameter((Object)((Object)depthFormat), (String)"depthFormat");
        this.colorFormat = colorFormat;
        this.depthFormat = depthFormat;
        this.width = width2;
        this.height = height2;
        this.frameBuffer = -1;
        this.init();
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getFrameBuffer() {
        return this.frameBuffer;
    }

    @Override
    @NotNull
    public GlGpuTexture getTexture() {
        GlGpuTexture glGpuTexture = this.texture;
        if (glGpuTexture != null) {
            return glGpuTexture;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"texture");
        return null;
    }

    public void setTexture(@NotNull GlGpuTexture glGpuTexture) {
        Intrinsics.checkNotNullParameter((Object)glGpuTexture, (String)"<set-?>");
        this.texture = glGpuTexture;
    }

    @Override
    @NotNull
    public GlGpuTexture getDepthStencil() {
        GlGpuTexture glGpuTexture = this.depthStencil;
        if (glGpuTexture != null) {
            return glGpuTexture;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"depthStencil");
        return null;
    }

    public void setDepthStencil(@NotNull GlGpuTexture glGpuTexture) {
        Intrinsics.checkNotNullParameter((Object)glGpuTexture, (String)"<set-?>");
        this.depthStencil = glGpuTexture;
    }

    @Override
    public void resize(int width2, int height2) {
        if (this.getWidth() == width2 && this.getHeight() == height2 && this.getFrameBuffer() != -1) {
            return;
        }
        this.width = width2;
        this.height = height2;
        this.delete();
        this.init();
    }

    private final void init() {
        this.frameBuffer = GL30.glGenFramebuffers();
        this.setTexture(new OwnedGlGpuTexture(this.getWidth(), this.getHeight(), this.colorFormat));
        this.setDepthStencil(new OwnedGlGpuTexture(this.getWidth(), this.getHeight(), this.depthFormat));
        this.withFrameBuffer(this.getFrameBuffer(), (Function0)new Function0<Unit>(this){
            final /* synthetic */ GlFrameBufferImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                GL30.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this.this$0.getTexture().getGlId(), (int)0);
                GL30.glFramebufferTexture2D((int)36160, (int)(switch (init.WhenMappings.$EnumSwitchMapping$0[GlFrameBufferImpl.access$getDepthFormat$p(this.this$0).ordinal()]) {
                    case 1 -> throw new IllegalArgumentException();
                    case 2 -> 33306;
                    case 3 -> 36096;
                    default -> throw new NoWhenBranchMatchedException();
                }), (int)3553, (int)this.this$0.getDepthStencil().getGlId(), (int)0);
            }
        });
    }

    @Override
    public void delete() {
        this.getDepthStencil().delete();
        this.getTexture().delete();
        if (this.getFrameBuffer() != -1) {
            GL30.glDeleteFramebuffers((int)this.getFrameBuffer());
            this.frameBuffer = -1;
        }
    }

    @Override
    public <T> T use(@NotNull Function0<? extends T> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        if (this.getFrameBuffer() == -1) {
            this.resize(this.getWidth(), this.getHeight());
        }
        return this.withFrameBuffer(this.getFrameBuffer(), block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T withFrameBuffer(int glId, Function0<? extends T> block) {
        Function0<Unit> unbind = this.bind(glId);
        try {
            Object object = block.invoke();
            return (T)object;
        }
        finally {
            unbind.invoke();
        }
    }

    @Override
    public void useAsRenderTarget(@NotNull Function3<? super UMatrixStack, ? super Integer, ? super Integer, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this.use((Function0)new Function0<Unit>(this, block){
            final /* synthetic */ GlFrameBufferImpl this$0;
            final /* synthetic */ Function3<UMatrixStack, Integer, Integer, Unit> $block;
            {
                this.this$0 = $receiver;
                this.$block = $block;
                super(0);
            }

            public final void invoke() {
                boolean scissorState = GL11.glGetBoolean((int)3089);
                GL11.glDisable((int)3089);
                GL11.glViewport((int)0, (int)0, (int)this.this$0.getWidth(), (int)this.this$0.getHeight());
                UMatrixStack stack = new UMatrixStack();
                double scale2 = 1.0 / UResolution.getScaleFactor();
                stack.scale(scale2 * (double)UResolution.getViewportWidth() / (double)this.this$0.getWidth(), scale2 * (double)UResolution.getViewportHeight() / (double)this.this$0.getHeight(), 1.0);
                this.$block.invoke((Object)stack, (Object)this.this$0.getWidth(), (Object)this.this$0.getHeight());
                GL11.glViewport((int)0, (int)0, (int)UResolution.getViewportWidth(), (int)UResolution.getViewportHeight());
                if (scissorState) {
                    GL11.glEnable((int)3089);
                }
            }
        });
    }

    @Override
    public void drawTexture(@NotNull UMatrixStack matrixStack, double x, double y, double width2, double height2, @NotNull Color color2) {
        Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
        Intrinsics.checkNotNullParameter((Object)color2, (String)"color");
        matrixStack.push();
        matrixStack.scale(1.0f, 1.0f, 50.0f);
        float red = (float)color2.getRed() / 255.0f;
        float green = (float)color2.getGreen() / 255.0f;
        float blue = (float)color2.getBlue() / 255.0f;
        float alpha2 = (float)color2.getAlpha() / 255.0f;
        VertexFormat vertexFormat = DefaultVertexFormat.f_85819_;
        Intrinsics.checkNotNullExpressionValue((Object)vertexFormat, (String)"POSITION_TEX_COLOR");
        UBufferBuilder worldRenderer = UBufferBuilder.Companion.create(UGraphics.DrawMode.QUADS, vertexFormat);
        worldRenderer.pos(matrixStack, x, y + height2, 0.0).tex(0.0, 0.0).color(red, green, blue, alpha2).endVertex();
        worldRenderer.pos(matrixStack, x + width2, y + height2, 0.0).tex(1.0, 0.0).color(red, green, blue, alpha2).endVertex();
        worldRenderer.pos(matrixStack, x + width2, y, 0.0).tex(1.0, 1.0).color(red, green, blue, alpha2).endVertex();
        worldRenderer.pos(matrixStack, x, y, 0.0).tex(0.0, 1.0).color(red, green, blue, alpha2).endVertex();
        UBuiltBuffer uBuiltBuffer = worldRenderer.build();
        if (uBuiltBuffer != null) {
            uBuiltBuffer.drawAndClose(PIPELINE, (Function1<? super DrawCallBuilder, Unit>)((Function1)new Function1<DrawCallBuilder, Unit>(this){
                final /* synthetic */ GlFrameBufferImpl this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull DrawCallBuilder $this$drawAndClose) {
                    Intrinsics.checkNotNullParameter((Object)$this$drawAndClose, (String)"$this$drawAndClose");
                    $this$drawAndClose.texture(0, this.this$0.getTexture().getGlId());
                }
            }));
        }
        matrixStack.pop();
    }

    @Override
    @NotNull
    public Function0<Unit> bind() {
        if (this.getFrameBuffer() == -1) {
            this.resize(this.getWidth(), this.getHeight());
        }
        return this.bind(this.getFrameBuffer());
    }

    private final Function0<Unit> bind(int glId) {
        int prevReadFrameBufferBinding = GL11.glGetInteger((int)36010);
        int prevDrawFrameBufferBinding = GL11.glGetInteger((int)36006);
        GL30.glBindFramebuffer((int)36160, (int)glId);
        return (Function0)new Function0<Unit>(prevReadFrameBufferBinding, prevDrawFrameBufferBinding){
            final /* synthetic */ int $prevReadFrameBufferBinding;
            final /* synthetic */ int $prevDrawFrameBufferBinding;
            {
                this.$prevReadFrameBufferBinding = $prevReadFrameBufferBinding;
                this.$prevDrawFrameBufferBinding = $prevDrawFrameBufferBinding;
                super(0);
            }

            public final void invoke() {
                GL30.glBindFramebuffer((int)36008, (int)this.$prevReadFrameBufferBinding);
                GL30.glBindFramebuffer((int)36009, (int)this.$prevDrawFrameBufferBinding);
            }
        };
    }

    @Override
    public void clear(@NotNull Color clearColor, double clearDepth, int clearStencil) {
        Intrinsics.checkNotNullParameter((Object)clearColor, (String)"clearColor");
        this.use((Function0)new Function0<Unit>(clearColor, clearDepth, clearStencil){
            final /* synthetic */ Color $clearColor;
            final /* synthetic */ double $clearDepth;
            final /* synthetic */ int $clearStencil;
            {
                this.$clearColor = $clearColor;
                this.$clearDepth = $clearDepth;
                this.$clearStencil = $clearStencil;
                super(0);
            }

            public final void invoke() {
                Color $this$invoke_u24lambda_u240 = this.$clearColor;
                boolean bl = false;
                UGraphics.clearColor((float)$this$invoke_u24lambda_u240.getRed() / 255.0f, (float)$this$invoke_u24lambda_u240.getGreen() / 255.0f, (float)$this$invoke_u24lambda_u240.getBlue() / 255.0f, (float)$this$invoke_u24lambda_u240.getAlpha() / 255.0f);
                UGraphics.clearDepth(this.$clearDepth);
                GL11.glClearStencil((int)this.$clearStencil);
                GL11.glClear((int)17664);
            }
        });
    }

    public static final /* synthetic */ GpuTexture.Format access$getDepthFormat$p(GlFrameBufferImpl $this) {
        return $this.depthFormat;
    }

    static {
        URenderPipeline.Builder builder;
        Companion = new Companion(null);
        URenderPipeline.Builder $this$PIPELINE_u24lambda_u240 = builder = URenderPipeline.Companion.builderWithDefaultShader("essential:framebuffer_texture", UGraphics.DrawMode.QUADS, UGraphics.CommonVertexFormats.POSITION_TEXTURE_COLOR);
        boolean bl = false;
        $this$PIPELINE_u24lambda_u240.setBlendState(BlendState.ALPHA);
        PIPELINE = builder.build();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lgg/essential/util/GlFrameBufferImpl$Companion;", "", "<init>", "()V", "Lgg/essential/universal/render/URenderPipeline;", "PIPELINE", "Lgg/essential/universal/render/URenderPipeline;", "Essential 1.20.1-forge"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

