/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.util;

import gg.essential.elementa.utils.ExtensionsKt;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0014\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B%\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\b\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0017\u001a\u00020\bH\u00c6\u0003J\t\u0010\u0018\u001a\u00020\bH\u00c6\u0003J\t\u0010\u0019\u001a\u00020\bH\u00c6\u0003J\t\u0010\u001a\u001a\u00020\bH\u00c6\u0003J1\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\n\u001a\u00020\b2\b\b\u0002\u0010\u000b\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001f\u001a\u00020\u0005H\u00d6\u0001J\u0006\u0010 \u001a\u00020\u0003J\t\u0010!\u001a\u00020\"H\u00d6\u0001R\u001a\u0010\u000b\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\n\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u000e\"\u0004\b\u0012\u0010\u0010R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u000e\"\u0004\b\u0014\u0010\u0010R\u001a\u0010\t\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u000e\"\u0004\b\u0016\u0010\u0010\u00a8\u0006#"}, d2={"Lgg/essential/util/HSBColor;", "", "color", "Ljava/awt/Color;", "(Ljava/awt/Color;)V", "", "(I)V", "hue", "", "saturation", "brightness", "alpha", "(FFFF)V", "getAlpha", "()F", "setAlpha", "(F)V", "getBrightness", "setBrightness", "getHue", "setHue", "getSaturation", "setSaturation", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toColor", "toString", "", "essential-gui-essential"})
public final class HSBColor {
    private float hue;
    private float saturation;
    private float brightness;
    private float alpha;

    public HSBColor(float hue, float saturation, float brightness, float alpha2) {
        this.hue = hue;
        this.saturation = saturation;
        this.brightness = brightness;
        this.alpha = alpha2;
    }

    public final float getHue() {
        return this.hue;
    }

    public final void setHue(float f) {
        this.hue = f;
    }

    public final float getSaturation() {
        return this.saturation;
    }

    public final void setSaturation(float f) {
        this.saturation = f;
    }

    public final float getBrightness() {
        return this.brightness;
    }

    public final void setBrightness(float f) {
        this.brightness = f;
    }

    public final float getAlpha() {
        return this.alpha;
    }

    public final void setAlpha(float f) {
        this.alpha = f;
    }

    public HSBColor(@NotNull Color color2) {
        Intrinsics.checkNotNullParameter((Object)color2, (String)"color");
        this(0.0f, 0.0f, 0.0f, (float)color2.getAlpha() / 255.0f);
        float[] hsb = Color.RGBtoHSB(color2.getRed(), color2.getGreen(), color2.getBlue(), null);
        this.hue = hsb[0];
        this.saturation = hsb[1];
        this.brightness = hsb[2];
    }

    public HSBColor(int color2) {
        this(new Color(color2));
    }

    @NotNull
    public final Color toColor() {
        return ExtensionsKt.withAlpha(new Color(Color.HSBtoRGB(this.hue, this.saturation, this.brightness)), this.alpha);
    }

    public final float component1() {
        return this.hue;
    }

    public final float component2() {
        return this.saturation;
    }

    public final float component3() {
        return this.brightness;
    }

    public final float component4() {
        return this.alpha;
    }

    @NotNull
    public final HSBColor copy(float hue, float saturation, float brightness, float alpha2) {
        return new HSBColor(hue, saturation, brightness, alpha2);
    }

    public static /* synthetic */ HSBColor copy$default(HSBColor hSBColor, float f, float f2, float f3, float f4, int n, Object object) {
        if ((n & 1) != 0) {
            f = hSBColor.hue;
        }
        if ((n & 2) != 0) {
            f2 = hSBColor.saturation;
        }
        if ((n & 4) != 0) {
            f3 = hSBColor.brightness;
        }
        if ((n & 8) != 0) {
            f4 = hSBColor.alpha;
        }
        return hSBColor.copy(f, f2, f3, f4);
    }

    @NotNull
    public String toString() {
        return "HSBColor(hue=" + this.hue + ", saturation=" + this.saturation + ", brightness=" + this.brightness + ", alpha=" + this.alpha + ')';
    }

    public int hashCode() {
        int result = Float.hashCode(this.hue);
        result = result * 31 + Float.hashCode(this.saturation);
        result = result * 31 + Float.hashCode(this.brightness);
        result = result * 31 + Float.hashCode(this.alpha);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof HSBColor)) {
            return false;
        }
        HSBColor hSBColor = (HSBColor)other;
        if (Float.compare(this.hue, hSBColor.hue) != 0) {
            return false;
        }
        if (Float.compare(this.saturation, hSBColor.saturation) != 0) {
            return false;
        }
        if (Float.compare(this.brightness, hSBColor.brightness) != 0) {
            return false;
        }
        return Float.compare(this.alpha, hSBColor.alpha) == 0;
    }
}

