/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.util;

import java.lang.reflect.Field;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.injection.InjectionPoint;
import org.spongepowered.asm.service.ITransformerProvider;
import org.spongepowered.asm.service.MixinService;
import org.spongepowered.asm.util.VersionNumber;

public class MixinUtils {
    private static final Logger logger = LogManager.getLogger();
    private static final VersionNumber MIXIN_0_8_2 = VersionNumber.parse((String)"0.8.2");
    private static final String ESSENTIAL_NAMESPACE = "ESSENTIAL";

    public static void addTransformerExclusion(String name2) {
        ITransformerProvider transformers = MixinService.getService().getTransformerProvider();
        if (transformers != null) {
            transformers.addTransformerExclusion(name2);
        }
    }

    public static void registerInjectionPoint(Class<? extends InjectionPoint> clazz) {
        InjectionPoint.AtCode atCode = clazz.getAnnotation(InjectionPoint.AtCode.class);
        if (atCode == null) {
            throw new IllegalArgumentException("Injection point class " + String.valueOf(clazz) + " is not annotated with @AtCode");
        }
        if (VersionNumber.parse((String)MixinEnvironment.getCurrentEnvironment().getVersion()).compareTo(MIXIN_0_8_2) > 0) {
            InjectionPoint.register(clazz, (String)ESSENTIAL_NAMESPACE);
        } else {
            try {
                Field typesField = InjectionPoint.class.getDeclaredField("types");
                typesField.setAccessible(true);
                Map types2 = (Map)typesField.get(null);
                types2.put("ESSENTIAL:" + atCode.value(), clazz);
            }
            catch (Throwable t) {
                logger.error("Failed to register InjectionPoint class " + String.valueOf(clazz) + ":", t);
            }
        }
    }
}

