/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.vigilance.gui.settings;

import gg.essential.elementa.UIComponent;
import gg.essential.elementa.UIConstraints;
import gg.essential.elementa.components.UIBlock;
import gg.essential.elementa.components.UIContainer;
import gg.essential.elementa.components.UIImage;
import gg.essential.elementa.components.UIText;
import gg.essential.elementa.constraints.CenterConstraint;
import gg.essential.elementa.constraints.FillConstraint;
import gg.essential.elementa.constraints.HeightConstraint;
import gg.essential.elementa.constraints.RelativeConstraint;
import gg.essential.elementa.constraints.SiblingConstraint;
import gg.essential.elementa.constraints.SuperConstraint;
import gg.essential.elementa.constraints.XConstraint;
import gg.essential.elementa.constraints.YConstraint;
import gg.essential.elementa.dsl.ComponentsKt;
import gg.essential.elementa.dsl.ConstraintsKt;
import gg.essential.elementa.dsl.UtilitiesKt;
import gg.essential.elementa.effects.OutlineEffect;
import gg.essential.elementa.events.UIClickEvent;
import gg.essential.elementa.state.ExtensionsKt;
import gg.essential.elementa.state.State;
import gg.essential.universal.UGraphics;
import gg.essential.universal.UMatrixStack;
import gg.essential.universal.USound;
import gg.essential.vigilance.gui.VigilancePalette;
import gg.essential.vigilance.gui.settings.ColorPicker;
import gg.essential.vigilance.gui.settings.Slider;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.ClosedFloatingPointRange;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\f\u0018\u0000 82\u00020\u0001:\u00018B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u001b\u001a\u00020\u0019H\u0002J\u0018\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0018\u0010!\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J0\u0010\"\u001a\u00020\u00192\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020&2\u0006\u0010(\u001a\u00020\u0003H\u0002J \u0010)\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u000e2\u0006\u0010'\u001a\u00020\u000e2\u0006\u0010*\u001a\u00020\u000eH\u0002J\u0006\u0010+\u001a\u00020\u0003J\b\u0010,\u001a\u00020-H\u0002J\u001a\u0010\u0017\u001a\u00020\u00192\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00190\u0018J\b\u0010/\u001a\u00020\u0019H\u0002J\u000e\u00100\u001a\u00020\u00192\u0006\u00101\u001a\u00020\u000eJ\u001e\u00102\u001a\u00020\u00192\u0006\u0010*\u001a\u00020\u000e2\u0006\u00103\u001a\u00020\u000e2\u0006\u00104\u001a\u00020\u000eJ\b\u00105\u001a\u00020\u0019H\u0002J\b\u00106\u001a\u00020\u0019H\u0002J\b\u00107\u001a\u00020\u0019H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00190\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lgg/essential/vigilance/gui/settings/ColorPicker;", "Lgg/essential/elementa/components/UIContainer;", "initial", "Ljava/awt/Color;", "allowAlpha", "", "(Ljava/awt/Color;Z)V", "alphaSlider", "Lgg/essential/vigilance/gui/settings/Slider;", "alphaText", "Lgg/essential/elementa/components/UIText;", "bigPickerBox", "Lgg/essential/elementa/components/UIBlock;", "currentAlpha", "", "currentBrightness", "currentHue", "currentSaturation", "draggingHue", "draggingPicker", "hueIndicator", "Lgg/essential/elementa/components/UIImage;", "huePickerLine", "onValueChange", "Lkotlin/Function1;", "", "pickerIndicator", "cleanupDraw", "drawColorPicker", "matrixStack", "Lgg/essential/universal/UMatrixStack;", "component", "Lgg/essential/elementa/UIComponent;", "drawHueLine", "drawVertex", "graphics", "Lgg/essential/universal/UGraphics;", "x", "", "y", "color", "getColor", "hue", "getCurrentColor", "getFormattedAlpha", "", "listener", "recalculateColor", "setAlpha", "alpha", "setHSB", "sat", "bright", "setupDraw", "updateHueIndicator", "updatePickerIndicator", "Companion", "Vigilance"})
@SourceDebugExtension(value={"SMAP\nColorPicker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ColorPicker.kt\ngg/essential/vigilance/gui/settings/ColorPicker\n+ 2 components.kt\ngg/essential/elementa/dsl/ComponentsKt\n+ 3 Extensions.kt\ngg/essential/vigilance/utils/ExtensionsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,300:1\n9#2,3:301\n9#2,3:304\n9#2,3:307\n9#2,3:310\n9#2,3:313\n9#2,3:316\n9#2,3:319\n9#2,3:327\n22#3,5:322\n22#3,5:330\n1547#4:335\n1618#4,3:336\n*S KotlinDebug\n*F\n+ 1 ColorPicker.kt\ngg/essential/vigilance/gui/settings/ColorPicker\n*L\n36#1:301,3\n42#1:304,3\n49#1:307,3\n56#1:310,3\n62#1:313,3\n69#1:316,3\n98#1:319,3\n127#1:327,3\n105#1:322,5\n134#1:330,5\n297#1:335\n297#1:336,3\n*E\n"})
public final class ColorPicker
extends UIContainer {
    @NotNull
    public static final Companion Companion;
    private float currentHue;
    private float currentSaturation;
    private float currentBrightness;
    private float currentAlpha;
    @NotNull
    private Function1<? super Color, Unit> onValueChange;
    private boolean draggingHue;
    private boolean draggingPicker;
    @NotNull
    private final UIBlock bigPickerBox;
    @NotNull
    private final UIContainer pickerIndicator;
    @NotNull
    private final UIBlock huePickerLine;
    @NotNull
    private final UIImage hueIndicator;
    @NotNull
    private final Slider alphaSlider;
    @NotNull
    private final UIText alphaText;
    @NotNull
    private static final List<Color> hueColorList;

    /*
     * WARNING - void declaration
     */
    public ColorPicker(@NotNull Color initial, boolean allowAlpha) {
        void $this$_init__u24lambda_u248;
        UIConstraints $this$_init__u24lambda_u246;
        UIConstraints $this$alphaText_u24lambda_u245;
        UIConstraints $this$alphaSlider_u24lambda_u244;
        UIConstraints $this$hueIndicator_u24lambda_u243;
        UIConstraints $this$huePickerLine_u24lambda_u242;
        UIConstraints $this$pickerIndicator_u24lambda_u241;
        UIConstraints $this$bigPickerBox_u24lambda_u240;
        UIComponent uIComponent;
        Intrinsics.checkNotNullParameter((Object)initial, (String)"initial");
        this.currentAlpha = (float)initial.getAlpha() / 255.0f;
        float[] hsb = Color.RGBtoHSB(initial.getRed(), initial.getGreen(), initial.getBlue(), null);
        this.currentHue = hsb[0];
        this.currentSaturation = hsb[1];
        this.currentBrightness = hsb[2];
        this.onValueChange = onValueChange.1.INSTANCE;
        UIComponent $this$constrain$iv = new UIBlock(null, 1, null);
        boolean $i$f$constrain = false;
        UIComponent $this$constrain_u24lambda_u240$iv = uIComponent = $this$constrain$iv;
        boolean bl = false;
        UIConstraints uIConstraints = $this$constrain_u24lambda_u240$iv.getConstraints();
        UIComponent uIComponent2 = this;
        boolean bl2 = false;
        $this$bigPickerBox_u24lambda_u240.setWidth(UtilitiesKt.getPercent(80));
        $this$bigPickerBox_u24lambda_u240.setHeight(allowAlpha ? (HeightConstraint)UtilitiesKt.getPercent(80) : (HeightConstraint)UtilitiesKt.getPercent(100));
        $this$bigPickerBox_u24lambda_u240.setColor(ExtensionsKt.toConstraint((State<Color>)VigilancePalette.INSTANCE.getComponentBorder$Vigilance()));
        ((ColorPicker)uIComponent2).bigPickerBox = (UIBlock)ComponentsKt.childOf(uIComponent, this);
        $this$constrain$iv = new UIContainer();
        $i$f$constrain = false;
        $this$constrain_u24lambda_u240$iv = uIComponent = $this$constrain$iv;
        bl = false;
        $this$bigPickerBox_u24lambda_u240 = $this$constrain_u24lambda_u240$iv.getConstraints();
        uIComponent2 = this;
        boolean bl3 = false;
        $this$pickerIndicator_u24lambda_u241.setX(ConstraintsKt.coerceIn(ConstraintsKt.minus(new RelativeConstraint(this.currentSaturation), UtilitiesKt.getPixels(Float.valueOf(3.5f))), UtilitiesKt.getPixels(2), UtilitiesKt.pixels$default(2, true, false, 2, null)));
        $this$pickerIndicator_u24lambda_u241.setY(ConstraintsKt.coerceIn(ConstraintsKt.minus(new RelativeConstraint(1.0f - this.currentBrightness), UtilitiesKt.getPixels(Float.valueOf(3.5f))), UtilitiesKt.getPixels(2), UtilitiesKt.pixels$default(2, true, false, 2, null)));
        $this$pickerIndicator_u24lambda_u241.setWidth(UtilitiesKt.getPixels(3));
        $this$pickerIndicator_u24lambda_u241.setHeight(UtilitiesKt.getPixels(3));
        Color color2 = Color.WHITE;
        Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"WHITE");
        ((ColorPicker)uIComponent2).pickerIndicator = (UIContainer)ComponentsKt.effect(uIComponent, new OutlineEffect(color2, 1.0f, false, false, null, 28, null));
        $this$constrain$iv = new UIBlock(null, 1, null);
        $i$f$constrain = false;
        $this$constrain_u24lambda_u240$iv = uIComponent = $this$constrain$iv;
        bl = false;
        $this$pickerIndicator_u24lambda_u241 = $this$constrain_u24lambda_u240$iv.getConstraints();
        uIComponent2 = this;
        boolean bl4 = false;
        $this$huePickerLine_u24lambda_u242.setX(UtilitiesKt.getPercent(85));
        $this$huePickerLine_u24lambda_u242.setWidth(new FillConstraint(false));
        $this$huePickerLine_u24lambda_u242.setHeight(allowAlpha ? (HeightConstraint)UtilitiesKt.getPercent(80) : (HeightConstraint)UtilitiesKt.getPercent(100));
        $this$huePickerLine_u24lambda_u242.setColor(ExtensionsKt.toConstraint((State<Color>)VigilancePalette.INSTANCE.getComponentBorder$Vigilance()));
        ((ColorPicker)uIComponent2).huePickerLine = (UIBlock)ComponentsKt.childOf(uIComponent, this);
        $this$constrain$iv = VigilancePalette.INSTANCE.getARROW_LEFT_4X7$Vigilance().create();
        $i$f$constrain = false;
        $this$constrain_u24lambda_u240$iv = uIComponent = $this$constrain$iv;
        bl = false;
        $this$huePickerLine_u24lambda_u242 = $this$constrain_u24lambda_u240$iv.getConstraints();
        uIComponent2 = this;
        boolean bl5 = false;
        $this$hueIndicator_u24lambda_u243.setX(UtilitiesKt.pixels$default(-4, true, false, 2, null));
        $this$hueIndicator_u24lambda_u243.setY(ConstraintsKt.minus(new RelativeConstraint(this.currentHue), UtilitiesKt.getPixels(3)));
        $this$hueIndicator_u24lambda_u243.setColor(ExtensionsKt.toConstraint((State<Color>)VigilancePalette.INSTANCE.getTextHighlight$Vigilance()));
        ((ColorPicker)uIComponent2).hueIndicator = (UIImage)uIComponent;
        $this$constrain$iv = new Slider(this.currentAlpha);
        $i$f$constrain = false;
        $this$constrain_u24lambda_u240$iv = uIComponent = $this$constrain$iv;
        bl = false;
        $this$hueIndicator_u24lambda_u243 = $this$constrain_u24lambda_u240$iv.getConstraints();
        uIComponent2 = this;
        boolean bl6 = false;
        $this$alphaSlider_u24lambda_u244.setX((XConstraint)ConstraintsKt.boundTo((SuperConstraint)new CenterConstraint(), this.bigPickerBox));
        $this$alphaSlider_u24lambda_u244.setY(new SiblingConstraint(5.0f, false, 2, null));
        $this$alphaSlider_u24lambda_u244.setWidth(UtilitiesKt.getPercent(80));
        $this$alphaSlider_u24lambda_u244.setHeight(new FillConstraint(false));
        ((ColorPicker)uIComponent2).alphaSlider = (Slider)uIComponent;
        $this$constrain$iv = new UIText(this.getFormattedAlpha(), false, null, 6, null);
        $i$f$constrain = false;
        $this$constrain_u24lambda_u240$iv = uIComponent = $this$constrain$iv;
        bl = false;
        $this$alphaSlider_u24lambda_u244 = $this$constrain_u24lambda_u240$iv.getConstraints();
        uIComponent2 = this;
        boolean bl7 = false;
        $this$alphaText_u24lambda_u245.setX(UtilitiesKt.getPercent(85));
        $this$alphaText_u24lambda_u245.setY((YConstraint)ConstraintsKt.boundTo((SuperConstraint)new CenterConstraint(), this.alphaSlider));
        $this$alphaText_u24lambda_u245.setTextScale(UtilitiesKt.getPixels(Float.valueOf(2.0f / 3.0f)));
        $this$alphaText_u24lambda_u245.setColor(ExtensionsKt.toConstraint((State<Color>)VigilancePalette.INSTANCE.getText$Vigilance()));
        $this$alphaText_u24lambda_u245.setFontProvider(this.getFontProvider());
        ((ColorPicker)uIComponent2).alphaText = (UIText)uIComponent;
        if (allowAlpha) {
            ComponentsKt.childOf((UIComponent)this.alphaSlider, this);
            ComponentsKt.childOf((UIComponent)this.alphaText, this);
            this.alphaSlider.onValueChange((Function1<? super Float, Unit>)((Function1)new Function1<Float, Unit>(){

                public final void invoke(float newAlpha) {
                    currentAlpha = newAlpha;
                    alphaText.setText(this.getFormattedAlpha());
                    this.recalculateColor();
                }
            }));
        }
        $this$constrain$iv = new UIComponent(){

            @Override
            public void draw(@NotNull UMatrixStack matrixStack) {
                Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
                super.beforeDraw(matrixStack);
                this.drawHueLine(matrixStack, this);
                super.draw(matrixStack);
            }
        };
        $i$f$constrain = false;
        $this$constrain_u24lambda_u240$iv = uIComponent = $this$constrain$iv;
        bl = false;
        $this$alphaText_u24lambda_u245 = $this$constrain_u24lambda_u240$iv.getConstraints();
        uIComponent2 = this.huePickerLine;
        boolean bl8 = false;
        $this$_init__u24lambda_u246.setX(new CenterConstraint());
        $this$_init__u24lambda_u246.setY(new CenterConstraint());
        $this$_init__u24lambda_u246.setWidth(ConstraintsKt.minus(UtilitiesKt.getPercent(100), UtilitiesKt.getPixels(2)));
        $this$_init__u24lambda_u246.setHeight(ConstraintsKt.minus(UtilitiesKt.getPercent(100), UtilitiesKt.getPixels(2)));
        uIComponent2.addChild(uIComponent).addChild(this.hueIndicator);
        UIComponent $this$onLeftClick$iv = this.huePickerLine;
        boolean $i$f$onLeftClick = false;
        $this$onLeftClick$iv.onMouseClick((Function2<? super UIComponent, ? super UIClickEvent, Unit>)((Function2)new Function2<UIComponent, UIClickEvent, Unit>(this){
            final /* synthetic */ ColorPicker this$0;
            {
                this.this$0 = colorPicker;
                super(2);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull UIComponent $this$onMouseClick, @NotNull UIClickEvent it) {
                Intrinsics.checkNotNullParameter((Object)$this$onMouseClick, (String)"$this$onMouseClick");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (it.getMouseButton() == 0) {
                    void event;
                    UIClickEvent uIClickEvent = it;
                    UIComponent $this$_init__u24lambda_u247 = $this$onMouseClick;
                    boolean bl = false;
                    USound.playButtonPress$default(USound.INSTANCE, 0.0f, 1, null);
                    ColorPicker.access$setDraggingHue$p(this.this$0, true);
                    ColorPicker.access$setCurrentHue$p(this.this$0, (event.getRelativeY() - 1.0f) / ColorPicker.access$getHuePickerLine$p(this.this$0).getHeight());
                    ColorPicker.access$updateHueIndicator(this.this$0);
                }
            }
        })).onMouseDrag((Function4<? super UIComponent, ? super Float, ? super Float, ? super Integer, Unit>)((Function4)new Function4<UIComponent, Float, Float, Integer, Unit>(){

            public final void invoke(@NotNull UIComponent $this$onMouseDrag, float f, float mouseY, int n) {
                Intrinsics.checkNotNullParameter((Object)$this$onMouseDrag, (String)"$this$onMouseDrag");
                if (!draggingHue) {
                    return;
                }
                currentHue = ((Number)((Object)RangesKt.coerceIn((Comparable)Float.valueOf((mouseY - 1.0f) / huePickerLine.getHeight()), (ClosedFloatingPointRange)RangesKt.rangeTo((float)0.0f, (float)1.0f)))).floatValue();
                this.updateHueIndicator();
            }
        })).onMouseRelease((Function1<? super UIComponent, Unit>)((Function1)new Function1<UIComponent, Unit>(){

            public final void invoke(@NotNull UIComponent $this$onMouseRelease) {
                Intrinsics.checkNotNullParameter((Object)$this$onMouseRelease, (String)"$this$onMouseRelease");
                draggingHue = false;
            }
        }));
        $this$constrain$iv = new UIComponent(){

            @Override
            public void draw(@NotNull UMatrixStack matrixStack) {
                Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
                super.beforeDraw(matrixStack);
                this.drawColorPicker(matrixStack, this);
                super.draw(matrixStack);
            }
        };
        $i$f$constrain = false;
        $this$constrain_u24lambda_u240$iv = uIComponent = $this$constrain$iv;
        bl = false;
        $this$_init__u24lambda_u246 = $this$constrain_u24lambda_u240$iv.getConstraints();
        uIComponent2 = this.bigPickerBox;
        boolean bl9 = false;
        $this$_init__u24lambda_u248.setX(new CenterConstraint());
        $this$_init__u24lambda_u248.setY(new CenterConstraint());
        $this$_init__u24lambda_u248.setWidth(ConstraintsKt.minus(UtilitiesKt.getPercent(100), UtilitiesKt.getPixels(2)));
        $this$_init__u24lambda_u248.setHeight(ConstraintsKt.minus(UtilitiesKt.getPercent(100), UtilitiesKt.getPixels(2)));
        uIComponent2.addChild(uIComponent).addChild(this.pickerIndicator);
        $this$onLeftClick$iv = this.bigPickerBox;
        $i$f$onLeftClick = false;
        $this$onLeftClick$iv.onMouseClick((Function2<? super UIComponent, ? super UIClickEvent, Unit>)((Function2)new Function2<UIComponent, UIClickEvent, Unit>(this){
            final /* synthetic */ ColorPicker this$0;
            {
                this.this$0 = colorPicker;
                super(2);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull UIComponent $this$onMouseClick, @NotNull UIClickEvent it) {
                Intrinsics.checkNotNullParameter((Object)$this$onMouseClick, (String)"$this$onMouseClick");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (it.getMouseButton() == 0) {
                    void event;
                    UIClickEvent uIClickEvent = it;
                    UIComponent $this$_init__u24lambda_u249 = $this$onMouseClick;
                    boolean bl = false;
                    USound.playButtonPress$default(USound.INSTANCE, 0.0f, 1, null);
                    ColorPicker.access$setDraggingPicker$p(this.this$0, true);
                    ColorPicker.access$setCurrentSaturation$p(this.this$0, event.getRelativeX() / ColorPicker.access$getBigPickerBox$p(this.this$0).getWidth());
                    ColorPicker.access$setCurrentBrightness$p(this.this$0, 1.0f - event.getRelativeY() / ColorPicker.access$getBigPickerBox$p(this.this$0).getHeight());
                    ColorPicker.access$updatePickerIndicator(this.this$0);
                }
            }
        })).onMouseDrag((Function4<? super UIComponent, ? super Float, ? super Float, ? super Integer, Unit>)((Function4)new Function4<UIComponent, Float, Float, Integer, Unit>(){

            public final void invoke(@NotNull UIComponent $this$onMouseDrag, float mouseX, float mouseY, int n) {
                Intrinsics.checkNotNullParameter((Object)$this$onMouseDrag, (String)"$this$onMouseDrag");
                if (!draggingPicker) {
                    return;
                }
                currentSaturation = ((Number)((Object)RangesKt.coerceIn((Comparable)Float.valueOf(mouseX / bigPickerBox.getWidth()), (ClosedFloatingPointRange)RangesKt.rangeTo((float)0.0f, (float)1.0f)))).floatValue();
                currentBrightness = 1.0f - ((Number)((Object)RangesKt.coerceIn((Comparable)Float.valueOf(mouseY / bigPickerBox.getHeight()), (ClosedFloatingPointRange)RangesKt.rangeTo((float)0.0f, (float)1.0f)))).floatValue();
                this.updatePickerIndicator();
            }
        })).onMouseRelease((Function1<? super UIComponent, Unit>)((Function1)new Function1<UIComponent, Unit>(){

            public final void invoke(@NotNull UIComponent $this$onMouseRelease) {
                Intrinsics.checkNotNullParameter((Object)$this$onMouseRelease, (String)"$this$onMouseRelease");
                draggingPicker = false;
            }
        }));
    }

    private final void updateHueIndicator() {
        this.hueIndicator.setY(ConstraintsKt.minus(new RelativeConstraint(RangesKt.coerceAtMost((float)this.currentHue, (float)0.98f)), UtilitiesKt.getPixels(3)));
        this.recalculateColor();
    }

    private final void updatePickerIndicator() {
        this.pickerIndicator.setX(ConstraintsKt.coerceIn(ConstraintsKt.minus(new RelativeConstraint(this.currentSaturation), UtilitiesKt.getPixels(Float.valueOf(2.5f))), UtilitiesKt.getPixels(2), UtilitiesKt.pixels$default(2, true, false, 2, null)));
        this.pickerIndicator.setY(ConstraintsKt.coerceIn(ConstraintsKt.minus(new RelativeConstraint(1.0f - this.currentBrightness), UtilitiesKt.getPixels(Float.valueOf(2.5f))), UtilitiesKt.getPixels(2), UtilitiesKt.pixels$default(2, true, false, 2, null)));
        this.recalculateColor();
    }

    private final void recalculateColor() {
        this.onValueChange.invoke((Object)this.getCurrentColor());
    }

    @NotNull
    public final Color getCurrentColor() {
        return new Color(Color.HSBtoRGB(this.currentHue, this.currentSaturation, this.currentBrightness) & 0xFFFFFF | MathKt.roundToInt((float)(this.currentAlpha * 255.0f)) << 24, true);
    }

    public final void setHSB(float hue, float sat, float bright) {
        this.currentHue = hue;
        this.currentSaturation = sat;
        this.currentBrightness = bright;
        this.updateHueIndicator();
        this.updatePickerIndicator();
        this.recalculateColor();
    }

    public final void setAlpha(float alpha2) {
        this.currentAlpha = alpha2;
        Slider.setCurrentPercentage$default(this.alphaSlider, alpha2, false, 2, null);
        this.recalculateColor();
    }

    public final void onValueChange(@NotNull Function1<? super Color, Unit> listener2) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        this.onValueChange = listener2;
    }

    private final void drawColorPicker(UMatrixStack matrixStack, UIComponent component3) {
        double left2 = component3.getLeft();
        double top = component3.getTop();
        double right = component3.getRight();
        double bottom = component3.getBottom();
        this.setupDraw();
        UGraphics graphics = UGraphics.getFromTessellator();
        graphics.beginWithDefaultShader(UGraphics.DrawMode.QUADS, UGraphics.CommonVertexFormats.POSITION_COLOR);
        double height2 = bottom - top;
        for (int x = 0; x < 50; ++x) {
            double curLeft = left2 + (double)((float)(right - left2) * (float)x / 50.0f);
            double curRight = left2 + (double)((float)(right - left2) * ((float)x + 1.0f) / 50.0f);
            boolean first = true;
            for (int y = 0; y < 51; ++y) {
                double yPos = top + (double)y * height2 / 50.0;
                Color color2 = this.getColor((float)x / 50.0f, 1.0f - (float)y / 50.0f, this.currentHue);
                if (!first) {
                    Intrinsics.checkNotNull((Object)graphics);
                    this.drawVertex(graphics, matrixStack, curLeft, yPos, color2);
                    this.drawVertex(graphics, matrixStack, curRight, yPos, color2);
                }
                if (y < 50) {
                    Intrinsics.checkNotNull((Object)graphics);
                    this.drawVertex(graphics, matrixStack, curRight, yPos, color2);
                    this.drawVertex(graphics, matrixStack, curLeft, yPos, color2);
                }
                first = false;
            }
        }
        graphics.drawDirect();
        this.cleanupDraw();
    }

    private final Color getColor(float x, float y, float hue) {
        return new Color(Color.HSBtoRGB(hue, x, y));
    }

    private final void drawHueLine(UMatrixStack matrixStack, UIComponent component3) {
        double left2 = component3.getLeft();
        double top = component3.getTop();
        double right = component3.getRight();
        double height2 = component3.getHeight();
        this.setupDraw();
        UGraphics graphics = UGraphics.getFromTessellator();
        graphics.beginWithDefaultShader(UGraphics.DrawMode.QUADS, UGraphics.CommonVertexFormats.POSITION_COLOR);
        boolean first = true;
        Iterator<Color> iterator2 = hueColorList.iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int i2 = n++;
            Color color2 = iterator2.next();
            double yPos = top + (double)i2 * height2 / 50.0;
            if (!first) {
                Intrinsics.checkNotNull((Object)graphics);
                this.drawVertex(graphics, matrixStack, left2, yPos, color2);
                this.drawVertex(graphics, matrixStack, right, yPos, color2);
            }
            Intrinsics.checkNotNull((Object)graphics);
            this.drawVertex(graphics, matrixStack, right, yPos, color2);
            this.drawVertex(graphics, matrixStack, left2, yPos, color2);
            first = false;
        }
        graphics.drawDirect();
        this.cleanupDraw();
    }

    private final void setupDraw() {
        UGraphics.enableBlend();
        UGraphics.disableAlpha();
        UGraphics.tryBlendFuncSeparate(770, 771, 1, 0);
        UGraphics.shadeModel(7425);
    }

    private final void cleanupDraw() {
        UGraphics.shadeModel(7424);
        UGraphics.disableBlend();
        UGraphics.enableAlpha();
    }

    private final void drawVertex(UGraphics graphics, UMatrixStack matrixStack, double x, double y, Color color2) {
        graphics.pos(matrixStack, x, y, 0.0).color((float)color2.getRed() / 255.0f, (float)color2.getGreen() / 255.0f, (float)color2.getBlue() / 255.0f, 1.0f).endVertex();
    }

    private final String getFormattedAlpha() {
        String string = "%.2f";
        Locale locale = Locale.US;
        Object[] objectArray = new Object[]{Float.valueOf(this.alphaSlider.getCurrentPercentage())};
        String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(locale, this, *args)");
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$mapTo$iv$iv;
        Companion = new Companion(null);
        Iterable $this$map$iv = (Iterable)new IntRange(0, 50);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void i2;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Color(Color.HSBtoRGB((float)i2 / 50.0f, 1.0f, 0.7f)));
        }
        hueColorList = (List)var3_3;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lgg/essential/vigilance/gui/settings/ColorPicker$Companion;", "", "()V", "hueColorList", "", "Ljava/awt/Color;", "Vigilance"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

