/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.worldgen.lost.regassets;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import mcjty.lostcities.worldgen.lost.regassets.IAsset;
import mcjty.lostcities.worldgen.lost.regassets.PaletteRE;
import mcjty.lostcities.worldgen.lost.regassets.data.PartMeta;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class BuildingPartRE
implements IAsset<BuildingPartRE> {
    public static final Codec<BuildingPartRE> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("xsize").forGetter(l -> l.xSize), (App)Codec.INT.fieldOf("zsize").forGetter(l -> l.zSize), (App)Codec.list((Codec)Codec.list((Codec)Codec.STRING)).fieldOf("slices").forGetter(BuildingPartRE::createSlices), (App)Codec.STRING.optionalFieldOf("refpalette").forGetter(l -> Optional.ofNullable(l.refPaletteName)), (App)PaletteRE.CODEC.optionalFieldOf("palette").forGetter(l -> Optional.ofNullable(l.localPalette)), (App)Codec.list(PartMeta.CODEC).optionalFieldOf("meta").forGetter(l -> Optional.ofNullable(l.metadata))).apply((Applicative)instance, BuildingPartRE::new));
    private ResourceLocation name;
    private final String[] slices;
    private final int xSize;
    private final int zSize;
    private PaletteRE localPalette = null;
    private final String refPaletteName;
    private final List<PartMeta> metadata;

    public BuildingPartRE(int xSize, int zSize, List<List<String>> slices, Optional<String> refpalette, Optional<PaletteRE> locpalette, Optional<List<PartMeta>> metadata) {
        this.slices = new String[slices.size()];
        int idx = 0;
        for (List<String> slice : slices) {
            StringBuilder builder = new StringBuilder();
            for (String s : slice) {
                builder.append(s);
            }
            this.slices[idx++] = builder.toString();
        }
        this.xSize = xSize;
        this.zSize = zSize;
        this.refPaletteName = refpalette.orElse(null);
        this.localPalette = locpalette.orElse(null);
        this.metadata = metadata.orElse(null);
    }

    private List<List<String>> createSlices() {
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        for (String slice : this.slices) {
            ArrayList<String> s = new ArrayList<String>();
            for (int z = 0; z < this.zSize; ++z) {
                String sub = slice.substring(z * this.xSize, z * this.xSize + this.xSize);
                s.add(sub);
            }
            result.add(s);
        }
        return result;
    }

    public List<PartMeta> getMetadata() {
        return this.metadata;
    }

    public String[] getSlices() {
        return this.slices;
    }

    public int getxSize() {
        return this.xSize;
    }

    public int getzSize() {
        return this.zSize;
    }

    public PaletteRE getLocalPalette() {
        return this.localPalette;
    }

    public String getRefPaletteName() {
        return this.refPaletteName;
    }

    @Override
    public BuildingPartRE setRegistryName(ResourceLocation name) {
        this.name = name;
        return this;
    }

    @Nullable
    public ResourceLocation getRegistryName() {
        return this.name;
    }
}

