/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.worldgen.lost.regassets;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import mcjty.lostcities.worldgen.lost.regassets.IAsset;
import mcjty.lostcities.worldgen.lost.regassets.data.PredefinedBuilding;
import mcjty.lostcities.worldgen.lost.regassets.data.PredefinedStreet;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class PredefinedCityRE
implements IAsset<PredefinedCityRE> {
    public static final Codec<PredefinedCityRE> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("dimension").forGetter(l -> l.dimension), (App)Codec.INT.fieldOf("chunkx").forGetter(l -> l.chunkX), (App)Codec.INT.fieldOf("chunkz").forGetter(l -> l.chunkZ), (App)Codec.INT.fieldOf("radius").forGetter(l -> l.radius), (App)Codec.STRING.fieldOf("citystyle").forGetter(l -> l.cityStyle), (App)Codec.list(PredefinedBuilding.CODEC).optionalFieldOf("buildings").forGetter(l -> Optional.ofNullable(l.predefinedBuildings)), (App)Codec.list(PredefinedStreet.CODEC).optionalFieldOf("streets").forGetter(l -> Optional.ofNullable(l.predefinedStreets))).apply((Applicative)instance, PredefinedCityRE::new));
    private ResourceLocation name;
    private final String dimension;
    private final int chunkX;
    private final int chunkZ;
    private final int radius;
    private final String cityStyle;
    private final List<PredefinedBuilding> predefinedBuildings;
    private final List<PredefinedStreet> predefinedStreets;

    public PredefinedCityRE(String dimension, int chunkX, int chunkZ, int radius, String cityStyle, Optional<List<PredefinedBuilding>> predefinedBuildings, Optional<List<PredefinedStreet>> predefinedStreets) {
        this.dimension = dimension;
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
        this.radius = radius;
        this.cityStyle = cityStyle;
        this.predefinedBuildings = predefinedBuildings.orElse(null);
        this.predefinedStreets = predefinedStreets.orElse(null);
    }

    public String getDimension() {
        return this.dimension;
    }

    public int getChunkX() {
        return this.chunkX;
    }

    public int getChunkZ() {
        return this.chunkZ;
    }

    public int getRadius() {
        return this.radius;
    }

    public String getCityStyle() {
        return this.cityStyle;
    }

    public List<PredefinedBuilding> getPredefinedBuildings() {
        return this.predefinedBuildings;
    }

    public List<PredefinedStreet> getPredefinedStreets() {
        return this.predefinedStreets;
    }

    @Override
    public PredefinedCityRE setRegistryName(ResourceLocation name) {
        this.name = name;
        return this;
    }

    @Nullable
    public ResourceLocation getRegistryName() {
        return this.name;
    }
}

