/*
 * Decompiled with CFR 0.152.
 */
package com.jtorleonstudios.libraryferret.conf;

public class Props {
    private final String key;
    private final String type;
    private final String group;
    private final String name;
    private final String defaultValue;

    private Props(String type, String group, String name, String defaultValue) {
        this.type = type.toLowerCase();
        this.group = group.toLowerCase();
        this.name = name.toLowerCase();
        this.key = type + "." + group + "." + name;
        this.defaultValue = defaultValue;
    }

    public static Props create(String type, String group, String name, String defaultValue) {
        return new Props(type, group, name, defaultValue);
    }

    public static Props create(String group, String name, String defaultValue) {
        return Props.create("string", group, name, defaultValue);
    }

    public static Props create(String group, String name, char defaultValue) {
        return Props.create("char", group, name, "" + defaultValue);
    }

    public static Props create(String group, String name, boolean defaultValue) {
        return Props.create("boolean", group, name, defaultValue ? "true" : "false");
    }

    public static Props create(String group, String name, int defaultValue) {
        return Props.create("int", group, name, Integer.toString(defaultValue));
    }

    public static Props create(String group, String name, double defaultValue) {
        return Props.create("double", group, name, Double.toString(defaultValue));
    }

    public static Props create(String group, String name, float defaultValue) {
        return Props.create("float", group, name, Float.toString(defaultValue));
    }

    public static Props create(String group, String name, long defaultValue) {
        return Props.create("long", group, name, Long.toString(defaultValue));
    }

    public String getKey() {
        return this.key;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getType() {
        return this.type;
    }

    public String getGroup() {
        return this.group;
    }

    public String getName() {
        return this.name;
    }
}

