/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.craftingtweaks.client;

import com.google.common.collect.ArrayListMultimap;
import java.util.Collection;
import java.util.Objects;
import net.blay09.mods.craftingtweaks.CompressType;
import net.blay09.mods.craftingtweaks.InventoryCraftingCompress;
import net.blay09.mods.craftingtweaks.api.CraftingGrid;
import net.blay09.mods.craftingtweaks.config.CraftingTweaksConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.recipebook.RecipeCollection;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.RecipeHolder;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;

public class ClientProvider {
    private final SimpleContainer lastCraftedMatrix = new SimpleContainer(9);
    private boolean hasLastCraftedMatrix;

    private MultiPlayerGameMode getController() {
        return Minecraft.m_91087_().f_91072_;
    }

    public void balanceGrid(Player entityPlayer, AbstractContainerMenu container, CraftingGrid grid) {
        ArrayListMultimap balanceSlots = ArrayListMultimap.create();
        int start = grid.getGridStartSlot(entityPlayer, container);
        int size = grid.getGridSize(entityPlayer, container);
        for (int i = start; i < start + size; ++i) {
            ItemStack itemStack;
            Slot slot = (Slot)container.f_38839_.get(i);
            if (!slot.m_6657_() || (itemStack = slot.m_7993_()).m_41619_()) continue;
            ResourceLocation registryName = BuiltInRegistries.f_257033_.m_7981_((Object)itemStack.m_41720_());
            balanceSlots.put((Object)Objects.toString(registryName), (Object)slot);
        }
        for (String key : balanceSlots.keySet()) {
            ItemStack itemStack;
            Collection slotList = balanceSlots.get((Object)key);
            int average = 0;
            for (Slot slot : slotList) {
                itemStack = slot.m_7993_();
                if (itemStack.m_41619_()) continue;
                average += itemStack.m_41613_();
            }
            average = (int)Math.floor((float)average / (float)slotList.size());
            for (Slot slot : slotList) {
                if (!slot.m_6657_() || (itemStack = slot.m_7993_()).m_41619_() || itemStack.m_41613_() <= average) continue;
                int mouseStackSize = itemStack.m_41613_();
                this.getController().m_171799_(container.f_38840_, slot.f_40219_, 0, ClickType.PICKUP, entityPlayer);
                for (Slot otherSlot : slotList) {
                    int otherStackSize;
                    ItemStack otherStack;
                    if (slot == otherSlot || !otherSlot.m_6657_() || (otherStack = otherSlot.m_7993_()).m_41619_() || (otherStackSize = otherStack.m_41613_()) >= average) continue;
                    while (otherStackSize < average && mouseStackSize > average) {
                        this.getController().m_171799_(container.f_38840_, otherSlot.f_40219_, 1, ClickType.PICKUP, entityPlayer);
                        --mouseStackSize;
                        ++otherStackSize;
                    }
                }
                this.getController().m_171799_(container.f_38840_, slot.f_40219_, 0, ClickType.PICKUP, entityPlayer);
            }
        }
    }

    public void spreadGrid(Player player, AbstractContainerMenu menu, CraftingGrid grid) {
        int tries = 0;
        while (tries < 9) {
            int i;
            ++tries;
            Slot biggestSlot = null;
            int biggestSlotSize = 1;
            int start = grid.getGridStartSlot(player, menu);
            int size = grid.getGridSize(player, menu);
            for (i = start; i < start + size; ++i) {
                Slot slot = (Slot)menu.f_38839_.get(i);
                ItemStack itemStack = slot.m_7993_();
                if (itemStack.m_41619_() || itemStack.m_41613_() <= biggestSlotSize) continue;
                biggestSlot = slot;
                biggestSlotSize = itemStack.m_41613_();
            }
            if (biggestSlot == null) {
                return;
            }
            this.getController().m_171799_(menu.f_38840_, biggestSlot.f_40219_, 0, ClickType.PICKUP, player);
            for (i = start; i < start + size; ++i) {
                ItemStack itemStack;
                if (i == biggestSlot.f_40219_ || !(itemStack = ((Slot)menu.f_38839_.get(i)).m_7993_()).m_41619_() || biggestSlotSize <= 1) continue;
                this.getController().m_171799_(menu.f_38840_, i, 1, ClickType.PICKUP, player);
                if (--biggestSlotSize == 1) break;
            }
            this.getController().m_171799_(menu.f_38840_, biggestSlot.f_40219_, 0, ClickType.PICKUP, player);
        }
        this.balanceGrid(player, menu, grid);
    }

    public void clearGrid(Player player, AbstractContainerMenu menu, CraftingGrid grid, boolean forced) {
        int start = grid.getGridStartSlot(player, menu);
        int size = grid.getGridSize(player, menu);
        for (int i = start; i < start + size; ++i) {
            this.getController().m_171799_(menu.f_38840_, i, 0, ClickType.QUICK_MOVE, player);
            menu.m_7648_(player, i);
            if (!forced || !((Slot)menu.f_38839_.get(i)).m_6657_()) continue;
            this.getController().m_171799_(menu.f_38840_, i, 0, ClickType.THROW, player);
        }
    }

    public void rotateGrid(Player player, AbstractContainerMenu menu, CraftingGrid grid, boolean reverse) {
        if (grid.getGridSize(player, menu) != 9) {
            return;
        }
        if (!this.dropOffMouseStack(player, menu)) {
            return;
        }
        if (this.rotateGridWithBuffer(player, menu, grid, reverse)) {
            return;
        }
        int startSlot = grid.getGridStartSlot(player, menu);
        this.getController().m_171799_(menu.f_38840_, startSlot, 0, ClickType.PICKUP, player);
        int currentSlot = startSlot;
        do {
            currentSlot = startSlot + this.rotateSlotId(currentSlot - startSlot, reverse);
            this.getController().m_171799_(menu.f_38840_, currentSlot, 0, ClickType.PICKUP, player);
        } while (currentSlot != startSlot);
    }

    private boolean rotateGridWithBuffer(Player player, AbstractContainerMenu menu, CraftingGrid grid, boolean counterClockwise) {
        int startSlot;
        int emptyBuffer = 0;
        int[] bufferSlot = new int[2];
        for (Slot slot : menu.f_38839_) {
            if (!(slot.f_40218_ instanceof Inventory) || slot.m_6657_()) continue;
            bufferSlot[emptyBuffer] = slot.f_40219_;
            if (++emptyBuffer < 2) continue;
            break;
        }
        if (emptyBuffer < 2) {
            return false;
        }
        emptyBuffer = 0;
        int currentSlot = startSlot = grid.getGridStartSlot(player, menu);
        do {
            this.getController().m_171799_(menu.f_38840_, currentSlot, 0, ClickType.PICKUP, player);
            this.getController().m_171799_(menu.f_38840_, bufferSlot[emptyBuffer], 0, ClickType.PICKUP, player);
            emptyBuffer = (emptyBuffer + 1) % 2;
            this.getController().m_171799_(menu.f_38840_, bufferSlot[emptyBuffer], 0, ClickType.PICKUP, player);
            this.getController().m_171799_(menu.f_38840_, currentSlot, 0, ClickType.PICKUP, player);
        } while ((currentSlot = startSlot + this.rotateSlotId(currentSlot - startSlot, counterClockwise)) != startSlot);
        emptyBuffer = (emptyBuffer + 1) % 2;
        this.getController().m_171799_(menu.f_38840_, bufferSlot[emptyBuffer], 0, ClickType.PICKUP, player);
        this.getController().m_171799_(menu.f_38840_, startSlot, 0, ClickType.PICKUP, player);
        return true;
    }

    public boolean transferIntoGrid(Player player, AbstractContainerMenu menu, CraftingGrid grid, Slot sourceSlot) {
        if (!(sourceSlot.m_6657_() && sourceSlot.m_8010_(player) && grid.transferHandler().canTransferFrom(player, menu, sourceSlot, grid))) {
            return false;
        }
        if (!this.dropOffMouseStack(player, menu)) {
            return false;
        }
        this.getController().m_171799_(menu.f_38840_, sourceSlot.f_40219_, 0, ClickType.PICKUP, player);
        ItemStack mouseStack = menu.m_142621_();
        if (mouseStack.m_41619_()) {
            return false;
        }
        boolean itemMoved = false;
        int firstEmptySlot = -1;
        int start = grid.getGridStartSlot(player, menu);
        int size = grid.getGridSize(player, menu);
        for (int i = start; i < start + size; ++i) {
            Slot craftSlot = (Slot)menu.f_38839_.get(i);
            ItemStack craftStack = craftSlot.m_7993_();
            if (!craftStack.m_41619_()) {
                int spaceLeft;
                if (!ItemStack.m_150942_((ItemStack)craftStack, (ItemStack)mouseStack) || (spaceLeft = Math.min(craftSlot.m_6641_(), craftStack.m_41741_()) - craftStack.m_41613_()) <= 0) continue;
                this.getController().m_171799_(menu.f_38840_, craftSlot.f_40219_, 0, ClickType.PICKUP, player);
                mouseStack = menu.m_142621_();
                if (!mouseStack.m_41619_()) continue;
                return true;
            }
            if (firstEmptySlot != -1) continue;
            firstEmptySlot = i;
        }
        if (firstEmptySlot != -1) {
            this.getController().m_171799_(menu.f_38840_, firstEmptySlot, 0, ClickType.PICKUP, player);
            itemMoved = true;
        }
        if (!menu.m_142621_().m_41619_()) {
            this.getController().m_171799_(menu.f_38840_, sourceSlot.f_40219_, 0, ClickType.PICKUP, player);
        }
        this.dropOffMouseStack(player, menu);
        return itemMoved;
    }

    private boolean dropOffMouseStack(Player player, AbstractContainerMenu menu) {
        return this.dropOffMouseStack(player, menu, -1);
    }

    private boolean dropOffMouseStack(Player player, AbstractContainerMenu menu, int ignoreSlot) {
        if (menu.m_142621_().m_41619_()) {
            return true;
        }
        for (int i = 0; i < menu.f_38839_.size(); ++i) {
            if (i == ignoreSlot) continue;
            Slot slot = (Slot)menu.f_38839_.get(i);
            if (slot.f_40218_ != player.m_150109_()) continue;
            ItemStack mouseItem = menu.m_142621_();
            ItemStack slotStack = slot.m_7993_();
            if (slotStack.m_41619_()) {
                this.getController().m_171799_(menu.f_38840_, i, 0, ClickType.PICKUP, player);
            } else if (ItemStack.m_150942_((ItemStack)slotStack, (ItemStack)mouseItem)) {
                this.getController().m_171799_(menu.f_38840_, i, 0, ClickType.PICKUP, player);
            }
            if (!menu.m_142621_().m_41619_()) continue;
            return true;
        }
        return menu.m_142621_().m_41619_();
    }

    private void decompress(Player player, AbstractContainerMenu menu, CraftingGrid grid, Slot mouseSlot, CompressType compressType) {
        if (!mouseSlot.m_6657_()) {
            return;
        }
        boolean decompressAll = compressType != CompressType.DECOMPRESS_ONE;
        this.clearGrid(player, menu, grid, false);
        int start = grid.getGridStartSlot(player, menu);
        int size = grid.getGridSize(player, menu);
        for (int i = start; i < start + size; ++i) {
            if (!((Slot)menu.f_38839_.get(i)).m_6657_()) continue;
            return;
        }
        for (Slot slot : menu.f_38839_) {
            if (compressType != CompressType.DECOMPRESS_ALL && slot != mouseSlot || !(slot.f_40218_ instanceof Inventory) || !slot.m_6657_() || !ItemStack.m_150942_((ItemStack)slot.m_7993_(), (ItemStack)mouseSlot.m_7993_())) continue;
            this.getController().m_171799_(menu.f_38840_, mouseSlot.f_40219_, 0, ClickType.PICKUP, player);
            this.getController().m_171799_(menu.f_38840_, start, 0, ClickType.PICKUP, player);
            for (Slot resultSlot : menu.f_38839_) {
                if (!(resultSlot instanceof ResultSlot) || !resultSlot.m_6657_()) continue;
                this.getController().m_171799_(menu.f_38840_, resultSlot.f_40219_, 0, decompressAll ? ClickType.QUICK_MOVE : ClickType.PICKUP, player);
                break;
            }
            this.dropOffMouseStack(player, menu, mouseSlot.f_40219_);
            this.getController().m_171799_(menu.f_38840_, start, 0, ClickType.PICKUP, player);
            this.getController().m_171799_(menu.f_38840_, mouseSlot.f_40219_, 0, ClickType.PICKUP, player);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void compress(LocalPlayer player, AbstractContainerMenu menu, CraftingGrid grid, Slot mouseSlot, CompressType compressType) {
        if (compressType == CompressType.DECOMPRESS_ALL || compressType == CompressType.DECOMPRESS_ONE || compressType == CompressType.DECOMPRESS_STACK) {
            this.decompress((Player)player, menu, grid, mouseSlot, compressType);
            return;
        }
        if (!mouseSlot.m_6657_()) {
            return;
        }
        boolean compressAll = compressType != CompressType.COMPRESS_ONE;
        this.clearGrid((Player)player, menu, grid, false);
        int start = grid.getGridStartSlot((Player)player, menu);
        int size = grid.getGridSize((Player)player, menu);
        for (int i = start; i < start + size; ++i) {
            if (!((Slot)menu.f_38839_.get(i)).m_6657_()) continue;
            return;
        }
        for (Slot slot : menu.f_38839_) {
            int i;
            if (compressType != CompressType.COMPRESS_ALL && slot != mouseSlot || !(slot.f_40218_ instanceof Inventory) || !slot.m_6657_() || !ItemStack.m_150942_((ItemStack)slot.m_7993_(), (ItemStack)mouseSlot.m_7993_())) continue;
            ItemStack mouseStack = slot.m_7993_();
            if (size == 9 && !mouseStack.m_41619_() && mouseStack.m_41613_() >= 9) {
                result = ClientProvider.findMatchingResult(new InventoryCraftingCompress(menu, 3, mouseStack), player);
                if (!result.m_41619_() && !this.isCompressBlacklisted(result)) {
                    this.getController().m_171799_(menu.f_38840_, slot.f_40219_, 0, ClickType.PICKUP, (Player)player);
                    this.getController().m_171799_(menu.f_38840_, -999, ClientProvider.getDragSplittingButton(0, 0), ClickType.QUICK_CRAFT, (Player)player);
                    for (i = start; i < start + size; ++i) {
                        this.getController().m_171799_(menu.f_38840_, i, ClientProvider.getDragSplittingButton(1, 0), ClickType.QUICK_CRAFT, (Player)player);
                    }
                    this.getController().m_171799_(menu.f_38840_, -999, ClientProvider.getDragSplittingButton(2, 0), ClickType.QUICK_CRAFT, (Player)player);
                    this.getController().m_171799_(menu.f_38840_, slot.f_40219_, 0, ClickType.PICKUP, (Player)player);
                } else {
                    result = ClientProvider.findMatchingResult(new InventoryCraftingCompress(menu, 2, mouseStack), player);
                    if (result.m_41619_() || this.isCompressBlacklisted(result)) return;
                    this.getController().m_171799_(menu.f_38840_, slot.f_40219_, 0, ClickType.PICKUP, (Player)player);
                    this.getController().m_171799_(menu.f_38840_, -999, ClientProvider.getDragSplittingButton(0, 0), ClickType.QUICK_CRAFT, (Player)player);
                    this.getController().m_171799_(menu.f_38840_, start, ClientProvider.getDragSplittingButton(1, 0), ClickType.QUICK_CRAFT, (Player)player);
                    this.getController().m_171799_(menu.f_38840_, start + 1, ClientProvider.getDragSplittingButton(1, 0), ClickType.QUICK_CRAFT, (Player)player);
                    this.getController().m_171799_(menu.f_38840_, start + 3, ClientProvider.getDragSplittingButton(1, 0), ClickType.QUICK_CRAFT, (Player)player);
                    this.getController().m_171799_(menu.f_38840_, start + 4, ClientProvider.getDragSplittingButton(1, 0), ClickType.QUICK_CRAFT, (Player)player);
                    this.getController().m_171799_(menu.f_38840_, -999, ClientProvider.getDragSplittingButton(2, 0), ClickType.QUICK_CRAFT, (Player)player);
                    this.getController().m_171799_(menu.f_38840_, slot.f_40219_, 0, ClickType.PICKUP, (Player)player);
                }
            } else if (size >= 4 && !mouseStack.m_41619_() && mouseStack.m_41613_() >= 4) {
                result = ClientProvider.findMatchingResult(new InventoryCraftingCompress(menu, 2, mouseStack), player);
                if (result.m_41619_() || this.isCompressBlacklisted(result)) return;
                this.getController().m_171799_(menu.f_38840_, slot.f_40219_, 0, ClickType.PICKUP, (Player)player);
                this.getController().m_171799_(menu.f_38840_, -999, ClientProvider.getDragSplittingButton(0, 0), ClickType.QUICK_CRAFT, (Player)player);
                if (size == 4) {
                    for (i = start; i < start + size; ++i) {
                        this.getController().m_171799_(menu.f_38840_, i, ClientProvider.getDragSplittingButton(1, 0), ClickType.QUICK_CRAFT, (Player)player);
                    }
                } else {
                    this.getController().m_171799_(menu.f_38840_, start, ClientProvider.getDragSplittingButton(1, 0), ClickType.QUICK_CRAFT, (Player)player);
                    this.getController().m_171799_(menu.f_38840_, start + 1, ClientProvider.getDragSplittingButton(1, 0), ClickType.QUICK_CRAFT, (Player)player);
                    this.getController().m_171799_(menu.f_38840_, start + 3, ClientProvider.getDragSplittingButton(1, 0), ClickType.QUICK_CRAFT, (Player)player);
                    this.getController().m_171799_(menu.f_38840_, start + 4, ClientProvider.getDragSplittingButton(1, 0), ClickType.QUICK_CRAFT, (Player)player);
                }
                this.getController().m_171799_(menu.f_38840_, -999, ClientProvider.getDragSplittingButton(2, 0), ClickType.QUICK_CRAFT, (Player)player);
                this.getController().m_171799_(menu.f_38840_, slot.f_40219_, 0, ClickType.PICKUP, (Player)player);
            }
            for (Slot resultSlot : menu.f_38839_) {
                if (!(resultSlot instanceof ResultSlot) || !resultSlot.m_6657_()) continue;
                this.getController().m_171799_(menu.f_38840_, resultSlot.f_40219_, 0, compressAll ? ClickType.QUICK_MOVE : ClickType.PICKUP, (Player)player);
                break;
            }
            this.dropOffMouseStack((Player)player, menu, slot.f_40219_);
            for (i = start; i < start + size; ++i) {
                if (!((Slot)menu.f_38839_.get(i)).m_6657_()) continue;
                this.getController().m_171799_(menu.f_38840_, i, 0, ClickType.PICKUP, (Player)player);
                this.getController().m_171799_(menu.f_38840_, slot.f_40219_, 0, ClickType.PICKUP, (Player)player);
            }
            this.dropOffMouseStack((Player)player, menu);
        }
    }

    private static <T extends CraftingContainer & RecipeHolder> ItemStack findMatchingResult(T craftingInventory, LocalPlayer player) {
        for (RecipeCollection recipeList : player.m_108631_().m_90639_()) {
            for (Recipe recipe : recipeList.m_100516_()) {
                Recipe craftingRecipe;
                if (recipe.m_6671_() != RecipeType.f_44107_ || !(craftingRecipe = recipe).m_5818_(craftingInventory, player.m_9236_())) continue;
                return craftingRecipe.m_5874_(craftingInventory, player.m_9236_().m_9598_());
            }
        }
        return ItemStack.f_41583_;
    }

    private static int getDragSplittingButton(int id, int limit) {
        return id & 3 | (limit & 3) << 2;
    }

    private boolean isCompressBlacklisted(ItemStack result) {
        ResourceLocation registryName = BuiltInRegistries.f_257033_.m_7981_((Object)result.m_41720_());
        return registryName != null && CraftingTweaksConfig.getActive().common.compressDenylist.contains(registryName.toString());
    }

    public void onItemCrafted(Container craftMatrix) {
        if (craftMatrix.m_6643_() <= 9) {
            for (int i = 0; i < this.lastCraftedMatrix.m_6643_(); ++i) {
                if (i < craftMatrix.m_6643_()) {
                    this.lastCraftedMatrix.m_6836_(i, craftMatrix.m_8020_(i).m_41777_());
                    continue;
                }
                this.lastCraftedMatrix.m_6836_(i, ItemStack.f_41583_);
            }
            this.hasLastCraftedMatrix = true;
        }
    }

    public void refillLastCrafted(Player player, AbstractContainerMenu menu, CraftingGrid grid, boolean fullStack) {
        ItemStack itemStack;
        int i;
        if (!this.hasLastCraftedMatrix) {
            return;
        }
        this.dropOffMouseStack(player, menu);
        int gridStart = grid.getGridStartSlot(player, menu);
        int gridSize = grid.getGridSize(player, menu);
        if (menu.f_38839_.size() < gridStart + gridSize || gridSize != this.lastCraftedMatrix.m_6643_()) {
            return;
        }
        block0: for (i = 0; i < this.lastCraftedMatrix.m_6643_(); ++i) {
            itemStack = this.lastCraftedMatrix.m_8020_(i);
            if (!itemStack.m_41619_()) {
                for (Slot slot : menu.f_38839_) {
                    if (!(slot.f_40218_ instanceof Inventory) || !slot.m_6657_() || !ItemStack.m_150942_((ItemStack)slot.m_7993_(), (ItemStack)itemStack)) continue;
                    this.getController().m_171799_(menu.f_38840_, slot.f_40219_, 0, ClickType.PICKUP, player);
                    this.getController().m_171799_(menu.f_38840_, gridStart + i, fullStack ? 0 : 1, ClickType.PICKUP, player);
                    this.getController().m_171799_(menu.f_38840_, slot.f_40219_, 0, ClickType.PICKUP, player);
                    continue block0;
                }
                continue;
            }
            if (!((Slot)menu.f_38839_.get(gridStart + i)).m_6657_()) continue;
            this.getController().m_171799_(menu.f_38840_, gridStart + i, 0, ClickType.PICKUP, player);
            if (this.dropOffMouseStack(player, menu)) continue;
            this.getController().m_171799_(menu.f_38840_, gridStart + i, 0, ClickType.PICKUP, player);
            return;
        }
        if (fullStack) {
            block2: for (i = 0; i < this.lastCraftedMatrix.m_6643_(); ++i) {
                itemStack = this.lastCraftedMatrix.m_8020_(i);
                if (itemStack.m_41619_() || ((Slot)menu.f_38839_.get(gridStart + i)).m_6657_()) continue;
                for (int j = gridStart; j < gridStart + gridSize; ++j) {
                    ItemStack gridStack;
                    if (j == gridStart + i || (gridStack = ((Slot)menu.f_38839_.get(j)).m_7993_()).m_41613_() <= 1 || !ItemStack.m_150942_((ItemStack)gridStack, (ItemStack)itemStack)) continue;
                    this.getController().m_171799_(menu.f_38840_, j, 0, ClickType.PICKUP, player);
                    this.getController().m_171799_(menu.f_38840_, gridStart + i, 1, ClickType.PICKUP, player);
                    this.getController().m_171799_(menu.f_38840_, j, 0, ClickType.PICKUP, player);
                    continue block2;
                }
            }
            this.balanceGrid(player, menu, grid);
        }
        this.dropOffMouseStack(player, menu);
    }

    public boolean rotateIgnoresSlotId(int slotId) {
        return slotId == 4;
    }

    public int rotateSlotId(int slotId, boolean counterClockwise) {
        if (!counterClockwise) {
            switch (slotId) {
                case 0: {
                    return 1;
                }
                case 1: {
                    return 2;
                }
                case 2: {
                    return 5;
                }
                case 5: {
                    return 8;
                }
                case 8: {
                    return 7;
                }
                case 7: {
                    return 6;
                }
                case 6: {
                    return 3;
                }
                case 3: {
                    return 0;
                }
            }
        } else {
            switch (slotId) {
                case 0: {
                    return 3;
                }
                case 1: {
                    return 0;
                }
                case 2: {
                    return 1;
                }
                case 3: {
                    return 6;
                }
                case 5: {
                    return 2;
                }
                case 6: {
                    return 7;
                }
                case 7: {
                    return 8;
                }
                case 8: {
                    return 5;
                }
            }
        }
        return 0;
    }
}

