/*
 * Decompiled with CFR 0.152.
 */
package terrails.colorfulhearts.forge.compat;

import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import squeek.appleskin.ModConfig;
import squeek.appleskin.api.event.FoodValuesEvent;
import squeek.appleskin.api.event.HUDOverlayEvent;
import squeek.appleskin.api.food.FoodValues;
import squeek.appleskin.client.HUDOverlayHandler;
import squeek.appleskin.helpers.FoodHelper;
import terrails.colorfulhearts.api.forge.event.ForgeHeartRenderEvent;
import terrails.colorfulhearts.api.forge.event.ForgeHeartUpdateEvent;
import terrails.colorfulhearts.api.heart.drawing.OverlayHeart;
import terrails.colorfulhearts.compat.AppleSkinCommonCompat;
import terrails.colorfulhearts.forge.mixin.compat.appleskin.HUDOverlayHandlerAccessor;

public class AppleSkinCompat
extends AppleSkinCommonCompat {
    public AppleSkinCompat() {
        MinecraftForge.EVENT_BUS.addListener(this::onDefaultRender);
        MinecraftForge.EVENT_BUS.addListener(this::onPostRender);
        MinecraftForge.EVENT_BUS.addListener(this::heartChanged);
    }

    private void onDefaultRender(HUDOverlayEvent.HealthRestored event) {
        event.setCanceled(true);
    }

    private void onPostRender(ForgeHeartRenderEvent.Post event) {
        boolean shouldRenderHeldItemValues;
        LocalPlayer player = this.client.f_91074_;
        assert (player != null);
        if (!this.shouldDrawOverlay(event.getOverlayHeart().orElse(null), (Player)player)) {
            return;
        }
        ItemStack heldItem = player.m_21205_();
        if (((Boolean)ModConfig.SHOW_FOOD_VALUES_OVERLAY_WHEN_OFFHAND.get()).booleanValue() && !FoodHelper.canConsume((ItemStack)heldItem, (Player)player)) {
            heldItem = player.m_21206_();
        }
        boolean bl = shouldRenderHeldItemValues = !heldItem.m_41619_() && FoodHelper.canConsume((ItemStack)heldItem, (Player)player);
        if (!shouldRenderHeldItemValues) {
            HUDOverlayHandler.resetFlash();
            return;
        }
        int health = Mth.m_14167_((float)player.m_21223_());
        FoodValues modifiedFoodValues = FoodHelper.getModifiedFoodValues((ItemStack)heldItem, (Player)player);
        FoodValuesEvent foodValuesEvent = new FoodValuesEvent((Player)player, heldItem, FoodHelper.getDefaultFoodValues((ItemStack)heldItem, (Player)player), modifiedFoodValues);
        MinecraftForge.EVENT_BUS.post((Event)foodValuesEvent);
        modifiedFoodValues = foodValuesEvent.modifiedFoodValues;
        float foodHealthIncrement = FoodHelper.getEstimatedHealthIncrement((ItemStack)heldItem, (FoodValues)modifiedFoodValues, (Player)player);
        int modifiedHealth = Mth.m_14167_((float)Math.min((float)health + foodHealthIncrement, player.m_21233_()));
        if (modifiedHealth <= health) {
            return;
        }
        float alpha = HUDOverlayHandlerAccessor.getFlashAlpha();
        this.drawHealthOverlay(event.getGuiGraphics(), event.getX(), event.getY(), Mth.m_14167_((float)player.m_6103_()), health, modifiedHealth, alpha, event.isHardcore());
    }

    private void heartChanged(ForgeHeartUpdateEvent event) {
        this.lastHealth = 0;
    }

    public boolean shouldDrawOverlay(OverlayHeart overlayHeart, Player player) {
        if (overlayHeart != null) {
            return false;
        }
        if (!((Boolean)ModConfig.SHOW_FOOD_HEALTH_HUD_OVERLAY.get()).booleanValue()) {
            return false;
        }
        if (player.m_9236_().m_46791_() == Difficulty.PEACEFUL) {
            return false;
        }
        FoodData stats = player.m_36324_();
        if (stats.m_38702_() >= 18) {
            return false;
        }
        return !player.m_21023_(MobEffects.f_19605_);
    }
}

