/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.loader.stage2;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;

public class Utils {
    public static Pair<Path, Integer> findMostRecentFile(Path dir, String baseName, String ext) throws IOException {
        List rawFiles;
        String dotExt = "." + ext;
        try (Stream<Path> stream = Files.list(dir);){
            rawFiles = stream.collect(Collectors.toList());
        }
        List files = rawFiles.stream().map(it -> {
            String name = it.getFileName().toString();
            if (!name.startsWith(baseName)) {
                return null;
            }
            String ending = name.substring(baseName.length());
            if (ending.equals(dotExt)) {
                return Pair.of((Object)it, (Object)0);
            }
            if (!(ending = ending.substring(0, ending.length() - dotExt.length())).startsWith(".")) {
                return null;
            }
            ending = ending.substring(1);
            try {
                return Pair.of((Object)it, (Object)Integer.parseInt(ending));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
        Pair mostRecent = files.stream().max(Comparator.comparing(Pair::getRight)).orElse(null);
        if (mostRecent == null) {
            return Pair.of((Object)dir.resolve(baseName + dotExt), (Object)0);
        }
        files.stream().filter(it -> it != mostRecent).forEach(it -> {
            try {
                Files.delete((Path)it.getKey());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        return mostRecent;
    }

    public static Path findNextMostRecentFile(Path dir, String baseName, String ext) throws IOException {
        Pair<Path, Integer> mostRecent = Utils.findMostRecentFile(dir, baseName, ext);
        if (!Files.exists((Path)mostRecent.getLeft(), new LinkOption[0])) {
            return (Path)mostRecent.getLeft();
        }
        return dir.resolve(baseName + "." + ((Integer)mostRecent.getRight() + 1) + "." + ext);
    }

    public static Path mapFileBaseName(Path path, Function<String, String> mapper) {
        return path.resolveSibling(Utils.mapFileBaseName(path.getFileName().toString(), mapper));
    }

    public static String mapFileBaseName(String fileName, Function<String, String> mapper) {
        int separator = fileName.lastIndexOf(46);
        if (separator == -1) {
            return mapper.apply(fileName);
        }
        String base = fileName.substring(0, separator);
        String ext = fileName.substring(separator);
        return mapper.apply(base) + ext;
    }

    public static boolean hasClass(String name) {
        try {
            Class.forName(name);
            return true;
        }
        catch (ClassNotFoundException ignored) {
            return false;
        }
    }
}

