/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.loader.stage2.diff;

import gg.essential.loader.stage2.util.Delete;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;

public class DiffPatcher {
    private static final long CONSTANT_TIME_FOR_ZIP_ENTRIES = new GregorianCalendar(1980, 1, 1, 0, 0, 0).getTimeInMillis();

    public static void apply(Path targetFile, Path diffFile) throws IOException {
        try (FileSystem targetFileSystem = FileSystems.newFileSystem(targetFile, (ClassLoader)null);
             FileSystem diffFileSystem = FileSystems.newFileSystem(diffFile, (ClassLoader)null);){
            DiffPatcher.walk(diffFileSystem.getPath("/-", new String[0]), targetFileSystem, DiffPatcher::remove);
            DiffPatcher.walk(diffFileSystem.getPath("/~", new String[0]), targetFileSystem, DiffPatcher::add);
            DiffPatcher.walk(diffFileSystem.getPath("/+", new String[0]), targetFileSystem, DiffPatcher::add);
        }
        DiffPatcher.stripNonDeterminism(targetFile);
    }

    private static void add(Path diffPath, Path targetPath) throws IOException {
        Path parent;
        if (Files.exists(targetPath, new LinkOption[0])) {
            Delete.recursively(targetPath);
        }
        if ((parent = targetPath.getParent()) != null) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
        Files.copy(diffPath, targetPath, new CopyOption[0]);
    }

    private static void remove(Path diffPath, Path targetPath) throws IOException {
        if (Files.exists(targetPath, new LinkOption[0])) {
            Delete.recursively(targetPath);
            Path parent = targetPath.getParent();
            if (parent != null && !DiffPatcher.hasChildren(parent)) {
                DiffPatcher.remove(diffPath, parent);
            }
        }
    }

    private static void walk(Path diffRoot, FileSystem targetFileSystem, PatchingFunction patcher) throws IOException {
        if (!Files.exists(diffRoot, new LinkOption[0])) {
            return;
        }
        try (Stream<Path> stream = Files.walk(diffRoot, new FileVisitOption[0]);){
            for (Path diffPath : stream::iterator) {
                if (!Files.isRegularFile(diffPath, new LinkOption[0])) continue;
                String relativePath = diffRoot.relativize(diffPath).toString();
                Path targetPath = targetFileSystem.getPath(relativePath, new String[0]);
                patcher.apply(diffPath, targetPath);
            }
        }
    }

    private static boolean hasChildren(Path dir) throws IOException {
        try (Stream<Path> stream = Files.list(dir);){
            boolean bl = stream.findAny().isPresent();
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void stripNonDeterminism(Path path) throws IOException {
        Path tmpPath = Files.createTempFile(path.getParent(), "tmp", ".jar", new FileAttribute[0]);
        try {
            try (OutputStream fileOut = Files.newOutputStream(tmpPath, StandardOpenOption.TRUNCATE_EXISTING);
                 ZipOutputStream zipOut = new ZipOutputStream(fileOut);
                 ZipFile zipIn = new ZipFile(path.toFile());){
                ArrayList<? extends ZipEntry> entries = Collections.list(zipIn.entries());
                entries.sort(Comparator.comparing(ZipEntry::getName));
                for (ZipEntry zipEntry : entries) {
                    ZipEntry newEntry = new ZipEntry(zipEntry.getName());
                    newEntry.setTime(CONSTANT_TIME_FOR_ZIP_ENTRIES);
                    zipOut.putNextEntry(newEntry);
                    IOUtils.copy((InputStream)zipIn.getInputStream(zipEntry), (OutputStream)zipOut);
                }
            }
            Files.move(tmpPath, path, StandardCopyOption.REPLACE_EXISTING);
        }
        finally {
            Files.deleteIfExists(tmpPath);
        }
    }

    @FunctionalInterface
    private static interface PatchingFunction {
        public void apply(Path var1, Path var2) throws IOException;
    }
}

