/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.loader.stage2.util;

import cpw.mods.jarhandling.JarMetadata;
import cpw.mods.jarhandling.SecureJar;
import cpw.mods.modlauncher.api.NamedPath;
import gg.essential.loader.stage2.modlauncher.CompatibilityLayer;
import gg.essential.loader.stage2.util.UnsafeHacks;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.jar.Manifest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;

public class SortedJarOrPathList
extends ArrayList<Object> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ArtifactVersion FALLBACK_VERSION = new DefaultArtifactVersion("1");
    private static Function<Object, SecureJar> jarGetter;
    private final Map<Class<?>, Function<SecureJar, JarMetadata>> metadataGetters = new HashMap();
    private BiFunction<NamedPath, SecureJar, Object> pathOrJarConstructor;
    private final Map<Object, ArtifactVersion> versionCache = new IdentityHashMap<Object, ArtifactVersion>();
    private final Comparator<Object> COMPARATOR = Comparator.comparing(pathOrJar -> this.versionCache.computeIfAbsent(pathOrJar, this::getVersion)).reversed();
    private final CompatibilityLayer compatibilityLayer;
    private final Function<SecureJar, List<SecureJar>> substitute;

    public SortedJarOrPathList(CompatibilityLayer compatibilityLayer, Function<SecureJar, List<SecureJar>> substitute) {
        this.compatibilityLayer = compatibilityLayer;
        this.substitute = substitute;
    }

    private ArtifactVersion getVersion(Object pathOrJar) {
        String name;
        Manifest manifest;
        SecureJar jar = SortedJarOrPathList.getJar(pathOrJar);
        if (jar == null) {
            return FALLBACK_VERSION;
        }
        String version = null;
        JarMetadata metadata = this.getMetadata(jar);
        if (metadata != null) {
            version = metadata.version();
        }
        if (version != null && version.equals("Optional.empty")) {
            version = null;
        } else if (version != null && version.startsWith("Optional[")) {
            version = version.substring("Optional[".length(), version.length() - 1);
        }
        if (version == null && (manifest = this.compatibilityLayer.getManifest(jar)) != null) {
            version = manifest.getMainAttributes().getValue("Implementation-Version");
        }
        if (version == null && (name = jar.getPrimaryPath().getFileName().toString()).contains("-") && name.endsWith(".jar")) {
            version = name.substring(name.lastIndexOf("-") + 1, name.length() - ".jar".length());
        }
        if (version == null) {
            return FALLBACK_VERSION;
        }
        return new DefaultArtifactVersion(version);
    }

    public static SecureJar getJar(Object pathOrJar) {
        Object object = pathOrJar;
        if (object instanceof SecureJar) {
            SecureJar secureJar = (SecureJar)object;
            return secureJar;
        }
        if (jarGetter == null) {
            try {
                Field jarField = pathOrJar.getClass().getDeclaredField("jar");
                jarField.setAccessible(true);
                jarGetter = wrapper -> {
                    try {
                        return (SecureJar)jarField.get(wrapper);
                    }
                    catch (Throwable t) {
                        LOGGER.error("Failed to get jar from PathOrJar:", t);
                        return null;
                    }
                };
            }
            catch (Throwable t) {
                LOGGER.error("Failed to get jar from PathOrJar:", t);
                jarGetter = __ -> null;
            }
        }
        return jarGetter.apply(pathOrJar);
    }

    private JarMetadata getMetadata(SecureJar jar) {
        Class<?> implClass = jar.getClass();
        Function<Object, Object> metadataGetter = this.metadataGetters.get(implClass);
        if (metadataGetter == null) {
            try {
                String implName;
                switch (implName = implClass.getName()) {
                    case "org.sinytra.connector.service.DummyVirtualJar": {
                        metadataGetter = __ -> null;
                        break;
                    }
                    default: {
                        metadataGetter = UnsafeHacks.makeGetter(implClass.getDeclaredField("metadata"));
                        break;
                    }
                }
            }
            catch (Throwable t) {
                LOGGER.error("Failed to get metadata from " + implClass + ":", t);
                metadataGetter = __ -> null;
            }
            this.metadataGetters.put(implClass, metadataGetter);
        }
        return metadataGetter.apply(jar);
    }

    @Override
    public boolean add(Object o) {
        return this.addAll((Collection<?>)List.of(o));
    }

    @Override
    public boolean addAll(Collection<?> c) {
        boolean changed = super.addAll(c.stream().flatMap(it -> this.substitute(it).stream()).toList());
        this.sort(this.COMPARATOR);
        return changed;
    }

    private List<?> substitute(Object orgPathOrJar) {
        SecureJar orgJar = SortedJarOrPathList.getJar(orgPathOrJar);
        if (orgJar == null) {
            return List.of(orgPathOrJar);
        }
        List<SecureJar> newJars = this.substitute.apply(orgJar);
        if (newJars == null) {
            return List.of(orgPathOrJar);
        }
        if (orgPathOrJar instanceof SecureJar) {
            return newJars;
        }
        if (this.pathOrJarConstructor == null) {
            try {
                Constructor<?> constructor = orgPathOrJar.getClass().getDeclaredConstructors()[0];
                constructor.setAccessible(true);
                this.pathOrJarConstructor = (path, jar) -> {
                    try {
                        return constructor.newInstance(path, jar);
                    }
                    catch (Throwable t) {
                        LOGGER.error("Failed to construct PathOrJar:", t);
                        return null;
                    }
                };
            }
            catch (Throwable t) {
                LOGGER.error("Failed to construct PathOrJar:", t);
                this.pathOrJarConstructor = (path, jar) -> null;
            }
        }
        ArrayList<Object> newPathOrJars = new ArrayList<Object>(newJars.size());
        for (SecureJar newJar : newJars) {
            Object newPathOrJar = this.pathOrJarConstructor.apply(null, newJar);
            if (newPathOrJar == null) {
                return List.of(orgPathOrJar);
            }
            newPathOrJars.add(newPathOrJar);
        }
        return newPathOrJars;
    }
}

