/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.craftingeffect.outcome;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ToolAction;
import se.mickelus.tetra.craftingeffect.condition.CraftingEffectCondition;
import se.mickelus.tetra.craftingeffect.outcome.CraftingEffectOutcome;
import se.mickelus.tetra.module.schematic.UpgradeSchematic;
import se.mickelus.tetra.util.StreamHelper;

@ParametersAreNonnullByDefault
public class ApplyListOutcome
implements CraftingEffectOutcome {
    EffectPair[] effects;
    boolean random = false;
    int count = Integer.MAX_VALUE;

    @Override
    public boolean apply(ResourceLocation[] unlockedEffects, ItemStack upgradedStack, String slot, boolean isReplacing, Player player, ItemStack[] preMaterials, Map<ToolAction, Integer> tools, Level world, UpgradeSchematic schematic, BlockPos pos, BlockState blockState, boolean consumeResources, ItemStack[] postMaterials) {
        Collector collector = this.random ? StreamHelper.toShuffledList() : Collectors.toUnmodifiableList();
        List applicableOutcomes = Arrays.stream(this.effects).filter(outcome -> outcome.requirement.test(unlockedEffects, upgradedStack, slot, isReplacing, player, preMaterials, tools, schematic, world, pos, blockState)).collect(collector);
        int i = 0;
        while (i < applicableOutcomes.size() & i < this.count) {
            ((EffectPair)applicableOutcomes.get((int)i)).outcome.apply(unlockedEffects, upgradedStack, slot, isReplacing, player, preMaterials, tools, world, schematic, pos, blockState, consumeResources, postMaterials);
            ++i;
        }
        return !applicableOutcomes.isEmpty();
    }

    static class EffectPair {
        CraftingEffectCondition requirement = CraftingEffectCondition.any;
        CraftingEffectOutcome outcome;

        EffectPair() {
        }
    }
}

