/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.math.Transformation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import se.mickelus.mutil.data.DataDistributor;
import se.mickelus.mutil.data.DataStore;
import se.mickelus.mutil.data.deserializer.BlockDeserializer;
import se.mickelus.mutil.data.deserializer.BlockPosDeserializer;
import se.mickelus.mutil.data.deserializer.ItemDeserializer;
import se.mickelus.mutil.data.deserializer.ResourceLocationDeserializer;
import se.mickelus.mutil.network.AbstractPacket;
import se.mickelus.tetra.TetraMod;
import se.mickelus.tetra.aspect.ItemAspect;
import se.mickelus.tetra.blocks.PropertyMatcher;
import se.mickelus.tetra.blocks.workbench.action.ConfigActionImpl;
import se.mickelus.tetra.blocks.workbench.unlocks.UnlockData;
import se.mickelus.tetra.craftingeffect.CraftingEffect;
import se.mickelus.tetra.craftingeffect.condition.CraftingEffectCondition;
import se.mickelus.tetra.craftingeffect.outcome.CraftingEffectOutcome;
import se.mickelus.tetra.data.CraftingEffectStore;
import se.mickelus.tetra.data.ImprovementStore;
import se.mickelus.tetra.data.ItemEffectStore;
import se.mickelus.tetra.data.MaterialStore;
import se.mickelus.tetra.data.ModuleStore;
import se.mickelus.tetra.data.SchematicStore;
import se.mickelus.tetra.data.SynergyStore;
import se.mickelus.tetra.data.UpdateDataPacket;
import se.mickelus.tetra.data.deserializer.AABBDeserializer;
import se.mickelus.tetra.data.deserializer.AttributesDeserializer;
import se.mickelus.tetra.data.deserializer.BlockStateDeserializer;
import se.mickelus.tetra.data.deserializer.EnchantmentDeserializer;
import se.mickelus.tetra.data.deserializer.EntityPredicateDeserializer;
import se.mickelus.tetra.data.deserializer.GlyphDeserializer;
import se.mickelus.tetra.data.deserializer.ItemDisplayContextDeserializer;
import se.mickelus.tetra.data.deserializer.ItemPredicateDeserializer;
import se.mickelus.tetra.data.deserializer.ItemStackDeserializer;
import se.mickelus.tetra.data.deserializer.ItemTagKeyDeserializer;
import se.mickelus.tetra.data.deserializer.MobEffectDeserializer;
import se.mickelus.tetra.data.deserializer.ModuleModelDeserializer;
import se.mickelus.tetra.data.deserializer.ParticleOptionsDeserializer;
import se.mickelus.tetra.data.deserializer.PropertyMatcherDeserializer;
import se.mickelus.tetra.data.deserializer.QuaternionDeserializer;
import se.mickelus.tetra.data.deserializer.ReplacementDeserializer;
import se.mickelus.tetra.data.deserializer.SoundEventDeserializer;
import se.mickelus.tetra.data.deserializer.TransformationDeserializer;
import se.mickelus.tetra.data.deserializer.VectorDeserializer;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.effect.data.ItemEffectTrigger;
import se.mickelus.tetra.effect.data.condition.ItemEffectCondition;
import se.mickelus.tetra.effect.data.outcome.ItemEffectOutcome;
import se.mickelus.tetra.effect.data.provider.entity.EntityProvider;
import se.mickelus.tetra.effect.data.provider.number.NumberProvider;
import se.mickelus.tetra.effect.data.provider.vector.VectorProvider;
import se.mickelus.tetra.items.modular.impl.dynamic.ArchetypeDefinition;
import se.mickelus.tetra.module.Priority;
import se.mickelus.tetra.module.ReplacementDefinition;
import se.mickelus.tetra.module.data.AspectData;
import se.mickelus.tetra.module.data.EffectData;
import se.mickelus.tetra.module.data.EnchantmentMapping;
import se.mickelus.tetra.module.data.GlyphData;
import se.mickelus.tetra.module.data.ImprovementData;
import se.mickelus.tetra.module.data.MaterialColors;
import se.mickelus.tetra.module.data.MaterialData;
import se.mickelus.tetra.module.data.ModuleData;
import se.mickelus.tetra.module.data.ModuleModel;
import se.mickelus.tetra.module.data.ToolData;
import se.mickelus.tetra.module.data.TweakData;
import se.mickelus.tetra.module.data.VariantData;
import se.mickelus.tetra.module.improvement.DestabilizationEffect;
import se.mickelus.tetra.module.schematic.OutcomeDefinition;
import se.mickelus.tetra.module.schematic.OutcomeMaterial;
import se.mickelus.tetra.module.schematic.RepairDefinition;
import se.mickelus.tetra.module.schematic.requirement.CraftingRequirement;
import se.mickelus.tetra.module.schematic.requirement.CraftingRequirementDeserializer;
import se.mickelus.tetra.module.schematic.requirement.IntegerPredicate;
import se.mickelus.tetra.module.schematic.requirement.ModuleRequirement;

@ParametersAreNonnullByDefault
public class DataManager
implements DataDistributor {
    public static final Gson gson = new GsonBuilder().registerTypeAdapter(ToolData.class, (Object)new ToolData.Deserializer()).registerTypeAdapter(AspectData.class, (Object)new AspectData.Deserializer()).registerTypeAdapter(ItemAspect.class, (Object)new ItemAspect.Deserializer()).registerTypeAdapter(EffectData.class, (Object)new EffectData.Deserializer()).registerTypeAdapter(GlyphData.class, (Object)new GlyphDeserializer()).registerTypeAdapter(ModuleModel.class, (Object)new ModuleModelDeserializer()).registerTypeAdapter(Priority.class, (Object)new Priority.Deserializer()).registerTypeAdapter(ItemPredicate.class, (Object)new ItemPredicateDeserializer()).registerTypeAdapter(PropertyMatcher.class, (Object)new PropertyMatcherDeserializer()).registerTypeAdapter(MaterialData.class, (Object)new MaterialData.Deserializer()).registerTypeAdapter(OutcomeMaterial.class, (Object)new OutcomeMaterial.Deserializer()).registerTypeAdapter(ReplacementDefinition.class, (Object)new ReplacementDeserializer()).registerTypeAdapter(BlockPos.class, (Object)new BlockPosDeserializer()).registerTypeAdapter(Block.class, (Object)new BlockDeserializer()).registerTypeAdapter(BlockState.class, (Object)new BlockStateDeserializer()).registerTypeAdapter((Type)AttributesDeserializer.typeToken.getRawType(), (Object)new AttributesDeserializer()).registerTypeAdapter((Type)ItemTagKeyDeserializer.typeToken.getRawType(), (Object)new ItemTagKeyDeserializer()).registerTypeAdapter(VariantData.class, (Object)new VariantData.Deserializer()).registerTypeAdapter(ImprovementData.class, (Object)new ImprovementData.Deserializer()).registerTypeAdapter(OutcomeDefinition.class, (Object)new OutcomeDefinition.Deserializer()).registerTypeAdapter(MaterialColors.class, (Object)new MaterialColors.Deserializer()).registerTypeAdapter(CraftingEffectCondition.class, (Object)new CraftingEffectCondition.Deserializer()).registerTypeAdapter(CraftingEffectOutcome.class, (Object)new CraftingEffectOutcome.Deserializer()).registerTypeAdapter(CraftingRequirement.class, (Object)new CraftingRequirementDeserializer()).registerTypeAdapter(ModuleRequirement.class, (Object)new ModuleRequirement.Deserializer()).registerTypeAdapter(IntegerPredicate.class, (Object)new IntegerPredicate.Deserializer()).registerTypeAdapter(Item.class, (Object)new ItemDeserializer()).registerTypeAdapter(ItemStack.class, (Object)new ItemStackDeserializer()).registerTypeAdapter(Enchantment.class, (Object)new EnchantmentDeserializer()).registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocationDeserializer()).registerTypeAdapter(Vector3f.class, (Object)new VectorDeserializer()).registerTypeAdapter(Quaternionf.class, (Object)new QuaternionDeserializer()).registerTypeAdapter(Transformation.class, (Object)new TransformationDeserializer()).registerTypeAdapter(AABB.class, (Object)new AABBDeserializer()).registerTypeAdapter(ItemDisplayContext.class, (Object)new ItemDisplayContextDeserializer()).registerTypeAdapter(ItemEffect.class, (Object)new ItemEffect.Deserializer()).registerTypeAdapter(ItemEffectTrigger.class, (Object)new ItemEffectTrigger.Deserializer()).registerTypeAdapter(ItemEffectCondition.class, (Object)new ItemEffectCondition.Deserializer()).registerTypeAdapter(ItemEffectOutcome.class, (Object)new ItemEffectOutcome.Deserializer()).registerTypeAdapter(NumberProvider.class, (Object)new NumberProvider.Deserializer()).registerTypeAdapter(EntityProvider.class, (Object)new EntityProvider.Deserializer()).registerTypeAdapter(VectorProvider.class, (Object)new VectorProvider.Deserializer()).registerTypeAdapter(EntityPredicate.class, (Object)new EntityPredicateDeserializer()).registerTypeAdapter(ParticleOptions.class, (Object)new ParticleOptionsDeserializer()).registerTypeAdapter(SoundEvent.class, (Object)new SoundEventDeserializer()).registerTypeAdapter(MobEffect.class, (Object)new MobEffectDeserializer()).create();
    public static DataManager instance;
    public final DataStore<ResourceLocation[]> tierData;
    public final DataStore<TweakData[]> tweakData;
    public final MaterialStore materialData;
    public final DataStore<ImprovementData[]> improvementData;
    public final DataStore<ModuleData> moduleData;
    public final DataStore<RepairDefinition> repairData;
    public final DataStore<EnchantmentMapping[]> enchantmentData;
    public final SynergyStore synergyData;
    public final DataStore<ReplacementDefinition[]> replacementData;
    public final SchematicStore schematicData;
    public final DataStore<CraftingEffect> craftingEffectData;
    public final DataStore<ConfigActionImpl[]> actionData;
    public final DataStore<DestabilizationEffect[]> destabilizationData;
    public final DataStore<UnlockData> unlockData;
    public final DataStore<ArchetypeDefinition> archetypeData;
    public final ItemEffectStore itemEffectData;
    private final Logger logger = LogManager.getLogger();
    private final DataStore[] dataStores;

    public DataManager() {
        instance = this;
        this.tierData = new DataStore(gson, "tetra", "tiers", ResourceLocation[].class, (DataDistributor)this);
        this.tweakData = new DataStore(gson, "tetra", "tweaks", TweakData[].class, (DataDistributor)this);
        this.materialData = new MaterialStore(gson, "tetra", "materials", this);
        this.improvementData = new ImprovementStore(gson, "tetra", "improvements", this.materialData, this);
        this.moduleData = new ModuleStore(gson, "tetra", "modules", this);
        this.repairData = new DataStore(gson, "tetra", "repairs", RepairDefinition.class, (DataDistributor)this);
        this.enchantmentData = new DataStore(gson, "tetra", "enchantments", EnchantmentMapping[].class, (DataDistributor)this);
        this.synergyData = new SynergyStore(gson, "tetra", "synergies", this);
        this.replacementData = new DataStore(gson, "tetra", "replacements", ReplacementDefinition[].class, (DataDistributor)this);
        this.schematicData = new SchematicStore(gson, "tetra", "schematics", this);
        this.craftingEffectData = new CraftingEffectStore(gson, "tetra", "crafting_effects", this);
        this.actionData = new DataStore(gson, "tetra", "actions", ConfigActionImpl[].class, (DataDistributor)this);
        this.destabilizationData = new DataStore(gson, "tetra", "destabilization", DestabilizationEffect[].class, (DataDistributor)this);
        this.unlockData = new DataStore(gson, "tetra", "unlocks", UnlockData.class, (DataDistributor)this);
        this.archetypeData = new DataStore(gson, "tetra", "archetypes", ArchetypeDefinition.class, (DataDistributor)this);
        this.itemEffectData = new ItemEffectStore(gson, "tetra", "item_effects", this);
        this.dataStores = new DataStore[]{this.tierData, this.tweakData, this.materialData, this.improvementData, this.moduleData, this.enchantmentData, this.synergyData, this.replacementData, this.schematicData, this.craftingEffectData, this.repairData, this.actionData, this.destabilizationData, this.unlockData, this.archetypeData, this.itemEffectData};
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void addReloadListener(AddReloadListenerEvent event) {
        this.logger.debug("Setting up datastore reload listeners");
        Arrays.stream(this.dataStores).forEach(arg_0 -> ((AddReloadListenerEvent)event).addListener(arg_0));
    }

    @SubscribeEvent
    public void tagsUpdated(TagsUpdatedEvent event) {
        this.logger.debug("Reloaded tags");
    }

    @SubscribeEvent
    public void playerConnected(PlayerEvent.PlayerLoggedInEvent event) {
        this.logger.info("Sending data to client: {}", (Object)event.getEntity().m_7755_().getString());
        for (DataStore dataStore : this.dataStores) {
            dataStore.sendToPlayer((ServerPlayer)event.getEntity());
        }
    }

    public void onDataRecieved(String directory, Map<ResourceLocation, String> data) {
        Arrays.stream(this.dataStores).filter(dataStore -> dataStore.getDirectory().equals(directory)).forEach(dataStore -> dataStore.loadFromPacket(data));
    }

    public void sendToAll(String directory, Map<ResourceLocation, JsonElement> data) {
        TetraMod.packetHandler.sendToAllPlayers((AbstractPacket)new UpdateDataPacket(directory, data));
    }

    public void sendToPlayer(ServerPlayer player, String directory, Map<ResourceLocation, JsonElement> data) {
        TetraMod.packetHandler.sendTo((AbstractPacket)new UpdateDataPacket(directory, data), player);
    }
}

