/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.effect.data;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import se.mickelus.tetra.data.ItemEffectStore;
import se.mickelus.tetra.effect.data.ItemEffectContext;
import se.mickelus.tetra.effect.data.ItemEffectData;
import se.mickelus.tetra.items.modular.IModularItem;

public class DataEffectsHandler {
    public static void applyOnHitEffects(ItemStack itemStack, LivingEntity target, LivingEntity attacker) {
        Level level = attacker.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ItemEffectContext context = new ItemEffectContext(attacker, itemStack, serverLevel).withEntities((Map<String, Entity>)ImmutableMap.of((Object)"attacker", (Object)attacker, (Object)"target", (Object)target));
            ((IModularItem)itemStack.m_41720_()).getEffects(itemStack).stream().flatMap(effect -> ItemEffectStore.onHitEffects.get(effect).stream()).forEach(effect -> DataEffectsHandler.prepareDataAndPerformOutcome(effect, context));
        }
    }

    public static void applyMineBlockEffects(ItemStack itemStack, LivingEntity breaker, BlockPos targetPos) {
        Level level = breaker.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ItemEffectContext context = new ItemEffectContext(breaker, itemStack, serverLevel).withEntities((Map<String, Entity>)ImmutableMap.of((Object)"miner", (Object)breaker)).withVectors((Map<String, Vec3>)ImmutableMap.of((Object)"target", (Object)Vec3.m_82528_((Vec3i)targetPos)));
            ((IModularItem)itemStack.m_41720_()).getEffects(itemStack).stream().flatMap(effect -> ItemEffectStore.onMineBlockEffects.get(effect).stream()).forEach(effect -> DataEffectsHandler.prepareDataAndPerformOutcome(effect, context));
        }
    }

    public static void applyBreakBlockEffects(ItemStack itemStack, LivingEntity breaker, BlockPos targetPos) {
        Level level = breaker.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ItemEffectContext context = new ItemEffectContext(breaker, itemStack, serverLevel).withEntities((Map<String, Entity>)ImmutableMap.of((Object)"breaker", (Object)breaker)).withVectors((Map<String, Vec3>)ImmutableMap.of((Object)"target", (Object)Vec3.m_82528_((Vec3i)targetPos)));
            ((IModularItem)itemStack.m_41720_()).getEffects(itemStack).stream().flatMap(effect -> ItemEffectStore.onBreakBlockEffects.get(effect).stream()).forEach(effect -> DataEffectsHandler.prepareDataAndPerformOutcome(effect, context));
        }
    }

    private static void prepareDataAndPerformOutcome(ItemEffectData effect, ItemEffectContext context) {
        context = context.withMergedNumbers(ItemEffectData.calculateNumbers(effect, context));
        context = context.withMergedVectors(ItemEffectData.calculateVectors(effect, context));
        context = context.withMergedEntities(ItemEffectData.calculateEntities(effect, context));
        if (effect.condition == null || effect.condition.test(context)) {
            effect.outcome.perform(context);
        }
    }
}

