/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.effect.data;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class ItemEffectContext {
    private LivingEntity usingEntity;
    private ItemStack usedItemStack;
    private ServerLevel level;
    private Map<String, Float> numbers;
    private Map<String, Vec3> vectors;
    private Map<String, Entity> entities;

    public ItemEffectContext(LivingEntity usingEntity, ItemStack usedItemStack, ServerLevel level, Map<String, Float> numbers, Map<String, Vec3> vectors, Map<String, Entity> entities) {
        this.usingEntity = usingEntity;
        this.usedItemStack = usedItemStack;
        this.level = level;
        this.numbers = numbers;
        this.vectors = vectors;
        this.entities = entities;
    }

    public ItemEffectContext(LivingEntity usingEntity, ItemStack usedItemStack, ServerLevel level) {
        this(usingEntity, usedItemStack, level, Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap());
    }

    public ItemEffectContext copy() {
        return new ItemEffectContext(this.usingEntity, this.usedItemStack, this.level, this.numbers, this.vectors, this.entities);
    }

    public ItemEffectContext withNumbers(Map<String, Float> numbers) {
        ItemEffectContext copy = this.copy();
        copy.numbers = numbers;
        return copy;
    }

    public ItemEffectContext withMergedNumbers(Map<String, Float> numbers) {
        ItemEffectContext copy = this.copy();
        copy.numbers = ItemEffectContext.mergeNumbers(copy.numbers, numbers);
        return copy;
    }

    @SafeVarargs
    public static Map<String, Float> mergeNumbers(Map<String, Float> ... numbers) {
        return Stream.of(numbers).map(Map::entrySet).flatMap(Collection::stream).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> b));
    }

    public ItemEffectContext withVectors(Map<String, Vec3> vectors) {
        ItemEffectContext copy = this.copy();
        copy.vectors = vectors;
        return copy;
    }

    public ItemEffectContext withMergedVectors(Map<String, Vec3> vectors) {
        ItemEffectContext copy = this.copy();
        copy.vectors = ItemEffectContext.mergeVectors(copy.vectors, vectors);
        return copy;
    }

    @SafeVarargs
    public static Map<String, Vec3> mergeVectors(Map<String, Vec3> ... vectors) {
        return Stream.of(vectors).map(Map::entrySet).flatMap(Collection::stream).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> b));
    }

    public ItemEffectContext withEntities(Map<String, Entity> entities) {
        ItemEffectContext copy = this.copy();
        copy.entities = entities;
        return copy;
    }

    public ItemEffectContext withMergedEntities(Map<String, Entity> entities) {
        ItemEffectContext copy = this.copy();
        copy.entities = ItemEffectContext.mergeEntities(copy.entities, entities);
        return copy;
    }

    @SafeVarargs
    public static Map<String, Entity> mergeEntities(Map<String, Entity> ... entities) {
        return Stream.of(entities).map(Map::entrySet).flatMap(Collection::stream).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> b));
    }

    public ItemStack getUsedItemStack() {
        return this.usedItemStack;
    }

    public ServerLevel getLevel() {
        return this.level;
    }

    public Map<String, Float> getNumbers() {
        return this.numbers;
    }

    public Map<String, Vec3> getVectors() {
        return this.vectors;
    }

    public Map<String, Entity> getEntities() {
        return this.entities;
    }
}

