/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.effect.data.provider.number;

import com.google.common.reflect.TypeToken;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Stack;
import javax.annotation.Nullable;
import se.mickelus.tetra.data.DataManager;
import se.mickelus.tetra.effect.data.ItemEffectContext;
import se.mickelus.tetra.effect.data.ItemEffectData;
import se.mickelus.tetra.effect.data.provider.number.ContextNumberProvider;
import se.mickelus.tetra.effect.data.provider.number.DivideNumberProvider;
import se.mickelus.tetra.effect.data.provider.number.FixedNumberProvider;
import se.mickelus.tetra.effect.data.provider.number.MultiplyNumberProvider;
import se.mickelus.tetra.effect.data.provider.number.NumberProvider;
import se.mickelus.tetra.effect.data.provider.number.SubtractNumberProvider;
import se.mickelus.tetra.effect.data.provider.number.SumNumberProvider;

public class ExpressionNumberProvider
implements NumberProvider {
    private static final Type dataType = new TypeToken<Map<String, NumberProvider>>(){}.getType();
    private static final Map<Character, Integer> operatorPrecedence = Map.of(Character.valueOf('+'), 1, Character.valueOf('-'), 1, Character.valueOf('*'), 2, Character.valueOf('/'), 2);
    private final NumberProvider rootProvider;
    @Nullable
    private final Map<String, NumberProvider> numbers;

    public ExpressionNumberProvider(NumberProvider rootProvider, @Nullable Map<String, NumberProvider> numbers) {
        this.rootProvider = rootProvider;
        this.numbers = numbers;
    }

    @Override
    public float getValue(ItemEffectContext context) {
        if (this.numbers != null) {
            return this.rootProvider.getValue(context.withMergedNumbers(ItemEffectData.calculateNumbers(this.numbers, context)));
        }
        return this.rootProvider.getValue(context);
    }

    @Override
    public int getIntegerValue(ItemEffectContext context) {
        if (this.numbers != null) {
            return this.rootProvider.getIntegerValue(context.withMergedNumbers(ItemEffectData.calculateNumbers(this.numbers, context)));
        }
        return this.rootProvider.getIntegerValue(context);
    }

    public static ExpressionNumberProvider deserialize(JsonElement jsonElement) {
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        return new ExpressionNumberProvider(ExpressionNumberProvider.parseExpression(jsonObject.get("expression").getAsString()), (Map)DataManager.gson.fromJson(jsonObject.get("numbers"), dataType));
    }

    public static NumberProvider parseExpression(String expression) {
        Stack<NumberProvider> operandStack = new Stack<NumberProvider>();
        Stack<Character> operatorStack = new Stack<Character>();
        String trimmedExpression = expression.replace(" ", "");
        while (!trimmedExpression.isEmpty()) {
            int nextOperatorIndex = ExpressionNumberProvider.getNextOperatorIndex(trimmedExpression);
            if (nextOperatorIndex == 0) {
                char token = trimmedExpression.charAt(0);
                if (operatorPrecedence.containsKey(Character.valueOf(token))) {
                    while (!operatorStack.isEmpty() && operatorPrecedence.containsKey(operatorStack.peek()) && operatorPrecedence.get(Character.valueOf(token)) <= operatorPrecedence.get(operatorStack.peek())) {
                        ExpressionNumberProvider.createNumberProvider(operandStack, ((Character)operatorStack.pop()).charValue());
                    }
                    operatorStack.push(Character.valueOf(token));
                } else if (token == '(') {
                    operatorStack.push(Character.valueOf(token));
                } else if (token == ')') {
                    while (!operatorStack.isEmpty() && ((Character)operatorStack.peek()).charValue() != '(') {
                        ExpressionNumberProvider.createNumberProvider(operandStack, ((Character)operatorStack.pop()).charValue());
                    }
                    operatorStack.pop();
                }
                trimmedExpression = trimmedExpression.substring(1);
                continue;
            }
            String valueString = nextOperatorIndex != -1 ? trimmedExpression.substring(0, nextOperatorIndex) : trimmedExpression;
            String string = trimmedExpression = nextOperatorIndex != -1 ? trimmedExpression.substring(nextOperatorIndex) : "";
            if (ExpressionNumberProvider.isNumber(valueString)) {
                operandStack.push(new FixedNumberProvider(Float.parseFloat(valueString)));
                continue;
            }
            if (ExpressionNumberProvider.isReference(valueString)) {
                operandStack.push(new ContextNumberProvider(valueString));
                continue;
            }
            throw new IllegalArgumentException("Encountered invalid value '" + valueString + "' in expression: " + expression);
        }
        while (!operatorStack.isEmpty()) {
            ExpressionNumberProvider.createNumberProvider(operandStack, ((Character)operatorStack.pop()).charValue());
        }
        return (NumberProvider)operandStack.pop();
    }

    private static int getNextOperatorIndex(String expression) {
        for (int i = 0; i < expression.length(); ++i) {
            if (!ExpressionNumberProvider.isOperator(expression.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    private static boolean isOperator(char token) {
        return token == '(' || token == ')' || operatorPrecedence.containsKey(Character.valueOf(token));
    }

    private static boolean isNumber(String valueString) {
        return valueString.matches("^[0-9]*\\.?[0-9]+$");
    }

    private static boolean isReference(String valueString) {
        return valueString.matches("^[a-zA-Z_]+$");
    }

    private static void createNumberProvider(Stack<NumberProvider> operandStack, char operator) {
        NumberProvider right = operandStack.pop();
        NumberProvider left = operandStack.pop();
        switch (operator) {
            case '+': {
                operandStack.push(new SumNumberProvider(left, right));
                break;
            }
            case '-': {
                operandStack.push(new SubtractNumberProvider(left, right));
                break;
            }
            case '*': {
                operandStack.push(new MultiplyNumberProvider(left, right));
                break;
            }
            case '/': {
                operandStack.push(new DivideNumberProvider(left, right));
            }
        }
    }
}

