/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.gui.stats.data;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.util.GsonHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import se.mickelus.tetra.blocks.workbench.gui.WorkbenchStatsGui;
import se.mickelus.tetra.gui.stats.bar.GuiStatBase;
import se.mickelus.tetra.gui.stats.data.StatRegistry;
import se.mickelus.tetra.gui.stats.sorting.StatSorters;
import se.mickelus.tetra.items.modular.impl.holo.gui.craft.HoloStatsGui;

public class StatBarStore
implements ResourceManagerReloadListener {
    private static final Logger logger = LogManager.getLogger();
    public static StatBarStore instance;
    private GuiStatBase[] statBars = new GuiStatBase[0];

    public StatBarStore() {
        ((ReloadableResourceManager)Minecraft.m_91087_().m_91098_()).m_7217_((PreparableReloadListener)this);
        instance = this;
    }

    public void m_6213_(ResourceManager resourceManager) {
        this.statBars = StatBarStore.prepareBars();
        HoloStatsGui.setDataBars((GuiStatBase[])Arrays.stream(this.statBars).filter(bar -> Arrays.asList(bar.getContexts()).contains("tetra:holosphere")).toArray(GuiStatBase[]::new));
        WorkbenchStatsGui.setDataBars((GuiStatBase[])Arrays.stream(this.statBars).filter(bar -> Arrays.asList(bar.getContexts()).contains("tetra:workbench")).toArray(GuiStatBase[]::new));
        StatSorters.setDerivedSorters(Arrays.stream(this.statBars).map(GuiStatBase::getSorter).filter(Objects::nonNull).collect(Collectors.toList()));
    }

    public GuiStatBase[] getBars() {
        return this.statBars;
    }

    private static GuiStatBase[] prepareBars() {
        ResourceManager resourceManager = Minecraft.m_91087_().m_91098_();
        return (GuiStatBase[])resourceManager.m_214159_("stat_bars", rl -> rl.m_135815_().endsWith(".json")).entrySet().stream().filter(entry -> "tetra".equals(((ResourceLocation)entry.getKey()).m_135827_())).map(entry -> StatBarStore.parseBar((ResourceLocation)entry.getKey(), (Resource)entry.getValue())).filter(Objects::nonNull).toArray(GuiStatBase[]::new);
    }

    @Nullable
    private static GuiStatBase parseBar(ResourceLocation resourceLocation, Resource resource) {
        GuiStatBase guiStatBase;
        block8: {
            BufferedReader reader = resource.m_215508_();
            try {
                guiStatBase = (GuiStatBase)((Object)GsonHelper.m_13776_((Gson)StatRegistry.gson, (Reader)reader, GuiStatBase.class));
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JsonParseException | IOException e) {
                    logger.error("Failed to parse statbar data from '{}': {}", (Object)resourceLocation, (Object)e);
                    return null;
                }
            }
            reader.close();
        }
        return guiStatBase;
    }
}

