/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular.impl.holo.gui.scan;

import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import se.mickelus.mutil.gui.GuiAttachment;
import se.mickelus.mutil.gui.GuiElement;
import se.mickelus.mutil.gui.GuiRect;
import se.mickelus.mutil.gui.GuiString;
import se.mickelus.mutil.gui.GuiStringOutline;
import se.mickelus.mutil.gui.GuiTexture;
import se.mickelus.mutil.gui.animation.AnimationChain;
import se.mickelus.mutil.gui.animation.Applier;
import se.mickelus.mutil.gui.animation.KeyframeAnimation;
import se.mickelus.tetra.gui.GuiTextures;

@ParametersAreNonnullByDefault
public class ScannerBarGui
extends GuiElement {
    private static final int unitWidth = 6;
    private final KeyframeAnimation showAnimation;
    private final KeyframeAnimation hideAnimation;
    private final GuiString statusLabel;
    private final KeyframeAnimation statusInAnimation;
    private final KeyframeAnimation statusOutAnimation;
    int horizontalSpread;
    private AnimationChain[] upAnimations;
    private AnimationChain[] upHighlightAnimations;
    private AnimationChain[] midAnimations;
    private AnimationChain[] midHighlightAnimations;
    private AnimationChain[] downAnimations;
    private AnimationChain[] downHighlightAnimations;
    private boolean hasStatus;

    public ScannerBarGui(int x, int y, int horizontalSpread) {
        super(x, y, horizontalSpread * 6, 9);
        this.horizontalSpread = horizontalSpread;
        this.statusLabel = new GuiStringOutline(-2, 0, "");
        this.statusLabel.setAttachment(GuiAttachment.middleCenter);
        this.statusLabel.setOpacity(0.0f);
        this.addChild((GuiElement)this.statusLabel);
        this.statusInAnimation = new KeyframeAnimation(200, (GuiElement)this.statusLabel).applyTo(new Applier[]{new Applier.Opacity(1.0f), new Applier.TranslateX(-2.0f, 0.0f)});
        this.statusOutAnimation = new KeyframeAnimation(300, (GuiElement)this.statusLabel).applyTo(new Applier[]{new Applier.Opacity(0.0f), new Applier.TranslateX(0.0f, 2.0f)});
        this.showAnimation = new KeyframeAnimation(300, (GuiElement)this).applyTo(new Applier[]{new Applier.Opacity(1.0f), new Applier.TranslateY((float)y, (float)(y - 4))});
        this.hideAnimation = new KeyframeAnimation(300, (GuiElement)this).applyTo(new Applier[]{new Applier.Opacity(0.0f), new Applier.TranslateY((float)(y - 4), (float)y)}).withDelay(200).onStop(complete -> {
            this.isVisible = false;
        });
        this.setup();
    }

    public static double getDegreesPerUnit() {
        return 1.0 * (double)((Integer)Minecraft.m_91087_().f_91066_.m_231837_().m_231551_()).intValue() * 6.0 / (double)Minecraft.m_91087_().m_91268_().m_85445_();
    }

    private void setup() {
        int i;
        this.setWidth(this.horizontalSpread * 6);
        this.upAnimations = new AnimationChain[this.horizontalSpread];
        this.midAnimations = new AnimationChain[this.horizontalSpread];
        this.downAnimations = new AnimationChain[this.horizontalSpread];
        this.upHighlightAnimations = new AnimationChain[this.horizontalSpread];
        this.midHighlightAnimations = new AnimationChain[this.horizontalSpread];
        this.downHighlightAnimations = new AnimationChain[this.horizontalSpread];
        this.addChild(new GuiRect(-3, -2, this.getWidth() + 3, this.getHeight() + 2, 0).setOpacity(0.5f));
        this.addChild(new GuiTexture(-2, -1, 2, 2, 1, 1, GuiTextures.hud).setOpacity(0.8f).setAttachment(GuiAttachment.topLeft));
        this.addChild(new GuiTexture(-2, -1, 2, 2, 1, 0, GuiTextures.hud).setOpacity(0.8f).setAttachment(GuiAttachment.bottomLeft));
        this.addChild(new GuiTexture(-1, -1, 2, 2, 0, 1, GuiTextures.hud).setOpacity(0.8f).setAttachment(GuiAttachment.topRight));
        this.addChild(new GuiTexture(-1, -1, 2, 2, 0, 0, GuiTextures.hud).setOpacity(0.8f).setAttachment(GuiAttachment.bottomRight));
        this.addChild(new GuiTexture(-2, -1, 3, 2, 0, 1, GuiTextures.hud).setOpacity(0.8f).setAttachment(GuiAttachment.topCenter));
        this.addChild(new GuiTexture(-2, -1, 3, 2, 0, 0, GuiTextures.hud).setOpacity(0.8f).setAttachment(GuiAttachment.bottomCenter));
        for (i = 0; i < this.horizontalSpread; ++i) {
            GuiElement up = new GuiTexture(i * 6, 0, 3, 3, GuiTextures.hud).setOpacity(0.3f);
            this.addChild(up);
            this.upAnimations[i] = new AnimationChain(new KeyframeAnimation[]{new KeyframeAnimation(100, up).applyTo(new Applier[]{new Applier.Opacity(0.7f)}), new KeyframeAnimation(600, up).applyTo(new Applier[]{new Applier.Opacity(0.3f)})});
            GuiElement upHighlight = new GuiTexture(i * 6, 0, 3, 3, GuiTextures.hud).setColor(15882800).setOpacity(0.0f);
            this.addChild(upHighlight);
            this.upHighlightAnimations[i] = new AnimationChain(new KeyframeAnimation[]{new KeyframeAnimation(100, upHighlight).applyTo(new Applier[]{new Applier.Opacity(0.9f)}), new KeyframeAnimation(1000, upHighlight).applyTo(new Applier[]{new Applier.Opacity(0.0f)})});
            GuiElement down = new GuiTexture(i * 6, 4, 3, 3, GuiTextures.hud).setOpacity(0.3f);
            this.addChild(down);
            this.downAnimations[i] = new AnimationChain(new KeyframeAnimation[]{new KeyframeAnimation(100, down).applyTo(new Applier[]{new Applier.Opacity(0.7f)}), new KeyframeAnimation(600, down).applyTo(new Applier[]{new Applier.Opacity(0.3f)})});
            GuiElement downHighlight = new GuiTexture(i * 6, 4, 3, 3, GuiTextures.hud).setColor(15882800).setOpacity(0.0f);
            this.addChild(downHighlight);
            this.downHighlightAnimations[i] = new AnimationChain(new KeyframeAnimation[]{new KeyframeAnimation(100, downHighlight).applyTo(new Applier[]{new Applier.Opacity(0.9f)}), new KeyframeAnimation(1000, downHighlight).applyTo(new Applier[]{new Applier.Opacity(0.0f)})});
        }
        for (i = 0; i < this.horizontalSpread - 1; ++i) {
            GuiElement center = new GuiTexture(i * 6 + 3, 2, 3, 3, GuiTextures.hud).setOpacity(0.3f);
            this.addChild(center);
            this.midAnimations[i] = new AnimationChain(new KeyframeAnimation[]{new KeyframeAnimation(100, center).applyTo(new Applier[]{new Applier.Opacity(0.7f)}), new KeyframeAnimation(600, center).applyTo(new Applier[]{new Applier.Opacity(0.3f)})});
            GuiElement centerHighlight = new GuiTexture(i * 6 + 3, 2, 3, 3, GuiTextures.hud).setColor(15882800).setOpacity(0.0f);
            this.addChild(centerHighlight);
            this.midHighlightAnimations[i] = new AnimationChain(new KeyframeAnimation[]{new KeyframeAnimation(100, centerHighlight).applyTo(new Applier[]{new Applier.Opacity(0.9f)}), new KeyframeAnimation(1000, centerHighlight).applyTo(new Applier[]{new Applier.Opacity(0.0f)})});
        }
        this.addChild((GuiElement)this.statusLabel);
    }

    public void setHorizontalSpread(int horizontalSpread) {
        if (horizontalSpread != 0 && this.horizontalSpread != horizontalSpread) {
            this.horizontalSpread = horizontalSpread;
            this.clearChildren();
            this.setup();
        }
    }

    public void setStatus(String status) {
        if (status != null != this.hasStatus) {
            boolean bl = this.hasStatus = status != null;
            if (this.hasStatus) {
                this.statusOutAnimation.stop();
                this.statusInAnimation.start();
            } else {
                this.statusInAnimation.stop();
                this.statusOutAnimation.start();
            }
        }
        this.statusLabel.setString(status);
    }

    protected void show() {
        this.isVisible = true;
        if (this.opacity < 1.0f && !this.showAnimation.isActive()) {
            this.isVisible = true;
            this.hideAnimation.stop();
            this.showAnimation.start();
        }
    }

    protected boolean hide() {
        if (this.opacity > 0.0f && !this.hideAnimation.isActive()) {
            this.showAnimation.stop();
            this.hideAnimation.start();
        }
        return false;
    }

    public void highlightUp(int index, boolean wasHit) {
        if (this.opacity == 1.0f) {
            if (wasHit) {
                this.upHighlightAnimations[index].start();
            } else {
                this.upAnimations[index].start();
            }
        }
    }

    public void highlightMid(int index, boolean wasHit) {
        if (this.opacity == 1.0f) {
            if (wasHit) {
                this.midHighlightAnimations[index].start();
            } else {
                this.midAnimations[index].start();
            }
        }
    }

    public void highlightDown(int index, boolean wasHit) {
        if (this.opacity == 1.0f) {
            if (wasHit) {
                this.downHighlightAnimations[index].start();
            } else {
                this.downAnimations[index].start();
            }
        }
    }
}

