/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.reap;

import de.maxhenkel.reap.Main;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class TreeEvents {
    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        ItemStack heldItem;
        Level world = (Level)event.getLevel();
        if (!((Boolean)Main.SERVER_CONFIG.treeHarvest.get()).booleanValue() || world.m_5776_()) {
            return;
        }
        Player player = event.getPlayer();
        BlockPos pos = event.getPos();
        if (TreeEvents.canHarvest(pos, player, world, heldItem = player.m_21205_())) {
            TreeEvents.destroyTree(player, world, pos, heldItem);
        }
    }

    @SubscribeEvent
    public void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        if (!((Boolean)Main.SERVER_CONFIG.treeHarvest.get()).booleanValue() || !((Boolean)Main.SERVER_CONFIG.dynamicTreeBreakingEnabled.get()).booleanValue()) {
            return;
        }
        Player player = event.getEntity();
        BlockPos pos = event.getPosition().orElse(null);
        if (pos == null) {
            return;
        }
        if (TreeEvents.canHarvest(pos, player, player.m_9236_(), player.m_21205_())) {
            List<BlockPos> connectedLogs = TreeEvents.getConnectedLogs(player.m_9236_(), pos);
            event.setNewSpeed((float)((double)event.getOriginalSpeed() / Math.min(1.0 + (Double)Main.SERVER_CONFIG.dynamicTreeBreakingPerLog.get() * (double)connectedLogs.size(), (Double)Main.SERVER_CONFIG.dynamicTreeBreakingMinSpeed.get())));
        }
    }

    public static boolean canHarvest(BlockPos pos, Player player, Level world, ItemStack heldItem) {
        if (player.m_150110_().f_35937_) {
            return false;
        }
        if (player.m_6144_()) {
            return false;
        }
        if (Main.SERVER_CONFIG.allowedTreeTools.stream().noneMatch(tag -> tag.contains(heldItem.m_41720_()))) {
            return false;
        }
        if (!TreeEvents.isLog(world, pos)) {
            return false;
        }
        if (!TreeEvents.isGround(world, pos.m_7495_())) {
            return false;
        }
        BlockState state = world.m_8055_(pos);
        return !state.m_61147_().stream().anyMatch(p -> p.equals((Object)RotatedPillarBlock.f_55923_)) || ((Direction.Axis)state.m_61143_((Property)RotatedPillarBlock.f_55923_)).equals((Object)Direction.Axis.Y);
    }

    private static void destroyTree(Player player, Level world, BlockPos pos, ItemStack heldItem) {
        List<BlockPos> connectedLogs = TreeEvents.getConnectedLogs(world, pos);
        for (BlockPos logPos : connectedLogs) {
            TreeEvents.destroy(world, player, logPos, heldItem);
        }
    }

    private static List<BlockPos> getConnectedLogs(Level world, BlockPos pos) {
        BlockPosList positions = new BlockPosList();
        TreeEvents.collectLogs(world, pos, positions);
        return positions;
    }

    private static void collectLogs(Level world, BlockPos pos, BlockPosList positions) {
        int maxHarvestingCount = (Integer)Main.SERVER_CONFIG.treeHarvestMaxCount.get();
        if (positions.size() >= maxHarvestingCount) {
            return;
        }
        ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    BlockPos p = pos.m_7918_(x, y, z);
                    if (!TreeEvents.isLog(world, p)) continue;
                    if (positions.size() <= maxHarvestingCount) {
                        if (!positions.add(p)) continue;
                        posList.add(p);
                        continue;
                    }
                    return;
                }
            }
        }
        for (BlockPos p : posList) {
            TreeEvents.collectLogs(world, p, positions);
        }
    }

    private static boolean isLog(Level world, BlockPos pos) {
        BlockState b = world.m_8055_(pos);
        return Main.SERVER_CONFIG.logTypes.stream().anyMatch(tag -> tag.contains(b.m_60734_()));
    }

    private static boolean isGround(Level world, BlockPos pos) {
        BlockState b = world.m_8055_(pos);
        return Main.SERVER_CONFIG.groundTypes.stream().anyMatch(tag -> tag.contains(b.m_60734_()));
    }

    private static void destroy(Level world, Player player, BlockPos pos, ItemStack heldItem) {
        if (heldItem != null) {
            heldItem.m_41720_().m_6813_(heldItem, world, world.m_8055_(pos), pos, (LivingEntity)player);
            world.m_46961_(pos, true);
            player.m_36399_(0.025f);
        }
    }

    private static class BlockPosList
    extends ArrayList<BlockPos> {
        private BlockPosList() {
        }

        @Override
        public boolean add(BlockPos pos) {
            if (!this.contains(pos)) {
                return super.add(pos);
            }
            return false;
        }

        @Override
        public boolean contains(Object o) {
            return this.stream().anyMatch(pos1 -> pos1.equals(o));
        }
    }
}

