/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.playerdata;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lostcities.playerdata.PlayerProperties;
import mcjty.lostcities.playerdata.PlayerSpawnSet;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;

public class PropertiesDispatcher
implements ICapabilityProvider,
INBTSerializable<CompoundTag> {
    private PlayerSpawnSet playerSpawnSet = null;
    private final LazyOptional<PlayerSpawnSet> opt = LazyOptional.of(this::createPlayerSpawnSet);

    @Nonnull
    private PlayerSpawnSet createPlayerSpawnSet() {
        if (this.playerSpawnSet == null) {
            this.playerSpawnSet = new PlayerSpawnSet();
        }
        return this.playerSpawnSet;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap) {
        if (cap == PlayerProperties.PLAYER_SPAWN_SET) {
            return this.opt.cast();
        }
        return LazyOptional.empty();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return this.getCapability(cap);
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        this.createPlayerSpawnSet().saveNBTData(nbt);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.createPlayerSpawnSet().loadNBTData(nbt);
    }
}

