/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.worldgen.lost.cityassets;

import java.util.HashMap;
import java.util.Map;
import mcjty.lostcities.api.ILostCityAsset;
import mcjty.lostcities.worldgen.lost.BuildingInfo;
import mcjty.lostcities.worldgen.lost.cityassets.AssetRegistries;
import mcjty.lostcities.worldgen.lost.cityassets.IBuildingPart;
import mcjty.lostcities.worldgen.lost.cityassets.Palette;
import mcjty.lostcities.worldgen.lost.regassets.BuildingPartRE;
import mcjty.lostcities.worldgen.lost.regassets.data.DataTools;
import mcjty.lostcities.worldgen.lost.regassets.data.PartMeta;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.CommonLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public class BuildingPart
implements IBuildingPart,
ILostCityAsset {
    private final ResourceLocation name;
    private final String[] slices;
    private final int xSize;
    private final int zSize;
    private char[][] vslices = null;
    private Palette localPalette = null;
    private String refPaletteName;
    private final Map<String, Object> metadata = new HashMap<String, Object>();

    public BuildingPart(BuildingPartRE object) {
        this.name = object.getRegistryName();
        this.xSize = object.getxSize();
        this.zSize = object.getzSize();
        this.slices = object.getSlices();
        if (object.getLocalPalette() != null) {
            this.localPalette = new Palette("__local__" + this.name.m_135815_());
            this.localPalette.parsePaletteArray(object.getLocalPalette());
        } else if (object.getRefPaletteName() != null) {
            this.refPaletteName = object.getRefPaletteName();
        }
        if (object.getMetadata() != null) {
            for (PartMeta meta : object.getMetadata()) {
                String key = meta.key();
                if (meta.i() != null) {
                    this.metadata.put(key, meta.i());
                    continue;
                }
                if (meta.f() != null) {
                    this.metadata.put(key, meta.f());
                    continue;
                }
                if (meta.bool() != null) {
                    this.metadata.put(key, meta.bool());
                    continue;
                }
                if (meta.chr() != null) {
                    this.metadata.put(key, Character.valueOf(meta.chr().charAt(0)));
                    continue;
                }
                if (meta.str() == null) continue;
                this.metadata.put(key, meta.str());
            }
        }
    }

    @Override
    public Character getMetaChar(String key) {
        return (Character)this.metadata.get(key);
    }

    @Override
    public Integer getMetaInteger(String key) {
        return (Integer)this.metadata.get(key);
    }

    @Override
    public boolean getMetaBoolean(String key) {
        Object o = this.metadata.get(key);
        return o instanceof Boolean ? (Boolean)o : false;
    }

    @Override
    public Float getMetaFloat(String key) {
        return (Float)this.metadata.get(key);
    }

    @Override
    public String getMetaString(String key) {
        return (String)this.metadata.get(key);
    }

    public String getRefPaletteName() {
        return this.refPaletteName;
    }

    @Override
    public String getName() {
        return DataTools.toName(this.name);
    }

    @Override
    public ResourceLocation getId() {
        return this.name;
    }

    @Override
    public char[][] getVslices() {
        if (this.vslices == null) {
            this.vslices = new char[this.xSize * this.zSize][];
            for (int x = 0; x < this.xSize; ++x) {
                for (int z = 0; z < this.zSize; ++z) {
                    StringBuilder vs = new StringBuilder();
                    boolean empty = true;
                    for (int y = 0; y < this.slices.length; ++y) {
                        Character c = this.getC(x, y, z);
                        vs.append(c);
                        if (c.charValue() == ' ') continue;
                        empty = false;
                    }
                    this.vslices[z * this.xSize + x] = (char[])(empty ? null : vs.toString().toCharArray());
                }
            }
        }
        return this.vslices;
    }

    @Override
    public char[] getVSlice(int x, int z) {
        return this.getVslices()[z * this.xSize + x];
    }

    @Override
    public Palette getLocalPalette(CommonLevelAccessor level) {
        if (this.localPalette == null && this.refPaletteName != null) {
            this.localPalette = AssetRegistries.PALETTES.getOrThrow(level, this.refPaletteName);
        }
        return this.localPalette;
    }

    @Override
    public int getSliceCount() {
        return this.slices.length;
    }

    public String getSlice(int i) {
        return this.slices[i];
    }

    public String[] getSlices() {
        return this.slices;
    }

    @Override
    public int getXSize() {
        return this.xSize;
    }

    @Override
    public int getZSize() {
        return this.zSize;
    }

    public Character getPaletteChar(int x, int y, int z) {
        return Character.valueOf(this.slices[y].charAt(z * this.xSize + x));
    }

    public BlockState get(BuildingInfo info, int x, int y, int z) {
        return info.getCompiledPalette().get(this.slices[y].charAt(z * this.xSize + x));
    }

    public Character getC(int x, int y, int z) {
        return Character.valueOf(this.slices[y].charAt(z * this.xSize + x));
    }
}

