/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.retrodamageindicators;

import com.github.alexmodguy.retrodamageindicators.Config;
import com.github.alexmodguy.retrodamageindicators.RetroDamageIndicators;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Optional;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.particles.ParticleGroup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class DamageIndicatorParticle
extends Particle {
    private static final ParticleGroup GROUP = new ParticleGroup(1000);
    private final Component damageString;
    private final boolean heal;
    private float scale;
    private float prevScale;

    protected DamageIndicatorParticle(ClientLevel clientLevel, double x, double y, double z, double damageAmount, boolean heal) {
        super(clientLevel, x, y, z);
        this.f_107225_ = 15 + clientLevel.f_46441_.m_188503_(5);
        Object text = (Boolean)Config.INSTANCE.healthDecimals.get() != false ? String.valueOf(RetroDamageIndicators.roundHealth((float)damageAmount)).replace(".0", "") : "" + (int)damageAmount;
        this.damageString = Component.m_237113_((String)text);
        this.heal = heal;
        this.scale = 1.0f;
        this.f_107216_ = (double)0.2f + Math.random() * (double)0.2f;
        this.f_107226_ = 1.3f;
    }

    public void m_5989_() {
        super.m_5989_();
        float ageScaled = (float)this.f_107224_ / (float)this.f_107225_;
        this.prevScale = this.scale;
        this.scale = 1.0f - ageScaled;
    }

    public void m_5744_(VertexConsumer vertexConsumer, Camera camera, float partialTicks) {
        MultiBufferSource.BufferSource multibuffersource$buffersource = Minecraft.m_91087_().m_91269_().m_110104_();
        Vec3 cameraPos = camera.m_90583_();
        double x = (float)Mth.m_14139_((double)partialTicks, (double)this.f_107209_, (double)this.f_107212_);
        double y = (float)Mth.m_14139_((double)partialTicks, (double)this.f_107210_, (double)this.f_107213_);
        double z = (float)Mth.m_14139_((double)partialTicks, (double)this.f_107211_, (double)this.f_107214_);
        int color = this.heal ? 65280 : 0xFF0000;
        int colorOutline = this.heal ? 13056 : 0x330000;
        float scale = this.getScale(partialTicks) * 0.035f;
        PoseStack posestack = new PoseStack();
        posestack.m_85836_();
        posestack.m_85837_(x - cameraPos.f_82479_, y - cameraPos.f_82480_, z - cameraPos.f_82481_);
        posestack.m_252781_(camera.m_253121_());
        posestack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        float f = -Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)this.damageString) / 2;
        posestack.m_85841_(scale, scale, scale);
        posestack.m_252880_(0.0f, -2.0f, 0.0f);
        if (((Boolean)Config.INSTANCE.damageParticleOutline.get()).booleanValue()) {
            Minecraft.m_91087_().f_91062_.m_168645_(this.damageString.m_7532_(), f, 0.0f, color, colorOutline, posestack.m_85850_().m_252922_(), (MultiBufferSource)multibuffersource$buffersource, 0xF000F0);
        } else {
            Minecraft.m_91087_().f_91062_.m_272191_(this.damageString.m_7532_(), f, 0.0f, color, false, posestack.m_85850_().m_252922_(), (MultiBufferSource)multibuffersource$buffersource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        }
        multibuffersource$buffersource.m_109911_();
        posestack.m_85849_();
    }

    private float getScale(float partialTicks) {
        return this.prevScale + (this.scale - this.prevScale) * partialTicks;
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107433_;
    }

    public Optional<ParticleGroup> m_142654_() {
        return Optional.of(GROUP);
    }
}

