/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.screens.widgets;

import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetBase;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetElement;
import com.tiviacz.travelersbackpack.client.screens.widgets.filter.IFilter;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.upgrades.IEnable;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.inventory.upgrades.UpgradeBase;
import com.tiviacz.travelersbackpack.items.upgrades.UpgradeItem;
import com.tiviacz.travelersbackpack.network.ServerboundActionTagPacket;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;

public class UpgradeWidgetBase<U extends UpgradeBase>
extends WidgetBase<BackpackScreen> {
    private final WidgetElement removeElement;
    private final WidgetElement enableElement;
    protected U upgrade;
    protected int dataHolderSlot;
    private final Point tabUv;
    private final String upgradeIconTooltip;

    public UpgradeWidgetBase(BackpackScreen screen, U upgrade, Point pos, Point tabUv, String upgradeIconTooltip) {
        super(screen, pos, 24, 24);
        this.upgrade = upgrade;
        this.dataHolderSlot = ((UpgradeBase)upgrade).getDataHolderSlot();
        this.tabUv = tabUv;
        this.upgradeIconTooltip = upgradeIconTooltip;
        this.width = ((UpgradeBase)upgrade).getTabSize().x();
        this.height = ((UpgradeBase)upgrade).getTabSize().y();
        this.removeElement = new WidgetElement(new Point(((UpgradeBase)this.upgrade).getTabSize().x() - 3 - 18, 3), new Point(18, 18));
        this.enableElement = new WidgetElement(new Point(((UpgradeBase)this.upgrade).getTabSize().x(), 6), new Point(4, 13));
    }

    public U getUpgrade() {
        return this.upgrade;
    }

    @Override
    public void renderBg(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY) {
        if (this.isTabOpened()) {
            U u = this.upgrade;
            if (u instanceof IFilter) {
                IFilter filter = (IFilter)u;
                int slotCount = filter.getFilterSlotCount();
                int rowCount = (int)Math.ceil((double)slotCount / 3.0);
                guiGraphics.m_280218_(BackpackScreen.TABS, this.pos.x(), this.pos.y(), this.tabUv.x(), this.tabUv.y(), this.width, 43);
                guiGraphics.m_280218_(BackpackScreen.TABS, this.pos.x(), this.pos.y() + 43, this.tabUv.x(), this.tabUv.y() + 43 + (3 - rowCount) * 18, this.width, this.height - 43);
                for (int i = 0; i < 3; ++i) {
                    for (int j = 0; j < 3; ++j) {
                        if (j + i * 3 >= slotCount) continue;
                        guiGraphics.m_280218_(BackpackScreen.TABS, this.pos.x() + 6 + j * 18, this.pos.y() + 43 + i * 18, 233, 0, 18, 18);
                    }
                }
            } else {
                guiGraphics.m_280218_(BackpackScreen.TABS, this.pos.x(), this.pos.y(), this.tabUv.x(), this.tabUv.y(), this.width, this.height);
            }
            guiGraphics.m_280480_(((BackpackScreen)this.screen).getWrapper().getUpgrades().getStackInSlot(this.dataHolderSlot), this.pos.x() + 4, this.pos.y() + 4);
        }
    }

    @Override
    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderEnableButton(guiGraphics, mouseX, mouseY, partialTicks);
        if (this.isBackpackOwner()) {
            this.renderRemoveButton(guiGraphics, mouseX, mouseY);
        }
    }

    @Override
    public void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (this.isMouseOverIcon(mouseX, mouseY)) {
            UpgradeItem upgradeItem;
            Item item;
            ArrayList<MutableComponent> tooltips = new ArrayList<MutableComponent>();
            tooltips.add(Component.m_237115_((String)this.upgradeIconTooltip));
            if (((UpgradeBase)this.getUpgrade()).getUpgradeManager().getWrapper().getScreenID() != 2 && (item = ((UpgradeBase)this.upgrade).getDataHolderStack().m_41720_()) instanceof UpgradeItem && (upgradeItem = (UpgradeItem)item).requiresEquippedBackpack()) {
                tooltips.add(Component.m_237115_((String)"screen.travelersbackpack.equip_to_use"));
            }
            guiGraphics.m_280677_(((BackpackScreen)this.screen).getFont(), tooltips, Optional.empty(), mouseX, mouseY);
        }
        this.renderEnableButtonTooltip(guiGraphics, mouseX, mouseY);
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        if (this.enableButtonMouseClicked(pMouseX, pMouseY, pButton)) {
            return true;
        }
        if (this.removeButtonMouseClicked(pMouseX, pMouseY, pButton)) {
            return true;
        }
        if (this.isMouseOverIcon(pMouseX, pMouseY)) {
            if (((UpgradeBase)this.upgrade).isTabOpened()) {
                ServerboundActionTagPacket.create(0, this.dataHolderSlot, false, 0);
            } else {
                ServerboundActionTagPacket.create(0, this.dataHolderSlot, true, 0);
            }
            ((BackpackScreen)this.screen).playUIClickSound();
            return true;
        }
        return false;
    }

    @Override
    public boolean m_5953_(double pMouseX, double pMouseY) {
        return pMouseX > (double)(this.pos.x() + 3) && pMouseY > (double)this.pos.y() && pMouseX < (double)(this.pos.x() + ((UpgradeBase)this.upgrade).getTabSize().x()) && pMouseY < (double)(this.pos.y() + ((UpgradeBase)this.upgrade).getTabSize().y());
    }

    public boolean isMouseOverRemoveButton(double mouseX, double mouseY) {
        return this.isWithinBounds(mouseX, mouseY, this.removeElement);
    }

    public boolean isMouseOverEnableButton(double mouseX, double mouseY) {
        return this.isWithinBounds(mouseX, mouseY, this.enableElement);
    }

    public void renderMatchContentsSlotOverlay(GuiGraphics guiGraphics, List<Integer> filter, int settingType, int settingValue, int activeSlots) {
        if (this.isTabOpened() && filter.get(settingType) == settingValue) {
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    if (j + i * 3 >= activeSlots) continue;
                    guiGraphics.m_280218_(BackpackScreen.ICONS, this.pos.x() + 6 + 18 * j, this.pos.y() + 43 + 18 * i, 24, 36, 18, 18);
                }
            }
        }
    }

    public void renderRemoveButton(GuiGraphics guiGraphics, double mouseX, double mouseY) {
        if (this.isTabOpened()) {
            guiGraphics.m_280218_(BackpackScreen.ICONS, this.pos.x() + this.removeElement.pos().x(), this.pos.y() + this.removeElement.pos().y(), 42, 36, this.removeElement.size().x(), this.removeElement.size().y());
        }
    }

    public boolean removeButtonMouseClicked(double pMouseX, double pMouseY, int pButton) {
        if (((UpgradeBase)this.upgrade).isTabOpened() && this.isMouseOverRemoveButton(pMouseX, pMouseY)) {
            if (!this.isBackpackOwner()) {
                return false;
            }
            ServerboundActionTagPacket.create(9, this.dataHolderSlot);
            ((BackpackScreen)this.screen).playUIClickSound();
            return true;
        }
        return false;
    }

    public void renderEnableButton(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        U u = this.upgrade;
        if (u instanceof IEnable) {
            IEnable e = (IEnable)u;
            if (!((UpgradeBase)this.upgrade).isTabOpened()) {
                if (e.isEnabled((UpgradeBase<?>)this.upgrade)) {
                    guiGraphics.m_280218_(BackpackScreen.ICONS, this.pos.x() + this.enableElement.pos().x(), this.pos.y() + this.enableElement.pos().y(), 18, 24, this.enableElement.size().x(), this.enableElement.size().y());
                    if (this.isMouseOverEnableButton(mouseX, mouseY)) {
                        guiGraphics.m_285978_(RenderType.m_286086_(), this.pos.x() + this.enableElement.pos().x(), this.pos.y() + this.enableElement.pos().y() + 7, this.pos.x() + this.enableElement.pos().x() + 3, this.pos.y() + this.enableElement.pos().y() + 12, -2130706433, -2130706433, 0);
                    }
                } else {
                    guiGraphics.m_280218_(BackpackScreen.ICONS, this.pos.x() + this.enableElement.pos().x(), this.pos.y() + this.enableElement.pos().y(), 18, 37, this.enableElement.size().x(), this.enableElement.size().y());
                    if (this.isMouseOverEnableButton(mouseX, mouseY)) {
                        guiGraphics.m_285978_(RenderType.m_286086_(), this.pos.x() + this.enableElement.pos().x(), this.pos.y() + this.enableElement.pos().y() + 1, this.pos.x() + this.enableElement.pos().x() + 3, this.pos.y() + this.enableElement.pos().y() + 6, -2130706433, -2130706433, 0);
                    }
                }
            }
        }
    }

    public void renderEnableButtonTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        U u = this.upgrade;
        if (u instanceof IEnable) {
            IEnable e = (IEnable)u;
            if (!((UpgradeBase)this.upgrade).isTabOpened() && this.isMouseOverEnableButton(mouseX, mouseY)) {
                if (e.isEnabled((UpgradeBase<?>)this.upgrade)) {
                    guiGraphics.m_280557_(((BackpackScreen)this.screen).getFont(), (Component)Component.m_237113_((String)"Disable Upgrade"), mouseX, mouseY);
                } else {
                    guiGraphics.m_280557_(((BackpackScreen)this.screen).getFont(), (Component)Component.m_237113_((String)"Enable Upgrade"), mouseX, mouseY);
                }
            }
        }
    }

    public boolean enableButtonMouseClicked(double pMouseX, double pMouseY, int pButton) {
        U u = this.upgrade;
        if (u instanceof IEnable) {
            IEnable e = (IEnable)u;
            if (!((UpgradeBase)this.upgrade).isTabOpened() && this.isMouseOverEnableButton(pMouseX, pMouseY)) {
                if (!this.isBackpackOwner()) {
                    return false;
                }
                ServerboundActionTagPacket.create(0, this.dataHolderSlot, !e.isEnabled((UpgradeBase<?>)this.upgrade), 1);
                ((BackpackScreen)this.screen).playUIClickSound();
                return true;
            }
        }
        return false;
    }

    public boolean isBackpackOwner() {
        return ((BackpackScreen)this.screen).getWrapper().isOwner(((BackpackBaseMenu)((BackpackScreen)this.screen).m_6262_()).player);
    }

    public boolean isTabOpened() {
        return ((UpgradeBase)this.upgrade).isTabOpened();
    }

    @Override
    public int[] getWidgetSizeAndPos() {
        int[] size = new int[]{this.pos.x(), this.pos.y(), this.width + (this.upgrade instanceof IEnable && !this.isTabOpened() ? 4 : 0), this.height};
        return size;
    }
}

