/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.menu;

import com.mojang.datafixers.util.Pair;
import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.compat.polymorph.PolymorphCompat;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.menu.AbstractBackpackMenu;
import com.tiviacz.travelersbackpack.inventory.menu.slot.BackpackSlotItemHandler;
import com.tiviacz.travelersbackpack.inventory.menu.slot.CraftingSlot;
import com.tiviacz.travelersbackpack.inventory.menu.slot.FilterSlotItemHandler;
import com.tiviacz.travelersbackpack.inventory.menu.slot.ResultSlotExt;
import com.tiviacz.travelersbackpack.inventory.menu.slot.ToolSlotItemHandler;
import com.tiviacz.travelersbackpack.inventory.menu.slot.TrashSlot;
import com.tiviacz.travelersbackpack.inventory.menu.slot.UpgradeLockableSlotItemHandler;
import com.tiviacz.travelersbackpack.inventory.menu.slot.UpgradeSlotItemHandler;
import com.tiviacz.travelersbackpack.inventory.upgrades.IUpgrade;
import com.tiviacz.travelersbackpack.inventory.upgrades.crafting.CraftingUpgrade;
import com.tiviacz.travelersbackpack.inventory.upgrades.tanks.TanksUpgrade;
import com.tiviacz.travelersbackpack.inventory.upgrades.voiding.VoidUpgrade;
import com.tiviacz.travelersbackpack.items.upgrades.UpgradeItem;
import com.tiviacz.travelersbackpack.network.ClientboundUpdateRecipePacket;
import com.tiviacz.travelersbackpack.util.ItemStackUtils;
import com.tiviacz.travelersbackpack.util.NbtHelper;
import com.tiviacz.travelersbackpack.util.PacketDistributorHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class BackpackBaseMenu
extends AbstractBackpackMenu {
    public List<UpgradeLockableSlotItemHandler> upgradeSlot = new ArrayList<UpgradeLockableSlotItemHandler>();
    public int unmodifiableSlotCount = 0;
    public int TOOL_START;
    public int TOOL_END;
    public int UPGRADE_START;
    public int UPGRADE_END;
    public int CRAFTING_RESULT;
    public int CRAFTING_GRID_START;
    public int CRAFTING_GRID_END;

    public BackpackBaseMenu(MenuType<?> type, int windowID, Inventory inventory, BackpackWrapper wrapper) {
        super(type, windowID, inventory, wrapper);
        this.addSlots();
    }

    public void addSlots() {
        if (this.wrapper.tanksVisible()) {
            this.extendedScreenOffset = 22;
        }
        this.addBackpackStorageSlots(this.wrapper);
        this.BACKPACK_INV_END = this.f_38839_.size();
        this.TOOL_START = this.f_38839_.size();
        this.addBackpackToolSlots(this.wrapper);
        this.TOOL_END = this.f_38839_.size();
        this.UPGRADE_START = this.f_38839_.size();
        this.addBackpackUpgradeSlots(this.wrapper);
        this.UPGRADE_END = this.f_38839_.size();
        this.PLAYER_INV_START = this.f_38839_.size();
        this.addPlayerInventoryAndHotbar(this.inventory, this.wrapper.getBackpackSlotIndex());
        this.PLAYER_HOT_END = this.f_38839_.size();
        this.unmodifiableSlotCount = this.f_38839_.size();
        this.addUpgradeListeners();
        this.addUpgradeSlots(this.wrapper);
    }

    public void addModifiableSlots() {
        if (this.wrapper.tanksVisible()) {
            this.extendedScreenOffset = 22;
        }
        this.updateSlotsPosition();
        this.updateBackpackUpgradeSlots();
        this.addUpgradeListeners();
        this.addUpgradeSlots(this.wrapper);
    }

    public void updateModifiableSlots() {
        this.extendedScreenOffset = 0;
        if (this.f_38841_.size() > this.unmodifiableSlotCount) {
            this.f_38841_.subList(this.unmodifiableSlotCount, this.f_38841_.size()).clear();
        }
        if (this.f_38839_.size() > this.unmodifiableSlotCount) {
            this.f_38839_.subList(this.unmodifiableSlotCount, this.f_38839_.size()).clear();
        }
        if (this.f_150394_.size() > this.unmodifiableSlotCount) {
            this.f_150394_.subList(this.unmodifiableSlotCount, this.f_150394_.size()).clear();
        }
        this.addModifiableSlots();
        this.wrapper.getUpgradeManager().getUpgrade(CraftingUpgrade.class).ifPresent(craftingUpgrade -> this.canCraft(this.inventory.f_35978_.m_9236_(), this.inventory.f_35978_));
    }

    public void updateSlotsPosition() {
        int i;
        int slot = 0;
        for (int i2 = this.BACKPACK_INV_START; i2 < this.BACKPACK_INV_END; ++i2) {
            if (!((Slot)this.f_38839_.get(i2)).getClass().equals(BackpackSlotItemHandler.class)) continue;
            ((Slot)this.f_38839_.get((int)i2)).f_40220_ = this.extendedScreenOffset + 8 + slot * 18;
            if (slot < this.wrapper.getSlotsInRow() - 1) {
                ++slot;
                continue;
            }
            slot = 0;
        }
        int modifiedOffset = this.extendedScreenOffset * 2;
        if (this.wrapper.isExtended()) {
            modifiedOffset += 36;
        }
        for (i = this.UPGRADE_START; i < this.UPGRADE_END; ++i) {
            if (!((Slot)this.f_38839_.get(i)).getClass().equals(UpgradeLockableSlotItemHandler.class)) continue;
            ((Slot)this.f_38839_.get((int)i)).f_40220_ = 162 + modifiedOffset + 15;
        }
        modifiedOffset = this.extendedScreenOffset;
        if (this.wrapper.isExtended()) {
            modifiedOffset += 18;
        }
        slot = 0;
        for (i = this.PLAYER_INV_START; i < this.PLAYER_HOT_END; ++i) {
            if (!(((Slot)this.f_38839_.get((int)i)).f_40218_ instanceof Inventory)) continue;
            ((Slot)this.f_38839_.get((int)i)).f_40220_ = modifiedOffset + 8 + slot * 18;
            if (slot < 8) {
                ++slot;
                continue;
            }
            slot = 0;
        }
    }

    public void updateSlots() {
        this.extendedScreenOffset = 0;
        this.f_38841_.clear();
        this.f_38839_.clear();
        this.f_150394_.clear();
        this.addSlots();
    }

    public void addUpgradeListeners() {
        for (Optional upgrade : this.wrapper.getUpgradeManager().mappedUpgrades.values()) {
            upgrade.ifPresent(iUpgrade -> iUpgrade.initializeContainers(this, this.wrapper));
        }
    }

    public void updateBackpackUpgradeSlots() {
        AtomicInteger nextSlot = new AtomicInteger();
        boolean tabOpened = false;
        int lastOccupiedSlot = -1;
        for (int i = this.wrapper.getUpgrades().getSlots() - 1; i >= 0; --i) {
            if (this.wrapper.getUpgrades().getStackInSlot(i).m_41619_()) continue;
            if (i != 0 && lastOccupiedSlot == -1) {
                lastOccupiedSlot = i;
            }
            if (tabOpened || !this.wrapper.getUpgradeManager().hasUpgradeInSlot(i)) continue;
            tabOpened = NbtHelper.getOrDefault(this.wrapper.getUpgrades().getStackInSlot(i), "TabOpen", false);
        }
        boolean finalTabOpened = tabOpened;
        int finalLastOccupiedSlot = lastOccupiedSlot;
        this.f_38839_.stream().filter(slot -> slot instanceof UpgradeLockableSlotItemHandler).forEach(slot -> {
            UpgradeLockableSlotItemHandler upgradeSlot = (UpgradeLockableSlotItemHandler)((Object)slot);
            upgradeSlot.setHidden(false);
            int j = slot.m_150661_();
            if (j > 0) {
                Optional upgrade = (Optional)this.wrapper.getUpgradeManager().mappedUpgrades.get((Object)(j - 1));
                if (upgrade != null && upgrade.isPresent()) {
                    nextSlot.addAndGet(((IUpgrade)upgrade.get()).getTabSize().y() + 1);
                } else {
                    nextSlot.addAndGet(25);
                }
            }
            upgradeSlot.f_40221_ = 33 + nextSlot.get();
            if (finalTabOpened && upgradeSlot.m_150661_() > finalLastOccupiedSlot) {
                upgradeSlot.setHidden(true);
            }
            upgradeSlot.setLocked(upgradeSlot.m_7993_().m_41720_() instanceof UpgradeItem);
        });
    }

    public void addBackpackUpgradeSlots(BackpackWrapper wrapper) {
        int i;
        this.upgradeSlot.clear();
        int modifiedOffset = this.extendedScreenOffset * 2;
        if (wrapper.isExtended()) {
            modifiedOffset += 36;
        }
        int nextSlot = 0;
        boolean tabOpened = false;
        int lastOccupiedSlot = -1;
        for (i = wrapper.getUpgrades().getSlots() - 1; i >= 0; --i) {
            if (wrapper.getUpgrades().getStackInSlot(i).m_41619_()) continue;
            if (i != 0 && lastOccupiedSlot == -1) {
                lastOccupiedSlot = i;
            }
            if (tabOpened || !wrapper.getUpgradeManager().hasUpgradeInSlot(i)) continue;
            tabOpened = NbtHelper.getOrDefault(wrapper.getUpgrades().getStackInSlot(i), "TabOpen", false);
        }
        for (i = 0; i < wrapper.getUpgrades().getSlots(); ++i) {
            if (i > 0) {
                Optional upgrade = (Optional)wrapper.getUpgradeManager().mappedUpgrades.get((Object)(i - 1));
                nextSlot = upgrade != null && upgrade.isPresent() ? (nextSlot += ((IUpgrade)upgrade.get()).getTabSize().y() + 1) : (nextSlot += 25);
            }
            UpgradeLockableSlotItemHandler slot = new UpgradeLockableSlotItemHandler(this, (IItemHandler)wrapper.getUpgrades(), i, 162 + modifiedOffset + 15, 33 + nextSlot);
            if (tabOpened && slot.m_150661_() > lastOccupiedSlot) {
                slot.setHidden(true);
            }
            this.m_38897_((Slot)slot);
        }
    }

    protected Slot m_38897_(Slot slot) {
        if (slot instanceof UpgradeLockableSlotItemHandler) {
            UpgradeLockableSlotItemHandler upgradeSlotItemHandler = (UpgradeLockableSlotItemHandler)slot;
            this.upgradeSlot.add(upgradeSlotItemHandler);
        }
        return super.m_38897_(slot);
    }

    public void addBackpackToolSlots(BackpackWrapper wrapper) {
        for (int i = 0; i < wrapper.getTools().getSlots(); ++i) {
            this.m_38897_((Slot)new ToolSlotItemHandler(wrapper, i, -14, 18 + i * 18));
        }
    }

    public void addPlayerInventoryAndHotbar(Inventory inventory, int currentItemIndex) {
        int modifiedOffset = this.extendedScreenOffset;
        if (this.wrapper.isExtended()) {
            modifiedOffset += 18;
        }
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.m_38897_(new Slot((Container)inventory, x + y * 9 + 9, modifiedOffset + 8 + x * 18, this.wrapper.getRows() * 18 + 7 + 25 + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.m_38897_(new Slot((Container)inventory, x, modifiedOffset + 8 + x * 18, this.wrapper.getRows() * 18 + 7 + 83));
        }
    }

    public void addUpgradeSlots(BackpackWrapper wrapper) {
        for (Optional upgrade : wrapper.getUpgradeManager().mappedUpgrades.values()) {
            upgrade.ifPresent(upgradeLoaded -> {
                int x = this.upgradeSlot.get((int)((Integer)wrapper.getUpgradeManager().mappedUpgrades.inverse().get((Object)upgrade)).intValue()).f_40220_ - 4;
                int y = this.upgradeSlot.get((int)((Integer)wrapper.getUpgradeManager().mappedUpgrades.inverse().get((Object)upgrade)).intValue()).f_40221_ - 4;
                if (upgradeLoaded.isTabOpened()) {
                    for (Slot slot : upgradeLoaded.getUpgradeSlots(this, wrapper, x, y)) {
                        this.m_38897_(slot);
                    }
                }
                if (upgradeLoaded instanceof CraftingUpgrade) {
                    this.m_38946_();
                }
            });
        }
    }

    protected void m_150430_(int pSlotId, int pButton, ClickType pClickType, Player pPlayer) {
        Object object;
        if (pSlotId >= 0 && pSlotId < this.f_38839_.size() && (object = this.f_38839_.get(pSlotId)) instanceof TrashSlot) {
            TrashSlot trashSlot = (TrashSlot)((Object)object);
            if (!this.m_142621_().m_41619_() && trashSlot.m_6657_() && pClickType == ClickType.PICKUP) {
                trashSlot.m_5852_(ItemStack.f_41583_.m_41777_());
            }
        }
        if (pSlotId >= 0 && pSlotId < this.f_38839_.size() && (object = this.f_38839_.get(pSlotId)) instanceof FilterSlotItemHandler) {
            FilterSlotItemHandler filterSlot = (FilterSlotItemHandler)((Object)object);
            if (this.m_142621_().m_41619_() && pClickType == ClickType.PICKUP && pButton == 0) {
                super.m_150430_(pSlotId, pButton, pClickType, pPlayer);
            } else if (!this.m_142621_().m_41619_() && filterSlot.m_5857_(this.m_142621_()) && !filterSlot.m_6657_()) {
                filterSlot.m_5852_(this.m_142621_().m_255036_(1));
            }
        } else {
            super.m_150430_(pSlotId, pButton, pClickType, pPlayer);
        }
    }

    protected void canCraft(Level level, Player player) {
        this.wrapper.getUpgradeManager().getUpgrade(CraftingUpgrade.class).ifPresent(craftingUpgrade -> this.slotChangedCraftingGrid((CraftingUpgrade)craftingUpgrade, level, player));
    }

    public void m_6199_(Container container) {
        super.m_6199_(container);
        this.canCraft(this.inventory.f_35978_.m_9236_(), this.inventory.f_35978_);
    }

    public void m_150429_() {
        super.m_150429_();
        this.canCraft(this.inventory.f_35978_.m_9236_(), this.inventory.f_35978_);
    }

    public boolean m_5882_(ItemStack stack, Slot slot) {
        if (this.wrapper.getUpgradeManager().getUpgrade(CraftingUpgrade.class).isPresent()) {
            return slot.f_40218_ != this.wrapper.getUpgradeManager().getUpgrade(CraftingUpgrade.class).get().resultSlots;
        }
        if (slot instanceof FilterSlotItemHandler) {
            return false;
        }
        return super.m_5882_(stack, slot);
    }

    public ItemStack m_7648_(Player player, int index) {
        Slot slot = this.m_38853_(index);
        ItemStack result = ItemStack.f_41583_;
        if (slot != null && slot.m_6657_()) {
            UpgradeSlotItemHandler upgradeSlotItemHandler;
            ItemStack stack = slot.m_7993_();
            result = stack.m_41777_();
            if (slot instanceof ResultSlotExt) {
                ResultSlotExt resultSlotExtNew = (ResultSlotExt)slot;
                return this.handleShiftCraft(this.wrapper.getUpgradeManager().getUpgrade(CraftingUpgrade.class).get(), player, resultSlotExtNew);
            }
            if (slot instanceof CraftingSlot && !this.m_38903_(stack, this.BACKPACK_INV_START, this.PLAYER_HOT_END, false)) {
                return ItemStack.f_41583_;
            }
            if (index >= this.BACKPACK_INV_START && index < this.BACKPACK_INV_END && !this.m_38903_(stack, this.PLAYER_INV_START, this.PLAYER_HOT_END, true)) {
                return ItemStack.f_41583_;
            }
            if (index >= this.PLAYER_INV_START && index < this.PLAYER_HOT_END) {
                if (this.wrapper.showToolSlots() && ToolSlotItemHandler.isValid(stack) && !this.m_38903_(stack, this.TOOL_START, this.TOOL_END, false) && !this.m_38903_(stack, this.BACKPACK_INV_START, this.BACKPACK_INV_END, false)) {
                    return ItemStack.f_41583_;
                }
                if (!this.checkMemorySlots(stack) && !this.m_38903_(stack, this.BACKPACK_INV_START, this.BACKPACK_INV_END, false)) {
                    return ItemStack.f_41583_;
                }
            }
            if (slot instanceof UpgradeSlotItemHandler && ((upgradeSlotItemHandler = (UpgradeSlotItemHandler)slot).shiftClickToBackpack() ? !this.m_38903_(stack, this.BACKPACK_INV_START, this.BACKPACK_INV_END, false) && !this.m_38903_(stack, this.PLAYER_INV_START, this.PLAYER_HOT_END, true) : !this.m_38903_(stack, this.PLAYER_INV_START, this.PLAYER_HOT_END, true) && !this.m_38903_(stack, this.BACKPACK_INV_START, this.BACKPACK_INV_END, false))) {
                return ItemStack.f_41583_;
            }
            if (slot instanceof ToolSlotItemHandler && !this.m_38903_(stack, this.PLAYER_INV_START, this.PLAYER_HOT_END, true)) {
                return ItemStack.f_41583_;
            }
            if (stack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_5852_(stack);
            }
            if (stack.m_41613_() == result.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, stack);
        }
        return result;
    }

    public boolean checkMemorySlots(ItemStack stack) {
        if (!this.wrapper.getMemorySlots().isEmpty()) {
            for (Pair<Integer, Pair<ItemStack, Boolean>> memorizedStack : this.wrapper.getMemorySlots()) {
                if (stack.m_41720_() != ((ItemStack)((Pair)memorizedStack.getSecond()).getFirst()).m_41720_() || !((Boolean)((Pair)memorizedStack.getSecond()).getSecond() != false ? ItemStackUtils.isSameItemSameComponents((ItemStack)((Pair)memorizedStack.getSecond()).getFirst(), stack) && this.m_38903_(stack, (Integer)memorizedStack.getFirst(), (Integer)memorizedStack.getFirst() + 1, false) : ItemStack.m_41656_((ItemStack)((ItemStack)((Pair)memorizedStack.getSecond()).getFirst()), (ItemStack)stack) && this.m_38903_(stack, (Integer)memorizedStack.getFirst(), (Integer)memorizedStack.getFirst() + 1, false))) continue;
                return stack.m_41619_();
            }
        }
        return false;
    }

    protected boolean m_38903_(ItemStack stack, int startIndex, int endIndex, boolean reverseDirection) {
        boolean applyRespectedSlotLogic = startIndex == this.BACKPACK_INV_START && endIndex == this.BACKPACK_INV_END;
        boolean flag = false;
        int i = startIndex;
        if (reverseDirection) {
            i = endIndex - 1;
        }
        if (stack.m_41753_()) {
            while (!stack.m_41619_() && (reverseDirection ? i >= startIndex : i < endIndex)) {
                Slot slot = (Slot)this.f_38839_.get(i);
                ItemStack itemstack = slot.m_7993_();
                if (!itemstack.m_41619_() && ItemStack.m_150942_((ItemStack)stack, (ItemStack)itemstack)) {
                    int k;
                    int j = itemstack.m_41613_() + stack.m_41613_();
                    if (j <= (k = slot.m_5866_(itemstack))) {
                        stack.m_41764_(0);
                        itemstack.m_41764_(j);
                        slot.m_5852_(itemstack);
                        flag = true;
                    } else if (itemstack.m_41613_() < k) {
                        stack.m_41774_(k - itemstack.m_41613_());
                        itemstack.m_41764_(k);
                        slot.m_5852_(itemstack);
                        flag = true;
                    }
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        if (!stack.m_41619_()) {
            i = reverseDirection ? endIndex - 1 : startIndex;
            while (reverseDirection ? i >= startIndex : i < endIndex) {
                ItemStack itemstack1;
                Slot slot1 = (Slot)this.f_38839_.get(i);
                boolean accept = true;
                Optional<Pair<Integer, Pair<ItemStack, Boolean>>> memorizedOptional = this.getWrapper().getMemorizedSlot(slot1.getSlotIndex());
                boolean isUnsortable = this.getWrapper().getUnsortableSlots().contains(slot1.getSlotIndex());
                if (memorizedOptional.isPresent()) {
                    ItemStack memorizedStack = (ItemStack)((Pair)memorizedOptional.get().getSecond()).getFirst();
                    boolean matchComponents = (Boolean)((Pair)memorizedOptional.get().getSecond()).getSecond();
                    if (applyRespectedSlotLogic) {
                        boolean bl = accept = matchComponents ? ItemStackUtils.isSameItemSameComponents(memorizedStack, stack) : ItemStack.m_41656_((ItemStack)memorizedStack, (ItemStack)stack);
                    }
                }
                if (isUnsortable && !memorizedOptional.isPresent() && accept && applyRespectedSlotLogic) {
                    accept = false;
                }
                if ((itemstack1 = slot1.m_7993_()).m_41619_() && slot1.m_5857_(stack) && accept) {
                    int l = slot1.m_5866_(stack);
                    slot1.m_269060_(stack.m_41620_(Math.min(stack.m_41613_(), l)));
                    slot1.m_6654_();
                    flag = true;
                    break;
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return flag;
    }

    public ItemStack handleShiftCraft(CraftingUpgrade upgrade, Player player, ResultSlotExt resultSlot) {
        ItemStack outputCopy = ItemStack.f_41583_;
        if (resultSlot != null && resultSlot.m_6657_()) {
            upgrade.craftSlots.checkChanges = false;
            Recipe recipe = upgrade.resultSlots.m_7928_();
            while (recipe != null && recipe.m_5818_((Container)upgrade.craftSlots, player.m_9236_())) {
                ItemStack recipeOutput = recipe.m_5874_((Container)upgrade.craftSlots, player.m_9236_().m_9598_());
                if (recipeOutput.m_41619_()) {
                    throw new RuntimeException("A recipe matched but produced an empty output - Offending Recipe : " + String.valueOf(recipe) + " - This is NOT a bug in Traveler's Backpack!");
                }
                outputCopy = recipeOutput.m_41777_();
                recipeOutput.m_41678_(player.m_9236_(), player, 1);
                ForgeEventFactory.firePlayerCraftingEvent((Player)player, (ItemStack)recipeOutput, (Container)upgrade.craftSlots);
                if (!player.m_9236_().f_46443_) {
                    if (upgrade.shiftClickToBackpack(upgrade.getDataHolderStack())) {
                        if (!this.checkMemorySlots(recipeOutput) && !this.m_38903_(recipeOutput, this.BACKPACK_INV_START, this.BACKPACK_INV_END, false)) {
                            upgrade.craftSlots.checkChanges = true;
                            return ItemStack.f_41583_;
                        }
                    } else if (!this.m_38903_(recipeOutput, this.PLAYER_INV_START, this.PLAYER_HOT_END, true) && !this.m_38903_(recipeOutput, this.BACKPACK_INV_START, this.BACKPACK_INV_END, false)) {
                        upgrade.craftSlots.checkChanges = true;
                        return ItemStack.f_41583_;
                    }
                }
                resultSlot.f_40164_ += outputCopy.m_41613_();
                resultSlot.m_142406_(player, recipeOutput);
            }
            upgrade.craftSlots.checkChanges = true;
            this.slotChangedCraftingGrid(upgrade, player.m_9236_(), player);
        }
        return outputCopy;
    }

    public void slotChangedCraftingGrid(CraftingUpgrade upgrade, Level world, Player player) {
        if (!world.f_46443_ && upgrade.craftSlots.checkChanges) {
            Recipe oldRecipe;
            ItemStack itemstack = ItemStack.f_41583_;
            Recipe recipe = oldRecipe = upgrade.resultSlots.m_7928_();
            if (TravelersBackpack.polymorphLoaded && PolymorphCompat.shouldResetRecipe((Recipe<CraftingContainer>)recipe, this, upgrade.craftSlots, world, player)) {
                recipe = null;
            }
            if (recipe == null || !recipe.m_5818_((Container)upgrade.craftSlots, world)) {
                recipe = TravelersBackpack.polymorphLoaded ? PolymorphCompat.getPolymorphedRecipe(this, upgrade.craftSlots, world, player) : (Recipe)world.m_7465_().m_44015_(RecipeType.f_44107_, (Container)upgrade.craftSlots, world).orElse(null);
            }
            if (recipe != null) {
                itemstack = recipe.m_5874_((Container)upgrade.craftSlots, world.m_9598_());
            }
            if (oldRecipe != recipe || upgrade.resultSlots.m_8020_(0).m_41619_()) {
                for (Player user : this.getWrapper().getPlayersUsing().stream().filter(p -> p instanceof ServerPlayer).toList()) {
                    PacketDistributorHelper.sendToPlayer((ServerPlayer)user, new ClientboundUpdateRecipePacket(recipe, itemstack));
                }
                upgrade.resultSlots.m_6836_(0, itemstack);
                upgrade.resultSlots.m_6029_(recipe);
            } else if (recipe != null && (recipe.m_5598_() || !recipe.getClass().getName().startsWith("net.minecraft") && !ItemStack.m_41728_((ItemStack)itemstack, (ItemStack)upgrade.resultSlots.m_8020_(0)))) {
                for (Player user : this.getWrapper().getPlayersUsing().stream().filter(p -> p instanceof ServerPlayer).toList()) {
                    PacketDistributorHelper.sendToPlayer((ServerPlayer)user, new ClientboundUpdateRecipePacket(recipe, itemstack));
                }
                upgrade.resultSlots.m_6836_(0, itemstack);
                upgrade.resultSlots.m_6029_(recipe);
            }
        }
    }

    public void m_6877_(Player player) {
        this.wrapper.getUpgradeManager().getUpgrade(CraftingUpgrade.class).ifPresent(craftingUpgrade -> this.checkHandlerAndPlaySound(craftingUpgrade.crafting, player, craftingUpgrade.crafting.getSlots()));
        this.wrapper.getUpgradeManager().getUpgrade(TanksUpgrade.class).ifPresent(tanksUpgrade -> this.clearSlotsAndPlaySound(this.inventory.f_35978_, tanksUpgrade.getFluidSlotsHandler(), 4));
        this.wrapper.getUpgradeManager().getUpgrade(VoidUpgrade.class).ifPresent(this::voidTrashSlot);
        this.shiftTools(this.wrapper.getTools());
        super.m_6877_(player);
    }

    public void clearSlotsAndPlaySound(Player player, ItemStackHandler handler, int size) {
        boolean playSound = false;
        for (int i = 0; i < size; ++i) {
            boolean flag = this.clearSlot(player, handler, i);
            if (!flag) continue;
            playSound = true;
        }
        if (playSound) {
            this.playSound(player);
        }
    }

    public boolean clearSlot(Player player, ItemStackHandler handler, int index) {
        if (!handler.getStackInSlot(index).m_41619_()) {
            ServerPlayer serverPlayer;
            if (player == null) {
                return false;
            }
            if (!player.m_6084_() || player instanceof ServerPlayer && (serverPlayer = (ServerPlayer)player).m_9232_()) {
                ItemStack stack = handler.getStackInSlot(index).m_41777_();
                handler.setStackInSlot(index, ItemStack.f_41583_);
                player.m_36176_(stack, false);
                return false;
            }
            ItemStack stack = handler.getStackInSlot(index);
            handler.setStackInSlot(index, ItemStack.f_41583_);
            player.m_150109_().m_150079_(stack);
            return true;
        }
        return false;
    }

    public void playSound(Player player) {
        player.m_9236_().m_5594_(player, player.m_20183_(), SoundEvents.f_12019_, SoundSource.BLOCKS, 1.0f, (1.0f + (player.m_9236_().m_213780_().m_188501_() - player.m_9236_().m_213780_().m_188501_()) * 0.2f) * 0.7f);
    }

    public void shiftTools(ItemStackHandler toolSlotsHandler) {
        boolean foundEmptySlot = false;
        boolean needsShifting = false;
        for (int i = 0; i < toolSlotsHandler.getSlots(); ++i) {
            if (foundEmptySlot && !toolSlotsHandler.getStackInSlot(i).m_41619_()) {
                needsShifting = true;
            }
            if (!toolSlotsHandler.getStackInSlot(i).m_41619_() || foundEmptySlot) continue;
            foundEmptySlot = true;
        }
        if (needsShifting) {
            int i;
            NonNullList tools = NonNullList.m_122780_((int)toolSlotsHandler.getSlots(), (Object)ItemStack.f_41583_);
            int j = 0;
            for (i = 0; i < toolSlotsHandler.getSlots(); ++i) {
                if (toolSlotsHandler.getStackInSlot(i).m_41619_()) continue;
                tools.set(j, (Object)toolSlotsHandler.getStackInSlot(i));
                ++j;
            }
            j = 0;
            for (i = 0; i < toolSlotsHandler.getSlots(); ++i) {
                if (tools.isEmpty()) continue;
                toolSlotsHandler.setStackInSlot(i, (ItemStack)tools.get(j));
                ++j;
            }
        }
    }

    public void voidTrashSlot(VoidUpgrade upgrade) {
        upgrade.filter.setStackInSlot(0, ItemStack.f_41583_.m_41777_());
    }

    public void checkHandlerAndPlaySound(ItemStackHandler handler, Player player, int size) {
        boolean playSound = false;
        for (int i = 0; i < size; ++i) {
            boolean flag = this.clearSlot(handler, player, i);
            if (!flag) continue;
            playSound = true;
        }
        if (playSound) {
            this.playSound(player);
        }
    }

    public boolean clearSlot(ItemStackHandler handler, Player player, int index) {
        if (!BackpackSlotItemHandler.isItemValid(handler.getStackInSlot(index))) {
            ServerPlayer serverPlayer;
            if (player == null) {
                return false;
            }
            if (!player.m_6084_() || player instanceof ServerPlayer && (serverPlayer = (ServerPlayer)player).m_9232_()) {
                ItemStack stack = handler.getStackInSlot(index).m_41777_();
                handler.setStackInSlot(index, ItemStack.f_41583_);
                player.m_36176_(stack, false);
                return false;
            }
            ItemStack stack = handler.getStackInSlot(index);
            handler.setStackInSlot(index, ItemStack.f_41583_);
            player.m_150109_().m_150079_(stack);
            return true;
        }
        return false;
    }

    public boolean m_6875_(Player player) {
        return true;
    }
}

