/*
 * Decompiled with CFR 0.152.
 */
package com.sparkuniverse.toolbox.util;

import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Validate {
    private static final Supplier<String> DEFAULT_NULL_MESSAGE = () -> "Object cannot be null.";
    private static final Supplier<String> DEFAULT_IS_TRUE_MESSAGE = () -> "Object cannot be false.";

    public static <T> T notNull(@Nullable T object) {
        return Validate.notNull(object, DEFAULT_NULL_MESSAGE, new Object[0]);
    }

    public static <T> T notNull(@Nullable T object, @NotNull Supplier<String> message2, Object ... values) {
        if (object == null) {
            throw new NullPointerException(String.format(message2.get(), values));
        }
        return object;
    }

    public static void isTrue(boolean expression) {
        Validate.isTrue(expression, DEFAULT_IS_TRUE_MESSAGE, new Object[0]);
    }

    public static void isTrue(boolean expression, @NotNull Supplier<String> message2, Object ... values) {
        if (!expression) {
            throw new IllegalArgumentException(String.format(message2.get(), values));
        }
    }
}

