/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.elementa.impl.commonmark.internal;

import gg.essential.elementa.impl.commonmark.internal.util.Parsing;
import gg.essential.elementa.impl.commonmark.node.Block;
import gg.essential.elementa.impl.commonmark.node.IndentedCodeBlock;
import gg.essential.elementa.impl.commonmark.node.Paragraph;
import gg.essential.elementa.impl.commonmark.parser.SourceLine;
import gg.essential.elementa.impl.commonmark.parser.block.AbstractBlockParser;
import gg.essential.elementa.impl.commonmark.parser.block.AbstractBlockParserFactory;
import gg.essential.elementa.impl.commonmark.parser.block.BlockContinue;
import gg.essential.elementa.impl.commonmark.parser.block.BlockStart;
import gg.essential.elementa.impl.commonmark.parser.block.MatchedBlockParser;
import gg.essential.elementa.impl.commonmark.parser.block.ParserState;
import java.util.ArrayList;
import java.util.List;

public class IndentedCodeBlockParser
extends AbstractBlockParser {
    private final IndentedCodeBlock block = new IndentedCodeBlock();
    private final List<CharSequence> lines = new ArrayList<CharSequence>();

    @Override
    public Block getBlock() {
        return this.block;
    }

    @Override
    public BlockContinue tryContinue(ParserState state2) {
        if (state2.getIndent() >= Parsing.CODE_BLOCK_INDENT) {
            return BlockContinue.atColumn(state2.getColumn() + Parsing.CODE_BLOCK_INDENT);
        }
        if (state2.isBlank()) {
            return BlockContinue.atIndex(state2.getNextNonSpaceIndex());
        }
        return BlockContinue.none();
    }

    @Override
    public void addLine(SourceLine line) {
        this.lines.add(line.getContent());
    }

    @Override
    public void closeBlock() {
        int lastNonBlank;
        for (lastNonBlank = this.lines.size() - 1; lastNonBlank >= 0 && Parsing.isBlank(this.lines.get(lastNonBlank)); --lastNonBlank) {
        }
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < lastNonBlank + 1; ++i2) {
            sb.append(this.lines.get(i2));
            sb.append('\n');
        }
        String literal = sb.toString();
        this.block.setLiteral(literal);
    }

    public static class Factory
    extends AbstractBlockParserFactory {
        @Override
        public BlockStart tryStart(ParserState state2, MatchedBlockParser matchedBlockParser) {
            if (state2.getIndent() >= Parsing.CODE_BLOCK_INDENT && !state2.isBlank() && !(state2.getActiveBlockParser().getBlock() instanceof Paragraph)) {
                return BlockStart.of(new IndentedCodeBlockParser()).atColumn(state2.getColumn() + Parsing.CODE_BLOCK_INDENT);
            }
            return BlockStart.none();
        }
    }
}

