/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.gui.common.input;

import gg.essential.elementa.UIComponent;
import gg.essential.elementa.constraints.WidthConstraint;
import gg.essential.elementa.dsl.BasicConstraintsKt;
import gg.essential.elementa.dsl.ConstraintsKt;
import gg.essential.elementa.dsl.UtilitiesKt;
import gg.essential.gui.EssentialPalette;
import gg.essential.gui.common.input.AbstractTextInput;
import gg.essential.universal.UMatrixStack;
import java.awt.Color;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001Bm\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\u0007\u0012\b\b\u0002\u0010\n\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\f\u001a\u00020\u0007\u0012\b\b\u0002\u0010\r\u001a\u00020\u0007\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020\u0003H\u0016J\b\u0010#\u001a\u00020\u0003H\u0014J\b\u0010$\u001a\u00020\u001fH\u0014J\b\u0010%\u001a\u00020\u001fH\u0014J\u001c\u0010&\u001a\u00060'R\u00020\u00012\u0006\u0010(\u001a\u00020\u001b2\u0006\u0010)\u001a\u00020\u001bH\u0014J\u0014\u0010*\u001a\u00020\u001f2\n\u0010+\u001a\u00060'R\u00020\u0001H\u0014J\b\u0010,\u001a\u00020\u001fH\u0014J\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010-\u001a\u00020\u0012J\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010-\u001a\u00020\u0012J\u001e\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00030/2\u0006\u00100\u001a\u00020\u00032\u0006\u00101\u001a\u00020\u001bH\u0014J\u0016\u00102\u001a\b\u0012\u0004\u0012\u00020\u00030/2\u0006\u00100\u001a\u00020\u0003H\u0014R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u0012X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0014\"\u0004\b\u0019\u0010\u0016R\u0014\u0010\u001a\u001a\u00020\u001bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u00063"}, d2={"Lgg/essential/gui/common/input/UITextInput;", "Lgg/essential/gui/common/input/AbstractTextInput;", "placeholder", "", "shadow", "", "shadowColor", "Ljava/awt/Color;", "selectionBackgroundColor", "selectionForegroundColor", "allowInactiveSelection", "inactiveSelectionBackgroundColor", "inactiveSelectionForegroundColor", "cursorColor", "maxLength", "", "(Ljava/lang/String;ZLjava/awt/Color;Ljava/awt/Color;Ljava/awt/Color;ZLjava/awt/Color;Ljava/awt/Color;Ljava/awt/Color;I)V", "maxWidth", "Lgg/essential/elementa/constraints/WidthConstraint;", "getMaxWidth", "()Lgg/essential/elementa/constraints/WidthConstraint;", "setMaxWidth", "(Lgg/essential/elementa/constraints/WidthConstraint;)V", "minWidth", "getMinWidth", "setMinWidth", "placeholderWidth", "", "getPlaceholderWidth", "()F", "draw", "", "matrixStack", "Lgg/essential/universal/UMatrixStack;", "getText", "getTextForRender", "onEnterPressed", "recalculateDimensions", "screenPosToVisualPos", "Lgg/essential/gui/common/input/AbstractTextInput$LinePosition;", "x", "y", "scrollIntoView", "pos", "setCursorPos", "constraint", "splitTextForWrapping", "", "text", "maxLineWidth", "textToLines", "essential-gui-essential"})
public class UITextInput
extends AbstractTextInput {
    @Nullable
    private WidthConstraint minWidth;
    @Nullable
    private WidthConstraint maxWidth;
    private final float placeholderWidth;

    @JvmOverloads
    public UITextInput(@NotNull String placeholder, boolean shadow2, @Nullable Color shadowColor2, @NotNull Color selectionBackgroundColor, @NotNull Color selectionForegroundColor, boolean allowInactiveSelection, @NotNull Color inactiveSelectionBackgroundColor, @NotNull Color inactiveSelectionForegroundColor, @NotNull Color cursorColor, int maxLength) {
        Intrinsics.checkNotNullParameter((Object)placeholder, (String)"placeholder");
        Intrinsics.checkNotNullParameter((Object)selectionBackgroundColor, (String)"selectionBackgroundColor");
        Intrinsics.checkNotNullParameter((Object)selectionForegroundColor, (String)"selectionForegroundColor");
        Intrinsics.checkNotNullParameter((Object)inactiveSelectionBackgroundColor, (String)"inactiveSelectionBackgroundColor");
        Intrinsics.checkNotNullParameter((Object)inactiveSelectionForegroundColor, (String)"inactiveSelectionForegroundColor");
        Intrinsics.checkNotNullParameter((Object)cursorColor, (String)"cursorColor");
        super(placeholder, shadow2, shadowColor2, selectionBackgroundColor, selectionForegroundColor, allowInactiveSelection, inactiveSelectionBackgroundColor, inactiveSelectionForegroundColor, cursorColor, maxLength);
        this.placeholderWidth = UtilitiesKt.width$default(placeholder, 0.0f, null, 3, null);
    }

    public /* synthetic */ UITextInput(String string, boolean bl, Color color2, Color color3, Color color4, boolean bl2, Color color5, Color color6, Color color7, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            string = "";
        }
        if ((n2 & 2) != 0) {
            bl = true;
        }
        if ((n2 & 4) != 0) {
            color2 = null;
        }
        if ((n2 & 8) != 0) {
            color3 = EssentialPalette.TEXT_HIGHLIGHT_BACKGROUND;
        }
        if ((n2 & 0x10) != 0) {
            color4 = EssentialPalette.TEXT_HIGHLIGHT;
        }
        if ((n2 & 0x20) != 0) {
            bl2 = false;
        }
        if ((n2 & 0x40) != 0) {
            color5 = new Color(176, 176, 176);
        }
        if ((n2 & 0x80) != 0) {
            Color color8 = Color.WHITE;
            Intrinsics.checkNotNullExpressionValue((Object)color8, (String)"WHITE");
            color6 = color8;
        }
        if ((n2 & 0x100) != 0) {
            color7 = EssentialPalette.TEXT_HIGHLIGHT;
        }
        if ((n2 & 0x200) != 0) {
            n = Integer.MAX_VALUE;
        }
        this(string, bl, color2, color3, color4, bl2, color5, color6, color7, n);
    }

    @Nullable
    protected final WidthConstraint getMinWidth() {
        return this.minWidth;
    }

    protected final void setMinWidth(@Nullable WidthConstraint widthConstraint) {
        this.minWidth = widthConstraint;
    }

    @Nullable
    protected final WidthConstraint getMaxWidth() {
        return this.maxWidth;
    }

    protected final void setMaxWidth(@Nullable WidthConstraint widthConstraint) {
        this.maxWidth = widthConstraint;
    }

    protected final float getPlaceholderWidth() {
        return this.placeholderWidth;
    }

    @NotNull
    public final UITextInput setMinWidth(@NotNull WidthConstraint constraint) {
        UITextInput uITextInput;
        Intrinsics.checkNotNullParameter((Object)constraint, (String)"constraint");
        UITextInput $this$setMinWidth_u24lambda_u240 = uITextInput = this;
        boolean bl = false;
        $this$setMinWidth_u24lambda_u240.minWidth = constraint;
        return uITextInput;
    }

    @NotNull
    public final UITextInput setMaxWidth(@NotNull WidthConstraint constraint) {
        UITextInput uITextInput;
        Intrinsics.checkNotNullParameter((Object)constraint, (String)"constraint");
        UITextInput $this$setMaxWidth_u24lambda_u241 = uITextInput = this;
        boolean bl = false;
        $this$setMaxWidth_u24lambda_u241.maxWidth = constraint;
        return uITextInput;
    }

    @Override
    @NotNull
    public String getText() {
        return ((AbstractTextInput.TextualLine)CollectionsKt.first(this.getTextualLines())).getText();
    }

    @NotNull
    protected String getTextForRender() {
        return this.getText();
    }

    protected void setCursorPos() {
        UIComponent.unhide$default(this.getCursorComponent(), false, 1, null);
        float cursorPosX = ((Number)this.getCursor().toScreenPos().component1()).floatValue();
        this.getCursorComponent().setX(UtilitiesKt.pixels$default(Float.valueOf(cursorPosX), false, false, 3, null));
    }

    @Override
    @NotNull
    protected List<String> textToLines(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        return CollectionsKt.listOf((Object)StringsKt.replace$default((String)text2, (char)'\n', (char)' ', (boolean)false, (int)4, null));
    }

    @Override
    protected void scrollIntoView(@NotNull AbstractTextInput.LinePosition pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        int column = pos.getColumn();
        String lineText = this.getTextForRender();
        if (column < 0 || column > lineText.length()) {
            return;
        }
        String string = lineText.substring(0, column);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        float widthBeforePosition = UtilitiesKt.width(string, this.getTextScale(), this.getFontProvider());
        float widthTotal = widthBeforePosition + (this.getActive() ? this.getCursorComponent().getWidth() : 0.0f);
        if (UtilitiesKt.width(this.getTextForRender(), this.getTextScale(), this.getFontProvider()) < this.getWidth()) {
            this.setHorizontalScrollingOffset(0.0f);
        } else if (this.getHorizontalScrollingOffset() > widthBeforePosition) {
            this.setHorizontalScrollingOffset(widthBeforePosition);
        } else if (widthTotal - this.getHorizontalScrollingOffset() > this.getWidth()) {
            this.setHorizontalScrollingOffset(widthTotal - this.getWidth());
        }
    }

    @Override
    @NotNull
    protected AbstractTextInput.LinePosition screenPosToVisualPos(float x, float y) {
        float targetXPos = x + this.getHorizontalScrollingOffset();
        float currentX = 0.0f;
        String line = this.getTextForRender();
        int n = line.length();
        for (int i2 = 0; i2 < n; ++i2) {
            float charWidth = UtilitiesKt.width(String.valueOf(line.charAt(i2)), this.getTextScale(), this.getFontProvider());
            if (currentX + charWidth / (float)2 >= targetXPos) {
                return new AbstractTextInput.LinePosition(0, i2, true);
            }
            currentX += charWidth;
        }
        return new AbstractTextInput.LinePosition(0, line.length(), true);
    }

    @Override
    protected void recalculateDimensions() {
        WidthConstraint widthConstraint = this.minWidth;
        if (widthConstraint == null) {
            return;
        }
        WidthConstraint minWidth = widthConstraint;
        WidthConstraint widthConstraint2 = this.maxWidth;
        if (widthConstraint2 == null) {
            return;
        }
        WidthConstraint maxWidth = widthConstraint2;
        WidthConstraint newWidth2 = BasicConstraintsKt.basicWidthConstraint((Function1<? super UIComponent, Float>)((Function1)new Function1<UIComponent, Float>(this){
            final /* synthetic */ UITextInput this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Float invoke(@NotNull UIComponent it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return Float.valueOf(!this.this$0.hasText() && !this.this$0.getActive() ? this.this$0.getPlaceholderWidth() : UtilitiesKt.width(this.this$0.getTextForRender(), this.this$0.getTextScale(), this.this$0.getFontProvider()) + 1.0f);
            }
        }));
        this.setWidth(ConstraintsKt.coerceIn(newWidth2, minWidth, maxWidth));
    }

    @Override
    @NotNull
    protected List<String> splitTextForWrapping(@NotNull String text2, float maxLineWidth) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        return CollectionsKt.listOf((Object)text2);
    }

    @Override
    protected void onEnterPressed() {
        this.getActivateAction().invoke((Object)this.getText());
    }

    @Override
    public void draw(@NotNull UMatrixStack matrixStack) {
        Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
        this.beforeDrawCompat(matrixStack);
        if (!this.getActive() && !this.hasText()) {
            this.drawPlaceholder(matrixStack);
            super.draw(matrixStack);
            return;
        }
        String lineText = this.getTextForRender();
        if (this.hasSelection()) {
            float currentX = this.getLeft();
            this.getCursorComponent().hide(true);
            if (!this.selectionStart().isAtLineStart()) {
                String string = lineText.substring(0, this.selectionStart().getColumn());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                String preSelectionText = string;
                AbstractTextInput.drawUnselectedText$default(this, matrixStack, preSelectionText, currentX, 0, null, false, null, 112, null);
                currentX += UtilitiesKt.width(preSelectionText, this.getTextScale(), this.getFontProvider());
            }
            String string = lineText.substring(this.selectionStart().getColumn(), this.selectionEnd().getColumn());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String selectedText2 = string;
            float selectedTextWidth = UtilitiesKt.width(selectedText2, this.getTextScale(), this.getFontProvider());
            this.drawSelectedText(matrixStack, selectedText2, currentX, currentX + selectedTextWidth, 0);
            currentX += selectedTextWidth;
            if (!this.selectionEnd().isAtLineEnd()) {
                AbstractTextInput abstractTextInput = this;
                String string2 = lineText.substring(this.selectionEnd().getColumn());
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                AbstractTextInput.drawUnselectedText$default(abstractTextInput, matrixStack, string2, currentX, 0, null, false, null, 112, null);
            }
        } else {
            if (this.getActive()) {
                this.getCursorComponent().setY(BasicConstraintsKt.basicYConstraint((Function1<? super UIComponent, Float>)((Function1)new Function1<UIComponent, Float>(this){
                    final /* synthetic */ UITextInput this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final Float invoke(@NotNull UIComponent it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return Float.valueOf(this.this$0.getTop());
                    }
                })));
                this.setCursorPos();
            }
            AbstractTextInput.drawUnselectedText$default(this, matrixStack, lineText, this.getLeft(), 0, null, false, null, 112, null);
        }
        super.draw(matrixStack);
    }

    @JvmOverloads
    public UITextInput(@NotNull String placeholder, boolean shadow2, @Nullable Color shadowColor2, @NotNull Color selectionBackgroundColor, @NotNull Color selectionForegroundColor, boolean allowInactiveSelection, @NotNull Color inactiveSelectionBackgroundColor, @NotNull Color inactiveSelectionForegroundColor, @NotNull Color cursorColor) {
        Intrinsics.checkNotNullParameter((Object)placeholder, (String)"placeholder");
        Intrinsics.checkNotNullParameter((Object)selectionBackgroundColor, (String)"selectionBackgroundColor");
        Intrinsics.checkNotNullParameter((Object)selectionForegroundColor, (String)"selectionForegroundColor");
        Intrinsics.checkNotNullParameter((Object)inactiveSelectionBackgroundColor, (String)"inactiveSelectionBackgroundColor");
        Intrinsics.checkNotNullParameter((Object)inactiveSelectionForegroundColor, (String)"inactiveSelectionForegroundColor");
        Intrinsics.checkNotNullParameter((Object)cursorColor, (String)"cursorColor");
        this(placeholder, shadow2, shadowColor2, selectionBackgroundColor, selectionForegroundColor, allowInactiveSelection, inactiveSelectionBackgroundColor, inactiveSelectionForegroundColor, cursorColor, 0, 512, null);
    }

    @JvmOverloads
    public UITextInput(@NotNull String placeholder, boolean shadow2, @Nullable Color shadowColor2, @NotNull Color selectionBackgroundColor, @NotNull Color selectionForegroundColor, boolean allowInactiveSelection, @NotNull Color inactiveSelectionBackgroundColor, @NotNull Color inactiveSelectionForegroundColor) {
        Intrinsics.checkNotNullParameter((Object)placeholder, (String)"placeholder");
        Intrinsics.checkNotNullParameter((Object)selectionBackgroundColor, (String)"selectionBackgroundColor");
        Intrinsics.checkNotNullParameter((Object)selectionForegroundColor, (String)"selectionForegroundColor");
        Intrinsics.checkNotNullParameter((Object)inactiveSelectionBackgroundColor, (String)"inactiveSelectionBackgroundColor");
        Intrinsics.checkNotNullParameter((Object)inactiveSelectionForegroundColor, (String)"inactiveSelectionForegroundColor");
        this(placeholder, shadow2, shadowColor2, selectionBackgroundColor, selectionForegroundColor, allowInactiveSelection, inactiveSelectionBackgroundColor, inactiveSelectionForegroundColor, null, 0, 768, null);
    }

    @JvmOverloads
    public UITextInput(@NotNull String placeholder, boolean shadow2, @Nullable Color shadowColor2, @NotNull Color selectionBackgroundColor, @NotNull Color selectionForegroundColor, boolean allowInactiveSelection, @NotNull Color inactiveSelectionBackgroundColor) {
        Intrinsics.checkNotNullParameter((Object)placeholder, (String)"placeholder");
        Intrinsics.checkNotNullParameter((Object)selectionBackgroundColor, (String)"selectionBackgroundColor");
        Intrinsics.checkNotNullParameter((Object)selectionForegroundColor, (String)"selectionForegroundColor");
        Intrinsics.checkNotNullParameter((Object)inactiveSelectionBackgroundColor, (String)"inactiveSelectionBackgroundColor");
        this(placeholder, shadow2, shadowColor2, selectionBackgroundColor, selectionForegroundColor, allowInactiveSelection, inactiveSelectionBackgroundColor, null, null, 0, 896, null);
    }

    @JvmOverloads
    public UITextInput(@NotNull String placeholder, boolean shadow2, @Nullable Color shadowColor2, @NotNull Color selectionBackgroundColor, @NotNull Color selectionForegroundColor, boolean allowInactiveSelection) {
        Intrinsics.checkNotNullParameter((Object)placeholder, (String)"placeholder");
        Intrinsics.checkNotNullParameter((Object)selectionBackgroundColor, (String)"selectionBackgroundColor");
        Intrinsics.checkNotNullParameter((Object)selectionForegroundColor, (String)"selectionForegroundColor");
        this(placeholder, shadow2, shadowColor2, selectionBackgroundColor, selectionForegroundColor, allowInactiveSelection, null, null, null, 0, 960, null);
    }

    @JvmOverloads
    public UITextInput(@NotNull String placeholder, boolean shadow2, @Nullable Color shadowColor2, @NotNull Color selectionBackgroundColor, @NotNull Color selectionForegroundColor) {
        Intrinsics.checkNotNullParameter((Object)placeholder, (String)"placeholder");
        Intrinsics.checkNotNullParameter((Object)selectionBackgroundColor, (String)"selectionBackgroundColor");
        Intrinsics.checkNotNullParameter((Object)selectionForegroundColor, (String)"selectionForegroundColor");
        this(placeholder, shadow2, shadowColor2, selectionBackgroundColor, selectionForegroundColor, false, null, null, null, 0, 992, null);
    }

    @JvmOverloads
    public UITextInput(@NotNull String placeholder, boolean shadow2, @Nullable Color shadowColor2, @NotNull Color selectionBackgroundColor) {
        Intrinsics.checkNotNullParameter((Object)placeholder, (String)"placeholder");
        Intrinsics.checkNotNullParameter((Object)selectionBackgroundColor, (String)"selectionBackgroundColor");
        this(placeholder, shadow2, shadowColor2, selectionBackgroundColor, null, false, null, null, null, 0, 1008, null);
    }

    @JvmOverloads
    public UITextInput(@NotNull String placeholder, boolean shadow2, @Nullable Color shadowColor2) {
        Intrinsics.checkNotNullParameter((Object)placeholder, (String)"placeholder");
        this(placeholder, shadow2, shadowColor2, null, null, false, null, null, null, 0, 1016, null);
    }

    @JvmOverloads
    public UITextInput(@NotNull String placeholder, boolean shadow2) {
        Intrinsics.checkNotNullParameter((Object)placeholder, (String)"placeholder");
        this(placeholder, shadow2, null, null, null, false, null, null, null, 0, 1020, null);
    }

    @JvmOverloads
    public UITextInput(@NotNull String placeholder) {
        Intrinsics.checkNotNullParameter((Object)placeholder, (String)"placeholder");
        this(placeholder, false, null, null, null, false, null, null, null, 0, 1022, null);
    }

    @JvmOverloads
    public UITextInput() {
        this(null, false, null, null, null, false, null, null, null, 0, 1023, null);
    }
}

