/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.gui.elementa.state.v2;

import gg.essential.gui.elementa.state.v2.ObservedDuration;
import gg.essential.gui.elementa.state.v2.ObservedInstant;
import gg.essential.gui.elementa.state.v2.ObservedLong;
import gg.essential.gui.elementa.state.v2.ObservedValue;
import java.time.Duration;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00162\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0016B!\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0011\u001a\u00020\u0002H\u0016J\u0006\u0010\u0012\u001a\u00020\u0013J\b\u0010\u0014\u001a\u00020\u0015H\u0016R \u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\fR\u0011\u0010\r\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\fR\u0011\u0010\u000e\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u0014\u0010\u0003\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0017"}, d2={"Lgg/essential/gui/elementa/state/v2/ObservedDuration;", "Lgg/essential/gui/elementa/state/v2/ObservedValue;", "Ljava/time/Duration;", "untracked", "changesAt", "Lkotlin/Function1;", "", "(Ljava/time/Duration;Lkotlin/jvm/functions/Function1;)V", "getChangesAt", "()Lkotlin/jvm/functions/Function1;", "isNegative", "", "()Z", "isPositive", "isZero", "getUntracked", "()Ljava/time/Duration;", "getValue", "toMillis", "Lgg/essential/gui/elementa/state/v2/ObservedLong;", "toString", "", "Companion", "essential-elementa-statev2"})
@SourceDebugExtension(value={"SMAP\ntime.kt\nKotlin\n*S Kotlin\n*F\n+ 1 time.kt\ngg/essential/gui/elementa/state/v2/ObservedDuration\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,394:1\n1#2:395\n*E\n"})
public final class ObservedDuration
implements ObservedValue<Duration> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Duration untracked;
    @NotNull
    private final Function1<Duration, Unit> changesAt;
    private static final Duration MIN_DURATION = Duration.ofSeconds(Long.MIN_VALUE, 0L);
    private static final Duration MAX_DURATION = Duration.ofSeconds(Long.MAX_VALUE, 999999999L);
    private static final Duration SMALLEST_POSITIVE_DURATION = Duration.ofNanos(1L);
    private static final Duration SMALLEST_NEGATIVE_DURATION = Duration.ofNanos(-1L);

    public ObservedDuration(@NotNull Duration untracked, @NotNull Function1<? super Duration, Unit> changesAt) {
        Intrinsics.checkNotNullParameter((Object)untracked, (String)"untracked");
        Intrinsics.checkNotNullParameter(changesAt, (String)"changesAt");
        this.untracked = untracked;
        this.changesAt = changesAt;
    }

    @Override
    @NotNull
    public Duration getUntracked() {
        return this.untracked;
    }

    @Override
    @NotNull
    public Function1<Duration, Unit> getChangesAt() {
        return this.changesAt;
    }

    @Override
    @NotNull
    public Duration getValue() {
        if (!Intrinsics.areEqual((Object)this.getUntracked(), (Object)MIN_DURATION)) {
            Function1<Duration, Unit> function1 = this.getChangesAt();
            Duration duration = this.getUntracked().minusNanos(1L);
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"minusNanos(...)");
            function1.invoke((Object)duration);
        }
        if (!Intrinsics.areEqual((Object)this.getUntracked(), (Object)MAX_DURATION)) {
            Function1<Duration, Unit> function1 = this.getChangesAt();
            Duration duration = this.getUntracked().plusNanos(1L);
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"plusNanos(...)");
            function1.invoke((Object)duration);
        }
        return this.getUntracked();
    }

    @NotNull
    public String toString() {
        String string = this.getValue().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public final ObservedLong toMillis() {
        return new ObservedLong(this.getUntracked().toMillis(), (Function1<? super Long, Unit>)((Function1)new Function1<Long, Unit>(this){
            final /* synthetic */ ObservedDuration this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(long it) {
                Function1<Duration, Unit> function1 = this.this$0.getChangesAt();
                Duration duration = Duration.ofMillis(it);
                Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(...)");
                function1.invoke((Object)duration);
            }
        }));
    }

    public final boolean isNegative() {
        boolean bl;
        boolean it = bl = this.getUntracked().isNegative();
        boolean bl2 = false;
        Function1<Duration, Unit> function1 = this.getChangesAt();
        Duration duration = it ? Duration.ZERO : SMALLEST_NEGATIVE_DURATION;
        Intrinsics.checkNotNull((Object)duration);
        function1.invoke((Object)duration);
        return bl;
    }

    public final boolean isPositive() {
        boolean bl;
        boolean it = bl = !this.getUntracked().isNegative() && !this.getUntracked().isZero();
        boolean bl2 = false;
        Function1<Duration, Unit> function1 = this.getChangesAt();
        Duration duration = it ? Duration.ZERO : SMALLEST_POSITIVE_DURATION;
        Intrinsics.checkNotNull((Object)duration);
        function1.invoke((Object)duration);
        return bl;
    }

    public final boolean isZero() {
        return !this.isNegative() && !this.isPositive();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fJ\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\fJ\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000eR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lgg/essential/gui/elementa/state/v2/ObservedDuration$Companion;", "", "()V", "MAX_DURATION", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "MIN_DURATION", "SMALLEST_NEGATIVE_DURATION", "SMALLEST_POSITIVE_DURATION", "between", "Lgg/essential/gui/elementa/state/v2/ObservedDuration;", "startInclusive", "Lgg/essential/gui/elementa/state/v2/ObservedInstant;", "endExclusive", "Ljava/time/Instant;", "essential-elementa-statev2"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ObservedDuration between(@NotNull Instant startInclusive, @NotNull Instant endExclusive) {
            Intrinsics.checkNotNullParameter((Object)startInclusive, (String)"startInclusive");
            Intrinsics.checkNotNullParameter((Object)endExclusive, (String)"endExclusive");
            Duration duration = Duration.between(startInclusive, endExclusive);
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"between(...)");
            return new ObservedDuration(duration, (Function1<? super Duration, Unit>)((Function1)between.1.INSTANCE));
        }

        @NotNull
        public final ObservedDuration between(@NotNull ObservedInstant startInclusive, @NotNull Instant endExclusive) {
            Intrinsics.checkNotNullParameter((Object)startInclusive, (String)"startInclusive");
            Intrinsics.checkNotNullParameter((Object)endExclusive, (String)"endExclusive");
            Duration duration = Duration.between(startInclusive.getUntracked(), endExclusive);
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"between(...)");
            return new ObservedDuration(duration, (Function1<? super Duration, Unit>)((Function1)new Function1<Duration, Unit>(startInclusive, endExclusive){
                final /* synthetic */ ObservedInstant $startInclusive;
                final /* synthetic */ Instant $endExclusive;
                {
                    this.$startInclusive = $startInclusive;
                    this.$endExclusive = $endExclusive;
                    super(1);
                }

                public final void invoke(@NotNull Duration duration) {
                    Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
                    Function1<Instant, Unit> function1 = this.$startInclusive.getChangesAt();
                    Instant instant = this.$endExclusive.minus(duration);
                    Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"minus(...)");
                    function1.invoke((Object)instant);
                }
            }));
        }

        @NotNull
        public final ObservedDuration between(@NotNull Instant startInclusive, @NotNull ObservedInstant endExclusive) {
            Intrinsics.checkNotNullParameter((Object)startInclusive, (String)"startInclusive");
            Intrinsics.checkNotNullParameter((Object)endExclusive, (String)"endExclusive");
            Duration duration = Duration.between(startInclusive, endExclusive.getUntracked());
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"between(...)");
            return new ObservedDuration(duration, (Function1<? super Duration, Unit>)((Function1)new Function1<Duration, Unit>(endExclusive, startInclusive){
                final /* synthetic */ ObservedInstant $endExclusive;
                final /* synthetic */ Instant $startInclusive;
                {
                    this.$endExclusive = $endExclusive;
                    this.$startInclusive = $startInclusive;
                    super(1);
                }

                public final void invoke(@NotNull Duration duration) {
                    Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
                    Function1<Instant, Unit> function1 = this.$endExclusive.getChangesAt();
                    Instant instant = this.$startInclusive.plus(duration);
                    Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"plus(...)");
                    function1.invoke((Object)instant);
                }
            }));
        }

        @NotNull
        public final ObservedDuration between(@NotNull ObservedInstant startInclusive, @NotNull ObservedInstant endExclusive) {
            Intrinsics.checkNotNullParameter((Object)startInclusive, (String)"startInclusive");
            Intrinsics.checkNotNullParameter((Object)endExclusive, (String)"endExclusive");
            Duration duration = Duration.between(startInclusive.getUntracked(), endExclusive.getUntracked());
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"between(...)");
            return new ObservedDuration(duration, (Function1<? super Duration, Unit>)((Function1)new Function1<Duration, Unit>(startInclusive, endExclusive){
                final /* synthetic */ ObservedInstant $startInclusive;
                final /* synthetic */ ObservedInstant $endExclusive;
                {
                    this.$startInclusive = $startInclusive;
                    this.$endExclusive = $endExclusive;
                    super(1);
                }

                public final void invoke(@NotNull Duration duration) {
                    Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
                    Function1<Instant, Unit> function1 = this.$startInclusive.getChangesAt();
                    Instant instant = this.$endExclusive.getUntracked().minus(duration);
                    Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"minus(...)");
                    function1.invoke((Object)instant);
                    Function1<Instant, Unit> function12 = this.$endExclusive.getChangesAt();
                    Instant instant2 = this.$startInclusive.getUntracked().plus(duration);
                    Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"plus(...)");
                    function12.invoke((Object)instant2);
                }
            }));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

