/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.gui.image;

import gg.essential.elementa.components.UIImage;
import gg.essential.gui.image.EssentialAssetImageFactory;
import gg.essential.gui.image.ImageFactory;
import gg.essential.mod.EssentialAsset;
import gg.essential.network.connectionmanager.cosmetics.AssetLoader;
import gg.essential.util.GuiEssentialPlatform;
import java.awt.image.BufferedImage;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0086\b\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\r\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c2\u0003J\u001d\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\b\u0010\u0014\u001a\u00020\u0015H\u0014J\u0010\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0005H\u0002J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0005J\t\u0010\u001d\u001a\u00020\nH\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lgg/essential/gui/image/EssentialAssetImageFactory;", "Lgg/essential/gui/image/ImageFactory;", "asset", "Lgg/essential/mod/EssentialAsset;", "priority", "Lgg/essential/network/connectionmanager/cosmetics/AssetLoader$Priority;", "(Lgg/essential/mod/EssentialAsset;Lgg/essential/network/connectionmanager/cosmetics/AssetLoader$Priority;)V", "assetLoader", "Lgg/essential/network/connectionmanager/cosmetics/AssetLoader;", "name", "", "getName", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "", "generate", "Lgg/essential/elementa/components/UIImage;", "getCachedImage", "computePriority", "hashCode", "", "primeCache", "", "cachePriority", "toString", "Companion", "essential-gui-essential"})
public final class EssentialAssetImageFactory
extends ImageFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EssentialAsset asset;
    @NotNull
    private final AssetLoader.Priority priority;
    @NotNull
    private final AssetLoader assetLoader;
    @NotNull
    private static final Map<String, UIImage> cache = new LinkedHashMap();

    public EssentialAssetImageFactory(@NotNull EssentialAsset asset, @NotNull AssetLoader.Priority priority) {
        Intrinsics.checkNotNullParameter((Object)asset, (String)"asset");
        Intrinsics.checkNotNullParameter((Object)((Object)priority), (String)"priority");
        super(null, 1, null);
        this.asset = asset;
        this.priority = priority;
        this.assetLoader = GuiEssentialPlatform.Companion.getPlatform().getAssetLoader();
    }

    public /* synthetic */ EssentialAssetImageFactory(EssentialAsset essentialAsset, AssetLoader.Priority priority, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            priority = AssetLoader.Priority.Blocking;
        }
        this(essentialAsset, priority);
    }

    @Override
    @NotNull
    public String getName() {
        return this.asset.getUrl();
    }

    public final void primeCache(@NotNull AssetLoader.Priority cachePriority) {
        Intrinsics.checkNotNullParameter((Object)((Object)cachePriority), (String)"cachePriority");
        this.getCachedImage(cachePriority);
    }

    private final UIImage getCachedImage(AssetLoader.Priority computePriority) {
        CompletableFuture<byte[]> byteArrayFuture = this.assetLoader.getAssetBytes(this.asset, computePriority);
        UIImage uIImage = cache.computeIfAbsent(this.asset.getChecksum(), arg_0 -> EssentialAssetImageFactory.getCachedImage$lambda$0((Function1)new Function1<String, UIImage>(byteArrayFuture){
            final /* synthetic */ CompletableFuture<byte[]> $byteArrayFuture;
            {
                this.$byteArrayFuture = $byteArrayFuture;
                super(1);
            }

            @NotNull
            public final UIImage invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                CompletionStage completionStage = this.$byteArrayFuture.thenApplyAsync(arg_0 -> getCachedImage.1.invoke$lambda$0(getCachedImage.1.INSTANCE, arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenApplyAsync(...)");
                return new UIImage((CompletableFuture)completionStage, null, null, 6, null);
            }

            private static final BufferedImage invoke$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (BufferedImage)$tmp0.invoke(p0);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)uIImage, (String)"computeIfAbsent(...)");
        return uIImage;
    }

    @Override
    @NotNull
    protected UIImage generate() {
        UIImage uIImage;
        UIImage cachedImage2 = this.getCachedImage(this.priority);
        CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
        UIImage it = uIImage = new UIImage(completableFuture, null, null, 6, null);
        boolean bl = false;
        cachedImage2.supply(it);
        return uIImage;
    }

    private final EssentialAsset component1() {
        return this.asset;
    }

    private final AssetLoader.Priority component2() {
        return this.priority;
    }

    @NotNull
    public final EssentialAssetImageFactory copy(@NotNull EssentialAsset asset, @NotNull AssetLoader.Priority priority) {
        Intrinsics.checkNotNullParameter((Object)asset, (String)"asset");
        Intrinsics.checkNotNullParameter((Object)((Object)priority), (String)"priority");
        return new EssentialAssetImageFactory(asset, priority);
    }

    public static /* synthetic */ EssentialAssetImageFactory copy$default(EssentialAssetImageFactory essentialAssetImageFactory, EssentialAsset essentialAsset, AssetLoader.Priority priority, int n, Object object) {
        if ((n & 1) != 0) {
            essentialAsset = essentialAssetImageFactory.asset;
        }
        if ((n & 2) != 0) {
            priority = essentialAssetImageFactory.priority;
        }
        return essentialAssetImageFactory.copy(essentialAsset, priority);
    }

    @NotNull
    public String toString() {
        return "EssentialAssetImageFactory(asset=" + this.asset + ", priority=" + (Object)((Object)this.priority) + ')';
    }

    public int hashCode() {
        int result = this.asset.hashCode();
        result = result * 31 + this.priority.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof EssentialAssetImageFactory)) {
            return false;
        }
        EssentialAssetImageFactory essentialAssetImageFactory = (EssentialAssetImageFactory)other;
        if (!Intrinsics.areEqual((Object)this.asset, (Object)essentialAssetImageFactory.asset)) {
            return false;
        }
        return this.priority == essentialAssetImageFactory.priority;
    }

    private static final UIImage getCachedImage$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (UIImage)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lgg/essential/gui/image/EssentialAssetImageFactory$Companion;", "", "()V", "cache", "", "", "Lgg/essential/elementa/components/UIImage;", "essential-gui-essential"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

