/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.gui.screenshot.handler;

import com.google.common.collect.MapMaker;
import com.google.common.collect.Sets;
import com.sparkuniverse.toolbox.serialization.DateTimeTypeAdapter;
import com.sparkuniverse.toolbox.serialization.UUIDTypeAdapter;
import com.sparkuniverse.toolbox.util.DateTime;
import gg.essential.gui.elementa.state.v2.MutableState;
import gg.essential.gui.elementa.state.v2.State;
import gg.essential.gui.elementa.state.v2.StateKt;
import gg.essential.gui.screenshot.handler.ScreenshotChecksumManager;
import gg.essential.handlers.screenshot.ClientScreenshotMetadata;
import gg.essential.lib.gson.Gson;
import gg.essential.lib.gson.GsonBuilder;
import gg.essential.lib.gson.JsonSyntaxException;
import gg.essential.network.connectionmanager.media.IScreenshotMetadataManager;
import gg.essential.util.DispatchersKt;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 )2\u00020\u0001:\u0001)B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\rH\u0002J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0003J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0016\u001a\u00020\u0003H\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001a\u001a\u00020\fH\u0002J\u0010\u0010\u001b\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001c\u001a\u00020\fJ\u0010\u0010\u001d\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u000e\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\fJ\u0016\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0 2\u0006\u0010\u001a\u001a\u00020\fJ\u0012\u0010!\u001a\u0004\u0018\u00010\r2\u0006\u0010\"\u001a\u00020\fH\u0002J\u0012\u0010#\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001a\u001a\u00020\fH\u0002J\u000e\u0010$\u001a\u00020\u00142\u0006\u0010%\u001a\u00020\rJ\u001a\u0010&\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\f2\b\u0010'\u001a\u0004\u0018\u00010\rH\u0002J\u0010\u0010(\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\rH\u0002R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u000e\u001a&\u0012\f\u0012\n \t*\u0004\u0018\u00010\f0\f \t*\u0012\u0012\f\u0012\n \t*\u0004\u0018\u00010\f0\f\u0018\u00010\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0011\u001a\u0016\u0012\u0004\u0012\u00020\f\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\u00120\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lgg/essential/gui/screenshot/handler/ScreenshotMetadataManager;", "Lgg/essential/network/connectionmanager/media/IScreenshotMetadataManager;", "metadataFolder", "Ljava/io/File;", "screenshotChecksumManager", "Lgg/essential/gui/screenshot/handler/ScreenshotChecksumManager;", "(Ljava/io/File;Lgg/essential/gui/screenshot/handler/ScreenshotChecksumManager;)V", "gson", "Lgg/essential/lib/gson/Gson;", "kotlin.jvm.PlatformType", "metadataCache", "", "", "Lgg/essential/handlers/screenshot/ClientScreenshotMetadata;", "negativeChecksumCache", "", "", "stateByChecksum", "Lgg/essential/gui/elementa/state/v2/MutableState;", "deleteMetadata", "", "metadata", "file", "getMetadata", "path", "Ljava/nio/file/Path;", "checksum", "getMetadataCache", "mediaId", "getOrCreateMetadata", "handleExternalDelete", "fileName", "Lgg/essential/gui/elementa/state/v2/State;", "readMetadata", "imageChecksum", "tryRecoverMetadata", "updateMetadata", "screenshotMetadata", "updateState", "newMetadata", "writeMetadata", "Companion", "essential-gui-essential"})
@SourceDebugExtension(value={"SMAP\nScreenshotMetadataManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScreenshotMetadataManager.kt\ngg/essential/gui/screenshot/handler/ScreenshotMetadataManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,180:1\n1#2:181\n288#3,2:182\n372#4,7:184\n*S KotlinDebug\n*F\n+ 1 ScreenshotMetadataManager.kt\ngg/essential/gui/screenshot/handler/ScreenshotMetadataManager\n*L\n110#1:182,2\n174#1:184,7\n*E\n"})
public final class ScreenshotMetadataManager
implements IScreenshotMetadataManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File metadataFolder;
    @NotNull
    private final ScreenshotChecksumManager screenshotChecksumManager;
    private final Gson gson;
    @NotNull
    private final Map<String, ClientScreenshotMetadata> metadataCache;
    private final Set<String> negativeChecksumCache;
    @NotNull
    private final Map<String, MutableState<ClientScreenshotMetadata>> stateByChecksum;
    private static final Logger LOGGER = LoggerFactory.getLogger(ScreenshotMetadataManager.class);

    public ScreenshotMetadataManager(@NotNull File metadataFolder, @NotNull ScreenshotChecksumManager screenshotChecksumManager) {
        Intrinsics.checkNotNullParameter((Object)metadataFolder, (String)"metadataFolder");
        Intrinsics.checkNotNullParameter((Object)screenshotChecksumManager, (String)"screenshotChecksumManager");
        this.metadataFolder = metadataFolder;
        this.screenshotChecksumManager = screenshotChecksumManager;
        this.gson = new GsonBuilder().registerTypeAdapter((Type)((Object)UUID.class), new UUIDTypeAdapter()).registerTypeAdapter((Type)((Object)DateTime.class), new DateTimeTypeAdapter()).create();
        this.metadataCache = new ConcurrentHashMap();
        this.negativeChecksumCache = Sets.newConcurrentHashSet();
        ConcurrentMap concurrentMap = new MapMaker().weakValues().makeMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"makeMap(...)");
        this.stateByChecksum = concurrentMap;
    }

    public final void updateMetadata(@NotNull ClientScreenshotMetadata screenshotMetadata) {
        Intrinsics.checkNotNullParameter((Object)screenshotMetadata, (String)"screenshotMetadata");
        this.metadataCache.put(screenshotMetadata.getChecksum(), screenshotMetadata);
        this.writeMetadata(screenshotMetadata);
        this.updateState(screenshotMetadata.getChecksum(), screenshotMetadata);
    }

    private final ClientScreenshotMetadata readMetadata(String imageChecksum) {
        ClientScreenshotMetadata clientScreenshotMetadata;
        try {
            String fileContents = FilesKt.readText$default((File)new File(this.metadataFolder, imageChecksum), null, (int)1, null);
            clientScreenshotMetadata = this.gson.fromJson(fileContents, ClientScreenshotMetadata.class);
        }
        catch (JsonSyntaxException exception) {
            LOGGER.error("Metadata corrupt for checksum " + imageChecksum + ". Attempting recovery.", (Throwable)exception);
            clientScreenshotMetadata = this.tryRecoverMetadata(imageChecksum);
        }
        catch (FileNotFoundException ignored) {
            clientScreenshotMetadata = null;
        }
        return clientScreenshotMetadata;
    }

    private final ClientScreenshotMetadata tryRecoverMetadata(String checksum) {
        ClientScreenshotMetadata metadata2;
        block2: {
            ClientScreenshotMetadata clientScreenshotMetadata;
            Path path = (Path)CollectionsKt.firstOrNull(this.screenshotChecksumManager.getPathsForChecksum(checksum));
            if (path != null) {
                Path it = path;
                boolean bl = false;
                clientScreenshotMetadata = ClientScreenshotMetadata.Companion.createUnknown(it, checksum);
            } else {
                clientScreenshotMetadata = null;
            }
            ClientScreenshotMetadata clientScreenshotMetadata2 = metadata2 = clientScreenshotMetadata;
            if (clientScreenshotMetadata2 == null) break block2;
            ClientScreenshotMetadata it = clientScreenshotMetadata2;
            boolean bl = false;
            this.writeMetadata(it);
        }
        return metadata2;
    }

    private final ClientScreenshotMetadata getMetadata(String checksum) {
        ClientScreenshotMetadata metadata2;
        if (this.negativeChecksumCache.contains(checksum)) {
            return null;
        }
        ClientScreenshotMetadata clientScreenshotMetadata = this.metadataCache.get(checksum);
        if (clientScreenshotMetadata == null) {
            ClientScreenshotMetadata clientScreenshotMetadata2 = this.readMetadata(checksum);
            if (clientScreenshotMetadata2 != null) {
                ClientScreenshotMetadata clientScreenshotMetadata3;
                ClientScreenshotMetadata metadata3 = clientScreenshotMetadata3 = clientScreenshotMetadata2;
                boolean bl = false;
                this.metadataCache.put(checksum, metadata3);
                this.updateState(metadata3.getChecksum(), metadata3);
                clientScreenshotMetadata = clientScreenshotMetadata3;
            } else {
                clientScreenshotMetadata = null;
            }
        }
        if ((metadata2 = clientScreenshotMetadata) == null) {
            this.negativeChecksumCache.add(checksum);
        }
        return metadata2;
    }

    @Override
    @Nullable
    public ClientScreenshotMetadata getMetadata(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        File file = path.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        return this.getMetadata(file);
    }

    @Override
    @Nullable
    public ClientScreenshotMetadata getMetadata(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = this.screenshotChecksumManager.get(file);
        if (string == null) {
            return null;
        }
        String imageChecksum = string;
        return this.getMetadata(imageChecksum);
    }

    @Nullable
    public final ClientScreenshotMetadata getMetadataCache(@NotNull String mediaId) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)mediaId, (String)"mediaId");
            Iterable $this$firstOrNull$iv = this.metadataCache.values();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ClientScreenshotMetadata it = (ClientScreenshotMetadata)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getMediaId(), (Object)mediaId)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final void writeMetadata(ClientScreenshotMetadata metadata2) {
        this.negativeChecksumCache.remove(metadata2.getChecksum());
        try {
            File file = new File(this.metadataFolder, metadata2.getChecksum());
            String string = this.gson.toJson(metadata2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
            FilesKt.writeText$default((File)file, (String)string, null, (int)2, null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public final void handleExternalDelete(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        String string = this.screenshotChecksumManager.remove(fileName);
        if (string == null) {
            return;
        }
        String checksum = string;
        ClientScreenshotMetadata metadata2 = this.getMetadata(checksum);
        if (metadata2 != null) {
            this.deleteMetadata(metadata2);
        }
    }

    private final void deleteMetadata(ClientScreenshotMetadata metadata2) {
        File metadataFile = new File(this.metadataFolder, metadata2.getChecksum());
        this.metadataCache.remove(metadata2.getChecksum());
        this.updateState(metadata2.getChecksum(), null);
        metadataFile.delete();
    }

    public final void deleteMetadata(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ClientScreenshotMetadata metadata2 = this.getMetadata(file);
        if (metadata2 != null) {
            this.deleteMetadata(metadata2);
            this.screenshotChecksumManager.delete(file);
        }
    }

    @Override
    @NotNull
    public synchronized ClientScreenshotMetadata getOrCreateMetadata(@NotNull Path path) {
        ClientScreenshotMetadata clientScreenshotMetadata;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        File file = path.toFile();
        Intrinsics.checkNotNull((Object)file);
        ClientScreenshotMetadata existingMetadata = this.getMetadata(file);
        if (existingMetadata != null) {
            return existingMetadata;
        }
        String string = this.screenshotChecksumManager.get(file);
        if (string == null) {
            throw new IllegalStateException("No checksum for file " + file + ". Was the file deleted?");
        }
        String checksum = string;
        ClientScreenshotMetadata it = clientScreenshotMetadata = ClientScreenshotMetadata.Companion.createUnknown(path, checksum);
        boolean bl = false;
        this.updateMetadata(it);
        return clientScreenshotMetadata;
    }

    private final void updateState(String checksum, ClientScreenshotMetadata newMetadata) {
        BuildersKt.runBlocking((CoroutineContext)((CoroutineContext)DispatchersKt.getClient(Dispatchers.INSTANCE)), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, checksum, newMetadata, null){
            int label;
            final /* synthetic */ ScreenshotMetadataManager this$0;
            final /* synthetic */ String $checksum;
            final /* synthetic */ ClientScreenshotMetadata $newMetadata;
            {
                this.this$0 = $receiver;
                this.$checksum = $checksum;
                this.$newMetadata = $newMetadata;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        Unit unit;
                        ResultKt.throwOnFailure((Object)object);
                        MutableState mutableState2 = (MutableState)ScreenshotMetadataManager.access$getStateByChecksum$p(this.this$0).get(this.$checksum);
                        if (mutableState2 != null) {
                            mutableState2.set(this.$newMetadata);
                            unit = Unit.INSTANCE;
                        } else {
                            unit = null;
                        }
                        return unit;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    @NotNull
    public final State<ClientScreenshotMetadata> metadata(@NotNull String checksum) {
        MutableState<ClientScreenshotMetadata> mutableState2;
        Intrinsics.checkNotNullParameter((Object)checksum, (String)"checksum");
        Map<String, MutableState<ClientScreenshotMetadata>> $this$getOrPut$iv = this.stateByChecksum;
        boolean $i$f$getOrPut = false;
        MutableState<ClientScreenshotMetadata> value$iv = $this$getOrPut$iv.get(checksum);
        if (value$iv == null) {
            boolean bl = false;
            MutableState<ClientScreenshotMetadata> answer$iv = StateKt.mutableStateOf(this.getMetadata(checksum));
            $this$getOrPut$iv.put(checksum, answer$iv);
            mutableState2 = answer$iv;
        } else {
            mutableState2 = value$iv;
        }
        return mutableState2;
    }

    public static final /* synthetic */ Map access$getStateByChecksum$p(ScreenshotMetadataManager $this) {
        return $this.stateByChecksum;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lgg/essential/gui/screenshot/handler/ScreenshotMetadataManager$Companion;", "", "()V", "LOGGER", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "essential-gui-essential"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

