/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.gson;

import gg.essential.lib.gson.JsonElement;
import gg.essential.lib.gson.JsonIOException;
import gg.essential.lib.gson.JsonParseException;
import gg.essential.lib.gson.JsonSyntaxException;
import gg.essential.lib.gson.internal.Streams;
import gg.essential.lib.gson.stream.JsonReader;
import gg.essential.lib.gson.stream.JsonToken;
import gg.essential.lib.gson.stream.MalformedJsonException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;

public final class JsonParser {
    @Deprecated
    public JsonParser() {
    }

    public static JsonElement parseString(String json2) throws JsonSyntaxException {
        return JsonParser.parseReader(new StringReader(json2));
    }

    public static JsonElement parseReader(Reader reader2) throws JsonIOException, JsonSyntaxException {
        try {
            JsonReader jsonReader = new JsonReader(reader2);
            JsonElement element = JsonParser.parseReader(jsonReader);
            if (!element.isJsonNull() && jsonReader.peek() != JsonToken.END_DOCUMENT) {
                throw new JsonSyntaxException("Did not consume the entire document.");
            }
            return element;
        }
        catch (MalformedJsonException e) {
            throw new JsonSyntaxException(e);
        }
        catch (IOException e) {
            throw new JsonIOException(e);
        }
        catch (NumberFormatException e) {
            throw new JsonSyntaxException(e);
        }
    }

    public static JsonElement parseReader(JsonReader reader2) throws JsonIOException, JsonSyntaxException {
        boolean lenient = reader2.isLenient();
        reader2.setLenient(true);
        try {
            JsonElement jsonElement = Streams.parse(reader2);
            return jsonElement;
        }
        catch (StackOverflowError e) {
            throw new JsonParseException("Failed parsing JSON source: " + reader2 + " to Json", e);
        }
        catch (OutOfMemoryError e) {
            throw new JsonParseException("Failed parsing JSON source: " + reader2 + " to Json", e);
        }
        finally {
            reader2.setLenient(lenient);
        }
    }

    @Deprecated
    public JsonElement parse(String json2) throws JsonSyntaxException {
        return JsonParser.parseString(json2);
    }

    @Deprecated
    public JsonElement parse(Reader json2) throws JsonIOException, JsonSyntaxException {
        return JsonParser.parseReader(json2);
    }

    @Deprecated
    public JsonElement parse(JsonReader json2) throws JsonIOException, JsonSyntaxException {
        return JsonParser.parseReader(json2);
    }
}

