/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.gson.internal.bind;

import gg.essential.lib.gson.Gson;
import gg.essential.lib.gson.JsonDeserializer;
import gg.essential.lib.gson.JsonSerializer;
import gg.essential.lib.gson.TypeAdapter;
import gg.essential.lib.gson.TypeAdapterFactory;
import gg.essential.lib.gson.annotations.JsonAdapter;
import gg.essential.lib.gson.internal.ConstructorConstructor;
import gg.essential.lib.gson.internal.bind.TreeTypeAdapter;
import gg.essential.lib.gson.reflect.TypeToken;

public final class JsonAdapterAnnotationTypeAdapterFactory
implements TypeAdapterFactory {
    private final ConstructorConstructor constructorConstructor;

    public JsonAdapterAnnotationTypeAdapterFactory(ConstructorConstructor constructorConstructor) {
        this.constructorConstructor = constructorConstructor;
    }

    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> targetType) {
        Class<T> rawType = targetType.getRawType();
        JsonAdapter annotation2 = rawType.getAnnotation(JsonAdapter.class);
        if (annotation2 == null) {
            return null;
        }
        return this.getTypeAdapter(this.constructorConstructor, gson, targetType, annotation2);
    }

    TypeAdapter<?> getTypeAdapter(ConstructorConstructor constructorConstructor, Gson gson, TypeToken<?> type, JsonAdapter annotation2) {
        TypeAdapter<?> typeAdapter;
        Object instance2 = constructorConstructor.get(TypeToken.get(annotation2.value())).construct();
        if (instance2 instanceof TypeAdapter) {
            typeAdapter = (TypeAdapter<?>)instance2;
        } else if (instance2 instanceof TypeAdapterFactory) {
            typeAdapter = ((TypeAdapterFactory)instance2).create(gson, type);
        } else if (instance2 instanceof JsonSerializer || instance2 instanceof JsonDeserializer) {
            JsonSerializer serializer2 = instance2 instanceof JsonSerializer ? (JsonSerializer)instance2 : null;
            JsonDeserializer deserializer = instance2 instanceof JsonDeserializer ? (JsonDeserializer)instance2 : null;
            typeAdapter = new TreeTypeAdapter(serializer2, deserializer, gson, type, null);
        } else {
            throw new IllegalArgumentException("Invalid attempt to bind an instance of " + instance2.getClass().getName() + " as a @JsonAdapter for " + type.toString() + ". @JsonAdapter value must be a TypeAdapter, TypeAdapterFactory, JsonSerializer or JsonDeserializer.");
        }
        if (typeAdapter != null && annotation2.nullSafe()) {
            typeAdapter = typeAdapter.nullSafe();
        }
        return typeAdapter;
    }
}

