/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.mixinextras.injector;

import gg.essential.lib.mixinextras.injector.StackExtension;
import gg.essential.lib.mixinextras.utils.ASMUtils;
import gg.essential.lib.mixinextras.utils.CompatibilityHelper;
import gg.essential.lib.mixinextras.utils.InjectorUtils;
import gg.essential.lib.mixinextras.utils.MixinExtrasLogger;
import java.util.function.Supplier;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.spongepowered.asm.mixin.injection.code.Injector;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.mixin.injection.struct.InjectionNodes;
import org.spongepowered.asm.mixin.injection.struct.Target;
import org.spongepowered.asm.util.Bytecode;

public class ModifyExpressionValueInjector
extends Injector {
    private static final MixinExtrasLogger LOGGER = MixinExtrasLogger.get("ModifyExpressionValue");

    public ModifyExpressionValueInjector(InjectionInfo info) {
        super(info, "@ModifyExpressionValue");
    }

    protected void inject(Target target2, InjectionNodes.InjectionNode node2) {
        this.checkTargetReturnsAValue(target2, node2);
        this.checkTargetModifiers(target2, false);
        StackExtension stack = new StackExtension(target2);
        AbstractInsnNode valueNode = node2.getCurrentTarget();
        Type valueType = this.getReturnType(valueNode);
        boolean shouldPop = false;
        if (valueNode instanceof TypeInsnNode && valueNode.getOpcode() == 187) {
            if (!InjectorUtils.isDupedNew(node2)) {
                target2.insns.insert(valueNode, (AbstractInsnNode)new InsnNode(89));
                stack.extra(1);
                node2.decorate("mixinextras_newIsDuped", (Object)true);
                shouldPop = true;
            }
            valueNode = ASMUtils.findInitNodeFor(target2, (TypeInsnNode)valueNode);
        }
        this.injectValueModifier(target2, valueNode, valueType, InjectorUtils.isDupedFactoryRedirect(node2), shouldPop, stack);
    }

    private void checkTargetReturnsAValue(Target target2, InjectionNodes.InjectionNode node2) {
        Type returnType = this.getReturnType(node2.getCurrentTarget());
        if (returnType == Type.VOID_TYPE) {
            throw CompatibilityHelper.makeInvalidInjectionException(this.info, String.format("%s annotation is targeting an instruction with a return type of 'void' in %s in %s", new Object[]{this.annotationType, target2, this}));
        }
        if (returnType == null) {
            throw CompatibilityHelper.makeInvalidInjectionException(this.info, String.format("%s annotation is targeting an invalid insn in %s in %s", new Object[]{this.annotationType, target2, this}));
        }
    }

    private void injectValueModifier(Target target2, AbstractInsnNode valueNode, Type valueType, boolean isDupedFactoryRedirect, boolean shouldPop, StackExtension stack) {
        InsnList after = new InsnList();
        this.invokeHandler(valueType, target2, after, stack);
        if (shouldPop) {
            after.add((AbstractInsnNode)new InsnNode(87));
        }
        target2.insns.insert(this.getInsertionPoint(valueNode, target2, isDupedFactoryRedirect), after);
    }

    private void invokeHandler(Type valueType, Target target2, InsnList after, StackExtension stack) {
        Injector.InjectorData handler = new Injector.InjectorData(target2, "expression value modifier");
        this.validateParams(handler, valueType, new Type[]{valueType});
        if (!this.isStatic) {
            after.add((AbstractInsnNode)new VarInsnNode(25, 0));
            if (valueType.getSize() == 2) {
                stack.extra(1);
                after.add((AbstractInsnNode)new InsnNode(91));
                after.add((AbstractInsnNode)new InsnNode(87));
            } else {
                after.add((AbstractInsnNode)new InsnNode(95));
            }
        }
        if (handler.captureTargetArgs > 0) {
            this.pushArgs(target2.arguments, after, target2.getArgIndices(), 0, handler.captureTargetArgs);
        }
        stack.receiver(this.isStatic);
        stack.capturedArgs(target2.arguments, handler.captureTargetArgs);
        this.invokeHandler(after);
    }

    private AbstractInsnNode getInsertionPoint(AbstractInsnNode valueNode, Target target2, boolean isDupedFactoryRedirect) {
        if (!isDupedFactoryRedirect) {
            return valueNode;
        }
        AbstractInsnNode node2 = InjectorUtils.findFactoryRedirectThrowString(target2, valueNode);
        if (node2 == null) {
            return valueNode;
        }
        String message2 = (String)((LdcInsnNode)node2).cst;
        Supplier<AbstractInsnNode> failed = () -> {
            LOGGER.warn("Please inform LlamaLad7! Failed to find end of factory redirect throw for '{}'", message2);
            return valueNode;
        };
        if ((node2 = node2.getNext()).getOpcode() != 183) {
            return failed.get();
        }
        if ((node2 = node2.getNext()).getOpcode() != 191) {
            return failed.get();
        }
        if (!((node2 = node2.getNext()) instanceof LabelNode)) {
            return failed.get();
        }
        return node2;
    }

    private Type getReturnType(AbstractInsnNode node2) {
        if (node2 instanceof MethodInsnNode) {
            MethodInsnNode methodInsnNode = (MethodInsnNode)node2;
            return Type.getReturnType((String)methodInsnNode.desc);
        }
        if (node2 instanceof FieldInsnNode) {
            FieldInsnNode fieldInsnNode = (FieldInsnNode)node2;
            if (fieldInsnNode.getOpcode() == 180 || fieldInsnNode.getOpcode() == 178) {
                return Type.getType((String)fieldInsnNode.desc);
            }
            return Type.VOID_TYPE;
        }
        if (Bytecode.isConstant((AbstractInsnNode)node2)) {
            return Bytecode.getConstantType((AbstractInsnNode)node2);
        }
        if (node2 instanceof TypeInsnNode && node2.getOpcode() == 187) {
            TypeInsnNode typeInsnNode = (TypeInsnNode)node2;
            return Type.getObjectType((String)typeInsnNode.desc);
        }
        return null;
    }
}

