/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.mixinextras.sugar.impl.handlers;

import gg.essential.lib.mixinextras.injector.wrapoperation.WrapOperation;
import gg.essential.lib.mixinextras.service.MixinExtrasService;
import gg.essential.lib.mixinextras.sugar.impl.SugarParameter;
import gg.essential.lib.mixinextras.sugar.impl.handlers.HandlerInfo;
import gg.essential.lib.mixinextras.sugar.impl.handlers.HandlerTransformer;
import gg.essential.lib.mixinextras.sugar.impl.ref.LocalRefUtils;
import gg.essential.lib.mixinextras.utils.ASMUtils;
import gg.essential.lib.mixinextras.wrapper.factory.FactoryRedirectWrapper;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.MethodNode;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;

class LocalHandlerTransformer
extends HandlerTransformer {
    private static final Set<String> TARGET_INJECTORS = new HashSet<String>(Arrays.asList(Type.getDescriptor(ModifyConstant.class), Type.getDescriptor(Redirect.class), Type.getDescriptor(FactoryRedirectWrapper.class)));

    LocalHandlerTransformer(IMixinInfo mixin, SugarParameter parameter) {
        super(mixin, parameter);
    }

    @Override
    public boolean isRequired(MethodNode handler) {
        AnnotationNode annotation2 = InjectionInfo.getInjectorAnnotation((IMixinInfo)this.mixin, (MethodNode)handler);
        return annotation2 != null && TARGET_INJECTORS.contains(annotation2.desc) && LocalRefUtils.getTargetType(this.parameter.type, this.parameter.genericType) == this.parameter.type;
    }

    @Override
    public void transform(HandlerInfo info) {
        Type wrapperType = Type.getType(LocalRefUtils.getInterfaceFor(this.parameter.type));
        info.wrapParameter(this.parameter, wrapperType, ASMUtils.isPrimitive(this.parameter.type) ? null : this.parameter.type, (insns, load) -> LocalRefUtils.generateUnwrapping(insns, this.parameter.type, load));
    }

    static {
        for (String name2 : MixinExtrasService.getInstance().getAllClassNames(WrapOperation.class.getName())) {
            TARGET_INJECTORS.add('L' + name2.replace('.', '/') + ';');
        }
    }
}

