/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.lib.okhttp3.internal.cache;

import gg.essential.lib.okhttp3.Headers;
import gg.essential.lib.okhttp3.Interceptor;
import gg.essential.lib.okhttp3.Protocol;
import gg.essential.lib.okhttp3.Request;
import gg.essential.lib.okhttp3.Response;
import gg.essential.lib.okhttp3.internal.Internal;
import gg.essential.lib.okhttp3.internal.Util;
import gg.essential.lib.okhttp3.internal.cache.CacheRequest;
import gg.essential.lib.okhttp3.internal.cache.CacheStrategy;
import gg.essential.lib.okhttp3.internal.cache.InternalCache;
import gg.essential.lib.okhttp3.internal.http.HttpHeaders;
import gg.essential.lib.okhttp3.internal.http.HttpMethod;
import gg.essential.lib.okhttp3.internal.http.RealResponseBody;
import gg.essential.lib.okio.Buffer;
import gg.essential.lib.okio.BufferedSink;
import gg.essential.lib.okio.BufferedSource;
import gg.essential.lib.okio.Okio;
import gg.essential.lib.okio.Sink;
import gg.essential.lib.okio.Source;
import gg.essential.lib.okio.Timeout;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public final class CacheInterceptor
implements Interceptor {
    final InternalCache cache;

    public CacheInterceptor(InternalCache cache) {
        this.cache = cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Response cacheCandidate = this.cache != null ? this.cache.get(chain.request()) : null;
        long now2 = System.currentTimeMillis();
        CacheStrategy strategy = new CacheStrategy.Factory(now2, chain.request(), cacheCandidate).get();
        Request networkRequest = strategy.networkRequest;
        Response cacheResponse = strategy.cacheResponse;
        if (this.cache != null) {
            this.cache.trackResponse(strategy);
        }
        if (cacheCandidate != null && cacheResponse == null) {
            Util.closeQuietly(cacheCandidate.body());
        }
        if (networkRequest == null && cacheResponse == null) {
            return new Response.Builder().request(chain.request()).protocol(Protocol.HTTP_1_1).code(504).message("Unsatisfiable Request (only-if-cached)").body(Util.EMPTY_RESPONSE).sentRequestAtMillis(-1L).receivedResponseAtMillis(System.currentTimeMillis()).build();
        }
        if (networkRequest == null) {
            return cacheResponse.newBuilder().cacheResponse(CacheInterceptor.stripBody(cacheResponse)).build();
        }
        Response networkResponse = null;
        try {
            networkResponse = chain.proceed(networkRequest);
        }
        finally {
            if (networkResponse == null && cacheCandidate != null) {
                Util.closeQuietly(cacheCandidate.body());
            }
        }
        if (cacheResponse != null) {
            if (networkResponse.code() == 304) {
                Response response2 = cacheResponse.newBuilder().headers(CacheInterceptor.combine(cacheResponse.headers(), networkResponse.headers())).sentRequestAtMillis(networkResponse.sentRequestAtMillis()).receivedResponseAtMillis(networkResponse.receivedResponseAtMillis()).cacheResponse(CacheInterceptor.stripBody(cacheResponse)).networkResponse(CacheInterceptor.stripBody(networkResponse)).build();
                networkResponse.body().close();
                this.cache.trackConditionalCacheHit();
                this.cache.update(cacheResponse, response2);
                return response2;
            }
            Util.closeQuietly(cacheResponse.body());
        }
        Response response3 = networkResponse.newBuilder().cacheResponse(CacheInterceptor.stripBody(cacheResponse)).networkResponse(CacheInterceptor.stripBody(networkResponse)).build();
        if (this.cache != null) {
            if (HttpHeaders.hasBody(response3) && CacheStrategy.isCacheable(response3, networkRequest)) {
                CacheRequest cacheRequest = this.cache.put(response3);
                return this.cacheWritingResponse(cacheRequest, response3);
            }
            if (HttpMethod.invalidatesCache(networkRequest.method())) {
                try {
                    this.cache.remove(networkRequest);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return response3;
    }

    private static Response stripBody(Response response2) {
        return response2 != null && response2.body() != null ? response2.newBuilder().body(null).build() : response2;
    }

    private Response cacheWritingResponse(final CacheRequest cacheRequest, Response response2) throws IOException {
        if (cacheRequest == null) {
            return response2;
        }
        Sink cacheBodyUnbuffered = cacheRequest.body();
        if (cacheBodyUnbuffered == null) {
            return response2;
        }
        final BufferedSource source = response2.body().source();
        final BufferedSink cacheBody = Okio.buffer(cacheBodyUnbuffered);
        Source cacheWritingSource = new Source(){
            boolean cacheRequestClosed;

            @Override
            public long read(Buffer sink, long byteCount) throws IOException {
                long bytesRead;
                try {
                    bytesRead = source.read(sink, byteCount);
                }
                catch (IOException e) {
                    if (!this.cacheRequestClosed) {
                        this.cacheRequestClosed = true;
                        cacheRequest.abort();
                    }
                    throw e;
                }
                if (bytesRead == -1L) {
                    if (!this.cacheRequestClosed) {
                        this.cacheRequestClosed = true;
                        cacheBody.close();
                    }
                    return -1L;
                }
                sink.copyTo(cacheBody.buffer(), sink.size() - bytesRead, bytesRead);
                cacheBody.emitCompleteSegments();
                return bytesRead;
            }

            @Override
            public Timeout timeout() {
                return source.timeout();
            }

            @Override
            public void close() throws IOException {
                if (!this.cacheRequestClosed && !Util.discard(this, 100, TimeUnit.MILLISECONDS)) {
                    this.cacheRequestClosed = true;
                    cacheRequest.abort();
                }
                source.close();
            }
        };
        String contentType = response2.header("Content-Type");
        long contentLength = response2.body().contentLength();
        return response2.newBuilder().body(new RealResponseBody(contentType, contentLength, Okio.buffer(cacheWritingSource))).build();
    }

    private static Headers combine(Headers cachedHeaders, Headers networkHeaders) {
        String fieldName;
        int i2;
        Headers.Builder result = new Headers.Builder();
        int size = cachedHeaders.size();
        for (i2 = 0; i2 < size; ++i2) {
            fieldName = cachedHeaders.name(i2);
            String value = cachedHeaders.value(i2);
            if ("Warning".equalsIgnoreCase(fieldName) && value.startsWith("1") || CacheInterceptor.isEndToEnd(fieldName) && networkHeaders.get(fieldName) != null) continue;
            Internal.instance.addLenient(result, fieldName, value);
        }
        size = networkHeaders.size();
        for (i2 = 0; i2 < size; ++i2) {
            fieldName = networkHeaders.name(i2);
            if ("Content-Length".equalsIgnoreCase(fieldName) || !CacheInterceptor.isEndToEnd(fieldName)) continue;
            Internal.instance.addLenient(result, fieldName, networkHeaders.value(i2));
        }
        return result.build();
    }

    static boolean isEndToEnd(String fieldName) {
        return !"Connection".equalsIgnoreCase(fieldName) && !"Keep-Alive".equalsIgnoreCase(fieldName) && !"Proxy-Authenticate".equalsIgnoreCase(fieldName) && !"Proxy-Authorization".equalsIgnoreCase(fieldName) && !"TE".equalsIgnoreCase(fieldName) && !"Trailers".equalsIgnoreCase(fieldName) && !"Transfer-Encoding".equalsIgnoreCase(fieldName) && !"Upgrade".equalsIgnoreCase(fieldName);
    }
}

