/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.mixins.transformers.client;

import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.minecraft.UserApiService;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import gg.essential.Essential;
import gg.essential.event.client.ReAuthEvent;
import gg.essential.event.gui.GuiOpenEvent;
import gg.essential.event.gui.GuiOpenedEvent;
import gg.essential.mixins.ext.server.integrated.IntegratedServerExt;
import gg.essential.mixins.impl.client.MinecraftExt;
import gg.essential.mixins.impl.client.MinecraftHook;
import gg.essential.sps.McIntegratedServerManager;
import gg.essential.universal.UMinecraft;
import gg.essential.util.HelpersKt;
import java.io.File;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.User;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.social.PlayerSocialManager;
import net.minecraft.client.multiplayer.AccountProfileKeyPairManager;
import net.minecraft.client.multiplayer.ProfileKeyPairManager;
import net.minecraft.client.server.IntegratedServer;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Minecraft.class})
public abstract class MixinMinecraft
implements MinecraftExt {
    private final MinecraftHook minecraftHook = new MinecraftHook((Minecraft)this);
    private GuiOpenEvent guiOpenEvent;
    @Shadow
    @Mutable
    @Final
    private User f_90998_;
    @Shadow
    @Mutable
    @Final
    private PlayerSocialManager f_91006_;
    @Shadow
    @Mutable
    @Final
    private YggdrasilAuthenticationService f_231338_;
    @Shadow
    @Mutable
    @Final
    private ProfileKeyPairManager f_231337_;
    @Shadow
    @Final
    public File f_91069_;
    @Shadow
    @Mutable
    @Final
    private UserApiService f_193584_;
    @Shadow
    @Nullable
    private IntegratedServer f_91007_;
    private static final String LAUNCH_INTEGRATED_SERVER = "doWorldLoad";
    private static final String STOP_INTEGRATED_SERVER = "clearLevel(Lnet/minecraft/client/gui/screens/Screen;)V";

    @Shadow
    public abstract PropertyMap m_91095_();

    @Inject(method={"<init>"}, at={@At(value="ESSENTIAL:CONSTANT_IN_INIT", args={"stringValue=Backend library: {}"})})
    private void preinit(CallbackInfo ci) {
        this.minecraftHook.preinit();
    }

    @Inject(method={"<init>"}, at={@At(value="ESSENTIAL:AFTER_INVOKE_IN_INIT", target="Lnet/minecraft/client/Minecraft;resizeDisplay()V")})
    private void init(CallbackInfo ci) {
        this.minecraftHook.startGame();
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void postInit(CallbackInfo ci) {
        this.minecraftHook.postInit();
    }

    @Inject(method={"tick"}, at={@At(value="RETURN")})
    private void runTick(CallbackInfo ci) {
        this.minecraftHook.runTick();
    }

    @Inject(method={"clearLevel(Lnet/minecraft/client/gui/screens/Screen;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;dropAllTasks()V", shift=At.Shift.AFTER)})
    private void unloadWorld(CallbackInfo ci) {
        this.minecraftHook.disconnect();
    }

    @Inject(method={"stop"}, at={@At(value="HEAD")})
    private void shutdown(CallbackInfo ci) {
        this.minecraftHook.shutdown();
    }

    @Inject(method={"setScreen"}, at={@At(value="HEAD")})
    private void checkThreadSafety(CallbackInfo ci) {
        if (!UMinecraft.isCallingFromMinecraftThread()) {
            Essential.logger.error("Detected call to `openScreen` on thread {}. This method is NOT thread safe and MUST NOT be called from any thread except the main client thread! Please report this to the mod responsible as per the following stacktrace:", (Object)Thread.currentThread(), (Object)new Throwable());
        }
    }

    @ModifyVariable(method={"setScreen"}, at=@At(value="HEAD"))
    public Screen displayGuiScreen(Screen screen) {
        this.guiOpenEvent = this.minecraftHook.displayGuiScreen(screen);
        return this.guiOpenEvent.getGui();
    }

    @Inject(method={"setScreen"}, at={@At(value="HEAD")}, cancellable=true)
    public void displayGuiScreen(Screen screen, CallbackInfo info) {
        if (this.guiOpenEvent != null && this.guiOpenEvent.isCancelled()) {
            info.cancel();
        }
    }

    @Inject(method={"setScreen"}, at={@At(value="TAIL")})
    public void essential$fireGuiOpenedEvent(Screen screen, CallbackInfo info) {
        if (screen == null) {
            return;
        }
        Essential.EVENT_BUS.post(new GuiOpenedEvent(screen));
    }

    @Override
    public void setSession(User session) {
        User oldSession = this.f_90998_;
        this.f_90998_ = session;
        if (!Objects.equals(oldSession.m_92548_().getId(), session.m_92548_().getId())) {
            this.m_91095_().clear();
        }
        YggdrasilAuthenticationService authenticationService = this.f_231338_;
        try {
            this.f_193584_ = authenticationService.createUserApiService(session.m_92547_());
        }
        catch (AuthenticationException e) {
            Essential.logger.error("Failed to verify authentication", (Throwable)e);
            this.f_193584_ = UserApiService.OFFLINE;
        }
        this.f_91006_ = new PlayerSocialManager((Minecraft)this, this.f_193584_);
        this.f_231337_ = new AccountProfileKeyPairManager(this.f_193584_, session.m_92548_().getId(), this.f_91069_.toPath());
        Essential.EVENT_BUS.post(new ReAuthEvent(HelpersKt.toUSession(session)));
    }

    @Inject(method={"doWorldLoad"}, at={@At(value="FIELD", target="Lnet/minecraft/client/Minecraft;singleplayerServer:Lnet/minecraft/client/server/IntegratedServer;", shift=At.Shift.AFTER)})
    private void setIntegratedServerManager(CallbackInfo ci) {
        IntegratedServerExt ext = (IntegratedServerExt)this.f_91007_;
        assert (ext != null);
        Essential.getInstance().getIntegratedServerManager().set(ext.getEssential$manager());
    }

    @Inject(method={"clearLevel(Lnet/minecraft/client/gui/screens/Screen;)V"}, at={@At(value="FIELD", target="Lnet/minecraft/client/Minecraft;singleplayerServer:Lnet/minecraft/client/server/IntegratedServer;", shift=At.Shift.AFTER)})
    private void unsetIntegratedServerManager(CallbackInfo ci) {
        Essential.getInstance().getIntegratedServerManager().set((McIntegratedServerManager)null);
    }
}

