/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.mixins.transformers.client.gui.drag_drop_gui;

import gg.essential.config.EssentialConfig;
import gg.essential.lib.mixinextras.injector.ModifyExpressionValue;
import gg.essential.lib.mixinextras.sugar.Share;
import gg.essential.lib.mixinextras.sugar.ref.LocalBooleanRef;
import gg.essential.lib.mixinextras.sugar.ref.LocalDoubleRef;
import gg.essential.mixins.impl.client.gui.EssentialGuiDraggableEntryScreen;
import gg.essential.mixins.impl.client.gui.GuiDragDropEntryHandler;
import gg.essential.mixins.transformers.client.gui.GuiMultiplayerAccessor;
import gg.essential.mixins.transformers.client.gui.ServerSelectionListAccessor;
import gg.essential.universal.USound;
import java.util.List;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.gui.screens.multiplayer.ServerSelectionList;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ServerSelectionList.OnlineServerEntry.class})
public abstract class Mixin_DragDropUI_ServerListEntry {
    @Unique
    private static final String MOUSE_CLICKED = "mouseClicked";
    @Shadow
    @Final
    private JoinMultiplayerScreen f_99855_;

    @Inject(method={"mouseClicked"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/multiplayer/JoinMultiplayerScreen;joinSelectedServer()V", shift=At.Shift.AFTER)})
    private void playSoundAfterConnect(CallbackInfoReturnable<Boolean> cir, @Share(value="serverConnection") LocalBooleanRef serverConnection) {
        if (EssentialConfig.INSTANCE.getEssentialEnabled()) {
            USound.INSTANCE.playButtonPress();
            serverConnection.set(true);
        }
    }

    @Inject(method={"mouseClicked"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/multiplayer/ServerSelectionList$OnlineServerEntry;swap(II)V", shift=At.Shift.AFTER)})
    private void playSoundAfterMove(CallbackInfoReturnable<Boolean> cir) {
        if (EssentialConfig.INSTANCE.getEssentialEnabled()) {
            USound.INSTANCE.playButtonPress();
        }
    }

    @ModifyVariable(method={"mouseClicked"}, at=@At(value="STORE"), ordinal=2)
    private double captureRelativeMouseCoordinatesX(double value, @Share(value="relativeX") LocalDoubleRef relativeXSet) {
        if (EssentialConfig.INSTANCE.getEssentialEnabled()) {
            relativeXSet.set(value);
        }
        return value;
    }

    @ModifyVariable(method={"mouseClicked"}, at=@At(value="STORE"), ordinal=3)
    private double captureRelativeMouseCoordinatesY(double value, @Share(value="relativeY") LocalDoubleRef relativeYSet) {
        if (EssentialConfig.INSTANCE.getEssentialEnabled()) {
            relativeYSet.set(value);
        }
        return value;
    }

    @Inject(method={"mouseClicked"}, at={@At(value="INVOKE", target="Lnet/minecraft/Util;getMillis()J", ordinal=1)})
    private void grabHoverEntry(double mouseX, double mouseY, int button2, CallbackInfoReturnable<Boolean> cir, @Share(value="serverConnection") LocalBooleanRef serverConnection, @Share(value="relativeX") LocalDoubleRef relativeXGet, @Share(value="relativeY") LocalDoubleRef relativeYGet) {
        if (EssentialConfig.INSTANCE.getCurrentMultiplayerTab() != 0) {
            return;
        }
        if (serverConnection.get()) {
            return;
        }
        GuiDragDropEntryHandler<ServerSelectionList.OnlineServerEntry> dragHandler = ((EssentialGuiDraggableEntryScreen)this.f_99855_).essential$getDragHandlerOrNull();
        if (dragHandler != null && !dragHandler.isDraggingEntry()) {
            ServerSelectionList.OnlineServerEntry selectedEntry = (ServerSelectionList.OnlineServerEntry)this;
            ServerSelectionList serverListSelector = ((GuiMultiplayerAccessor)this.f_99855_).getServerListSelector();
            List<ServerSelectionList.OnlineServerEntry> container2 = ((ServerSelectionListAccessor)serverListSelector).getServerListInternet();
            if (!container2.contains(selectedEntry)) {
                return;
            }
            int slotIndex = container2.indexOf(selectedEntry);
            double relativeX = relativeXGet.get();
            double relativeY = relativeYGet.get();
            dragHandler.setPendingDraggedEntryState(selectedEntry, container2, relativeX, relativeY, slotIndex, mouseX, mouseY, true);
        }
    }

    @ModifyVariable(method={"render"}, at=@At(value="HEAD"), ordinal=0, argsOnly=true)
    private boolean hideSelectionVisuals(boolean isSelected2) {
        GuiDragDropEntryHandler dragHandler = ((EssentialGuiDraggableEntryScreen)this.f_99855_).essential$getDragHandlerOrNull();
        if (dragHandler != null && dragHandler.isDraggingEntry()) {
            return false;
        }
        return isSelected2;
    }

    @ModifyExpressionValue(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/OptionInstance;get()Ljava/lang/Object;")})
    private Object hideSelectionVisualsTouchscreen(Object touchscreen) {
        GuiDragDropEntryHandler dragHandler = ((EssentialGuiDraggableEntryScreen)this.f_99855_).essential$getDragHandlerOrNull();
        if (dragHandler != null && dragHandler.isDraggingEntry()) {
            return false;
        }
        return touchscreen;
    }
}

