/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.mixins.transformers.client.network;

import gg.essential.Essential;
import gg.essential.event.network.chat.SendChatMessageEvent;
import gg.essential.event.network.chat.SendCommandEvent;
import gg.essential.mixins.transformers.client.network.CPacketChatMessageAccessor;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundChatCommandPacket;
import net.minecraft.network.protocol.game.ServerboundChatPacket;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ClientPacketListener.class})
public abstract class Mixin_SendChatEvents {
    @Inject(method={"send(Lnet/minecraft/network/protocol/Packet;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void chat(Packet<?> packetIn, CallbackInfo ci) {
        if (packetIn instanceof ServerboundChatPacket) {
            String orgMessage = ((ServerboundChatPacket)packetIn).f_133827_();
            String newMessage = this.emitSendChatMessageEvent(orgMessage);
            if (newMessage != null) {
                ((CPacketChatMessageAccessor)packetIn).setMessage(newMessage);
            } else {
                ci.cancel();
            }
        }
        if (packetIn instanceof ServerboundChatCommandPacket) {
            ServerboundChatCommandPacket packet = (ServerboundChatCommandPacket)packetIn;
            SendCommandEvent event = new SendCommandEvent(packet.f_237922_());
            Essential.EVENT_BUS.post(event);
            if (event.isCancelled()) {
                ci.cancel();
            }
        }
    }

    @Unique
    private String emitSendChatMessageEvent(String message2) {
        if (message2.startsWith("/")) {
            SendCommandEvent event = new SendCommandEvent(message2.substring(1));
            Essential.EVENT_BUS.post(event);
            return event.isCancelled() ? null : "/" + event.getCommandLine();
        }
        SendChatMessageEvent event = new SendChatMessageEvent(message2);
        Essential.EVENT_BUS.post(event);
        return event.isCancelled() ? null : event.getMessage();
    }
}

