/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.model;

import gg.essential.lib.kotgl.matrix.vectors.Vec3;
import gg.essential.model.AnimationKt;
import gg.essential.model.Keyframe;
import gg.essential.model.file.KeyframesSerializer;
import gg.essential.model.molang.MolangContext;
import gg.essential.model.molang.MolangQuery;
import gg.essential.model.molang.MolangQueryAnimation;
import gg.essential.model.molang.MolangVec3;
import gg.essential.model.util.TreeMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable(with=KeyframesSerializer.class)
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0087\b\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0003J\u001f\u0010\n\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0017"}, d2={"Lgg/essential/model/Keyframes;", "", "frames", "Lgg/essential/model/util/TreeMap;", "", "Lgg/essential/model/Keyframe;", "(Lgg/essential/model/util/TreeMap;)V", "getFrames", "()Lgg/essential/model/util/TreeMap;", "component1", "copy", "equals", "", "other", "eval", "Lgg/essential/lib/kotgl/matrix/vectors/Vec3;", "context", "Lgg/essential/model/molang/MolangContext;", "hashCode", "", "toString", "", "Companion", "cosmetics"})
public final class Keyframes {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TreeMap<Float, Keyframe> frames;

    public Keyframes(@NotNull TreeMap<Float, Keyframe> frames) {
        Intrinsics.checkNotNullParameter(frames, (String)"frames");
        this.frames = frames;
    }

    @NotNull
    public final TreeMap<Float, Keyframe> getFrames() {
        return this.frames;
    }

    @NotNull
    public final Vec3 eval(@NotNull MolangContext context) {
        Vec3 vec3;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        MolangQuery molangQuery = context.getQuery();
        MolangQueryAnimation molangQueryAnimation = molangQuery instanceof MolangQueryAnimation ? (MolangQueryAnimation)molangQuery : null;
        float animTime = molangQueryAnimation != null ? molangQueryAnimation.getAnimLoopTime() : 0.0f;
        Map.Entry<Float, Keyframe> floor = this.frames.floorEntry((Float)((Comparable)Float.valueOf(animTime)));
        Map.Entry<Float, Keyframe> ceil = this.frames.ceilingEntry((Float)((Comparable)Float.valueOf(animTime)));
        Map.Entry<Float, Keyframe> entry = floor;
        Vec3 floorValue = entry != null && (entry = entry.getValue()) != null && (entry = ((Keyframe)((Object)entry)).getPost()) != null ? ((MolangVec3)((Object)entry)).eval(context) : null;
        Map.Entry<Float, Keyframe> entry2 = ceil;
        Vec3 ceilValue = entry2 != null && (entry2 = entry2.getValue()) != null && (entry2 = ((Keyframe)((Object)entry2)).getPre()) != null ? ((MolangVec3)((Object)entry2)).eval(context) : null;
        if (floorValue == null) {
            Vec3 vec32 = ceilValue;
            vec3 = vec32;
            Intrinsics.checkNotNull((Object)vec32);
        } else if (ceilValue == null) {
            vec3 = floorValue;
        } else if (Intrinsics.areEqual(floor, ceil)) {
            vec3 = floorValue;
        } else if (floor.getValue().getSmooth() || ceil.getValue().getSmooth()) {
            Object object;
            Map.Entry<Float, Keyframe> beforeFloorValue;
            Map.Entry<Float, Keyframe> beforeFloor = this.frames.lowerEntry((Float)((Comparable)floor.getKey()));
            Map.Entry<Float, Keyframe> afterCeil = this.frames.higherEntry((Float)((Comparable)ceil.getKey()));
            Map.Entry<Float, Keyframe> entry3 = beforeFloor;
            if (entry3 == null || (entry3 = entry3.getValue()) == null || (entry3 = ((Keyframe)((Object)entry3)).getPost()) == null || (entry3 = ((MolangVec3)((Object)entry3)).eval(context)) == null) {
                entry3 = beforeFloorValue = floorValue;
            }
            if ((object = afterCeil) == null || (object = object.getValue()) == null || (object = ((Keyframe)object).getPost()) == null || (object = ((MolangVec3)object).eval(context)) == null) {
                object = ceilValue;
            }
            Object afterCeilValue = object;
            float t = (animTime - ((Number)floor.getKey()).floatValue()) / (((Number)ceil.getKey()).floatValue() - ((Number)floor.getKey()).floatValue());
            vec3 = AnimationKt.catmullRom(t, (Vec3)((Object)beforeFloorValue), floorValue, ceilValue, (Vec3)afterCeilValue);
        } else {
            vec3 = Intrinsics.areEqual((Object)floorValue, (Object)ceilValue) ? floorValue : AnimationKt.lerp(floorValue, ceilValue, (animTime - ((Number)floor.getKey()).floatValue()) / (((Number)ceil.getKey()).floatValue() - ((Number)floor.getKey()).floatValue()));
        }
        return vec3;
    }

    @NotNull
    public final TreeMap<Float, Keyframe> component1() {
        return this.frames;
    }

    @NotNull
    public final Keyframes copy(@NotNull TreeMap<Float, Keyframe> frames) {
        Intrinsics.checkNotNullParameter(frames, (String)"frames");
        return new Keyframes(frames);
    }

    public static /* synthetic */ Keyframes copy$default(Keyframes keyframes, TreeMap treeMap, int n, Object object) {
        if ((n & 1) != 0) {
            treeMap = keyframes.frames;
        }
        return keyframes.copy(treeMap);
    }

    @NotNull
    public String toString() {
        return "Keyframes(frames=" + this.frames + ')';
    }

    public int hashCode() {
        return this.frames.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Keyframes)) {
            return false;
        }
        Keyframes keyframes = (Keyframes)other;
        return Intrinsics.areEqual(this.frames, keyframes.frames);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0001\u00a8\u0006\u0006"}, d2={"Lgg/essential/model/Keyframes$Companion;", "", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lgg/essential/model/Keyframes;", "cosmetics"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KSerializer<Keyframes> serializer() {
            return new KeyframesSerializer();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

