/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.network.connectionmanager.cosmetics;

import gg.essential.cosmetics.skinmask.SkinMask;
import gg.essential.mod.EssentialAsset;
import gg.essential.mod.Model;
import gg.essential.mod.cosmetics.CosmeticAssets;
import gg.essential.model.AnimatedCape;
import gg.essential.model.BedrockModel;
import gg.essential.model.Side;
import gg.essential.model.backend.RenderBackend;
import gg.essential.model.file.AnimationFile;
import gg.essential.model.file.ModelFile;
import gg.essential.model.file.ParticlesFile;
import gg.essential.model.file.SoundDefinitionsFile;
import gg.essential.network.connectionmanager.cosmetics.AssetLoader;
import gg.essential.network.connectionmanager.cosmetics.ModelLoader;
import gg.essential.network.cosmetics.Cosmetic;
import gg.essential.util.UIdentifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001d2\u00020\u0001:\u0003\u001c\u001d\u001eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J0\u0010\u000b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J>\u0010\u0015\u001a\"\u0012\u001e\u0012\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\f\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\f0\u00170\u00162\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0014J,\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00162\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J$\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00162\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0014J,\u0010\u001b\u001a\u00060\nR\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\b\u0012\u00060\bR\u00020\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\b\u0012\u00060\nR\u00020\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lgg/essential/network/connectionmanager/cosmetics/ModelLoader;", "", "assetLoader", "Lgg/essential/network/connectionmanager/cosmetics/AssetLoader;", "(Lgg/essential/network/connectionmanager/cosmetics/AssetLoader;)V", "capes", "", "", "Lgg/essential/network/connectionmanager/cosmetics/ModelLoader$CapeState;", "models", "Lgg/essential/network/connectionmanager/cosmetics/ModelLoader$ModelState;", "getAssets", "", "Lgg/essential/network/connectionmanager/cosmetics/AssetLoader$Asset;", "cosmetic", "Lgg/essential/network/cosmetics/Cosmetic;", "variant", "skinType", "Lgg/essential/mod/Model;", "priority", "Lgg/essential/network/connectionmanager/cosmetics/AssetLoader$Priority;", "getCape", "Ljava/util/concurrent/CompletableFuture;", "Lkotlin/Pair;", "Lgg/essential/util/UIdentifier;", "getModel", "Lgg/essential/model/BedrockModel;", "getModelState", "CapeState", "Companion", "ModelState", "essential-gui-essential"})
public final class ModelLoader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AssetLoader assetLoader;
    @NotNull
    private final Map<String, ModelState> models;
    @NotNull
    private final Map<String, CapeState> capes;
    private static final Logger LOGGER = LoggerFactory.getLogger(ModelLoader.class);

    public ModelLoader(@NotNull AssetLoader assetLoader) {
        Intrinsics.checkNotNullParameter((Object)assetLoader, (String)"assetLoader");
        this.assetLoader = assetLoader;
        this.models = new ConcurrentHashMap();
        this.capes = new ConcurrentHashMap();
    }

    private final ModelState getModelState(Cosmetic cosmetic2, String variant, Model skinType, AssetLoader.Priority priority) {
        String key = cosmetic2.getId() + '-' + variant + '-' + (Object)((Object)skinType);
        ModelState modelState = this.models.compute(key, (arg_0, arg_1) -> ModelLoader.getModelState$lambda$0((Function2)new Function2<String, ModelState, ModelState>(this, cosmetic2, variant, skinType){
            final /* synthetic */ ModelLoader this$0;
            final /* synthetic */ Cosmetic $cosmetic;
            final /* synthetic */ String $variant;
            final /* synthetic */ Model $skinType;
            {
                this.this$0 = $receiver;
                this.$cosmetic = $cosmetic;
                this.$variant = $variant;
                this.$skinType = $skinType;
                super(2);
            }

            @Nullable
            public final ModelState invoke(@NotNull String string, @Nullable ModelState state2) {
                ModelState modelState;
                block3: {
                    block2: {
                        Intrinsics.checkNotNullParameter((Object)string, (String)"<anonymous parameter 0>");
                        modelState = state2;
                        if (modelState == null) break block2;
                        ModelState modelState2 = modelState;
                        Cosmetic cosmetic2 = this.$cosmetic;
                        ModelState it = modelState2;
                        boolean bl = false;
                        modelState = !(!Intrinsics.areEqual((Object)it.getCosmetic(), (Object)cosmetic2)) ? modelState2 : null;
                        if (modelState != null) break block3;
                    }
                    modelState = this.this$0.new ModelState(this.$cosmetic, this.$variant, this.$skinType);
                }
                return modelState;
            }
        }, arg_0, arg_1));
        Intrinsics.checkNotNull((Object)modelState);
        ModelState state2 = modelState;
        state2.ensurePriorityAtLeast(priority);
        return state2;
    }

    @NotNull
    public final CompletableFuture<BedrockModel> getModel(@NotNull Cosmetic cosmetic2, @NotNull String variant, @NotNull Model skinType, @NotNull AssetLoader.Priority priority) {
        Intrinsics.checkNotNullParameter((Object)cosmetic2, (String)"cosmetic");
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        Intrinsics.checkNotNullParameter((Object)((Object)skinType), (String)"skinType");
        Intrinsics.checkNotNullParameter((Object)((Object)priority), (String)"priority");
        return this.getModelState(cosmetic2, variant, skinType, priority).getFuture();
    }

    @NotNull
    public final CompletableFuture<BedrockModel> getModel(@NotNull Cosmetic cosmetic2, @NotNull String variant, @NotNull AssetLoader.Priority priority) {
        Intrinsics.checkNotNullParameter((Object)cosmetic2, (String)"cosmetic");
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        Intrinsics.checkNotNullParameter((Object)((Object)priority), (String)"priority");
        return this.getModel(cosmetic2, variant, Model.STEVE, priority);
    }

    @NotNull
    public final List<AssetLoader.Asset<?>> getAssets(@NotNull Cosmetic cosmetic2, @NotNull String variant, @NotNull Model skinType, @NotNull AssetLoader.Priority priority) {
        Intrinsics.checkNotNullParameter((Object)cosmetic2, (String)"cosmetic");
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        Intrinsics.checkNotNullParameter((Object)((Object)skinType), (String)"skinType");
        Intrinsics.checkNotNullParameter((Object)((Object)priority), (String)"priority");
        return this.getModelState(cosmetic2, variant, skinType, priority).getDependencies();
    }

    @NotNull
    public final CompletableFuture<Pair<List<UIdentifier>, List<UIdentifier>>> getCape(@NotNull Cosmetic cosmetic2, @NotNull String variant, @NotNull AssetLoader.Priority priority) {
        Intrinsics.checkNotNullParameter((Object)cosmetic2, (String)"cosmetic");
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        Intrinsics.checkNotNullParameter((Object)((Object)priority), (String)"priority");
        String key = cosmetic2.getId() + '-' + variant;
        CapeState capeState = this.capes.compute(key, (arg_0, arg_1) -> ModelLoader.getCape$lambda$1((Function2)new Function2<String, CapeState, CapeState>(this, cosmetic2, variant){
            final /* synthetic */ ModelLoader this$0;
            final /* synthetic */ Cosmetic $cosmetic;
            final /* synthetic */ String $variant;
            {
                this.this$0 = $receiver;
                this.$cosmetic = $cosmetic;
                this.$variant = $variant;
                super(2);
            }

            @Nullable
            public final CapeState invoke(@NotNull String string, @Nullable CapeState state2) {
                CapeState capeState;
                block3: {
                    block2: {
                        Intrinsics.checkNotNullParameter((Object)string, (String)"<anonymous parameter 0>");
                        capeState = state2;
                        if (capeState == null) break block2;
                        CapeState capeState2 = capeState;
                        Cosmetic cosmetic2 = this.$cosmetic;
                        CapeState it = capeState2;
                        boolean bl = false;
                        capeState = !(!Intrinsics.areEqual((Object)it.getCosmetic(), (Object)cosmetic2)) ? capeState2 : null;
                        if (capeState != null) break block3;
                    }
                    capeState = this.this$0.new CapeState(this.$cosmetic, this.$variant);
                }
                return capeState;
            }
        }, arg_0, arg_1));
        Intrinsics.checkNotNull((Object)capeState);
        CapeState state2 = capeState;
        state2.ensurePriorityAtLeast(priority);
        return state2.getFuture();
    }

    private static final ModelState getModelState$lambda$0(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ModelState)$tmp0.invoke(p0, p1);
    }

    private static final CapeState getCape$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (CapeState)$tmp0.invoke(p0, p1);
    }

    public static final /* synthetic */ Logger access$getLOGGER$cp() {
        return LOGGER;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R1\u0010\u000e\u001a\"\u0012\u001e\u0012\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00100\u000f0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0014\u001a\u0010\u0012\f\u0012\n \u0017*\u0004\u0018\u00010\u00160\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001f"}, d2={"Lgg/essential/network/connectionmanager/cosmetics/ModelLoader$CapeState;", "", "cosmetic", "Lgg/essential/network/cosmetics/Cosmetic;", "variant", "", "(Lgg/essential/network/connectionmanager/cosmetics/ModelLoader;Lgg/essential/network/cosmetics/Cosmetic;Ljava/lang/String;)V", "getCosmetic", "()Lgg/essential/network/cosmetics/Cosmetic;", "emissiveTextureAsset", "Lgg/essential/mod/EssentialAsset;", "emissiveTextureFuture", "Ljava/util/concurrent/CompletableFuture;", "", "future", "Lkotlin/Pair;", "", "Lgg/essential/util/UIdentifier;", "getFuture", "()Ljava/util/concurrent/CompletableFuture;", "priority", "Ljava/util/concurrent/atomic/AtomicReference;", "Lgg/essential/network/connectionmanager/cosmetics/AssetLoader$Priority;", "kotlin.jvm.PlatformType", "textureAsset", "textureFuture", "getVariant", "()Ljava/lang/String;", "ensurePriorityAtLeast", "", "atLeast", "essential-gui-essential"})
    @SourceDebugExtension(value={"SMAP\nModelLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModelLoader.kt\ngg/essential/network/connectionmanager/cosmetics/ModelLoader$CapeState\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,138:1\n1#2:139\n*E\n"})
    private final class CapeState {
        @NotNull
        private final Cosmetic cosmetic;
        @NotNull
        private final String variant;
        @NotNull
        private final EssentialAsset textureAsset;
        @Nullable
        private final EssentialAsset emissiveTextureAsset;
        @NotNull
        private final CompletableFuture<byte[]> textureFuture;
        @Nullable
        private final CompletableFuture<byte[]> emissiveTextureFuture;
        @NotNull
        private final CompletableFuture<Pair<List<UIdentifier>, List<UIdentifier>>> future;
        @NotNull
        private final AtomicReference<AssetLoader.Priority> priority;

        /*
         * WARNING - void declaration
         */
        public CapeState(@NotNull Cosmetic cosmetic2, String variant) {
            CompletionStage<Object> completionStage;
            CompletableFuture<byte[]> completableFuture;
            Intrinsics.checkNotNullParameter((Object)cosmetic2, (String)"cosmetic");
            Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
            this.cosmetic = cosmetic2;
            this.variant = variant;
            EssentialAsset essentialAsset = this.cosmetic.assets(this.variant).getTexture();
            Intrinsics.checkNotNull((Object)essentialAsset);
            this.textureAsset = essentialAsset;
            this.emissiveTextureAsset = this.cosmetic.assets(this.variant).getEmissiveTexture();
            this.textureFuture = ModelLoader.this.assetLoader.getAssetBytes(this.textureAsset, AssetLoader.Priority.Passive);
            CapeState capeState = this;
            EssentialAsset essentialAsset2 = this.emissiveTextureAsset;
            if (essentialAsset2 != null) {
                void it;
                EssentialAsset essentialAsset3 = essentialAsset2;
                ModelLoader modelLoader = ModelLoader.this;
                EssentialAsset essentialAsset4 = essentialAsset3;
                CapeState capeState2 = capeState;
                boolean bl = false;
                completableFuture = modelLoader.assetLoader.getAssetBytes((EssentialAsset)it, AssetLoader.Priority.Passive);
                capeState = capeState2;
            } else {
                completableFuture = null;
            }
            capeState.emissiveTextureFuture = completableFuture;
            CompletionStage completionStage2 = ((CompletableFuture)((CompletableFuture)this.textureFuture.thenCompose(arg_0 -> CapeState.future$lambda$1((Function1)new Function1<byte[], CompletionStage<List<? extends UIdentifier>>>(this){
                final /* synthetic */ CapeState this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final CompletionStage<List<UIdentifier>> invoke(byte[] textureBytes) {
                    Cosmetic cosmetic2 = this.this$0.getCosmetic();
                    EssentialAsset essentialAsset = CapeState.access$getTextureAsset$p(this.this$0);
                    Intrinsics.checkNotNull((Object)textureBytes);
                    return AnimatedCape.INSTANCE.createFrames(cosmetic2, essentialAsset, textureBytes);
                }
            }, arg_0))).thenCombine((completionStage = this.emissiveTextureFuture) != null && (completionStage = completionStage.thenCompose(arg_0 -> CapeState.future$lambda$2((Function1)new Function1<byte[], CompletionStage<List<? extends UIdentifier>>>(this){
                final /* synthetic */ CapeState this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final CompletionStage<List<UIdentifier>> invoke(byte[] emissiveTextureBytes) {
                    Cosmetic cosmetic2 = this.this$0.getCosmetic();
                    EssentialAsset essentialAsset = CapeState.access$getEmissiveTextureAsset$p(this.this$0);
                    Intrinsics.checkNotNull((Object)essentialAsset);
                    Intrinsics.checkNotNull((Object)emissiveTextureBytes);
                    return AnimatedCape.INSTANCE.createFrames(cosmetic2, essentialAsset, emissiveTextureBytes);
                }
            }, arg_0))) != null ? (CompletionStage)completionStage : (CompletionStage)CompletableFuture.completedFuture(null), (arg_0, arg_1) -> CapeState.future$lambda$3(future.3.INSTANCE, arg_0, arg_1))).whenComplete((arg_0, arg_1) -> CapeState.future$lambda$4((Function2)new Function2<Pair<? extends List<? extends UIdentifier>, ? extends List<? extends UIdentifier>>, Throwable, Unit>(this){
                final /* synthetic */ CapeState this$0;
                {
                    this.this$0 = $receiver;
                    super(2);
                }

                public final void invoke(Pair<? extends List<UIdentifier>, ? extends List<UIdentifier>> pair, Throwable throwable) {
                    if (throwable != null) {
                        Logger logger2 = ModelLoader.access$getLOGGER$cp();
                        String string = "Failed to load cape " + this.this$0.getCosmetic().getId() + ": ";
                        Throwable throwable2 = throwable instanceof CompletionException ? (CompletionException)throwable : null;
                        if (throwable2 == null || (throwable2 = throwable2.getCause()) == null) {
                            throwable2 = throwable;
                        }
                        logger2.error(string, throwable2);
                    }
                }
            }, arg_0, arg_1));
            Intrinsics.checkNotNullExpressionValue((Object)completionStage2, (String)"whenComplete(...)");
            this.future = completionStage2;
            this.priority = new AtomicReference<AssetLoader.Priority>(AssetLoader.Priority.Passive);
        }

        @NotNull
        public final Cosmetic getCosmetic() {
            return this.cosmetic;
        }

        @NotNull
        public final String getVariant() {
            return this.variant;
        }

        @NotNull
        public final CompletableFuture<Pair<List<UIdentifier>, List<UIdentifier>>> getFuture() {
            return this.future;
        }

        public final void ensurePriorityAtLeast(@NotNull AssetLoader.Priority atLeast) {
            Intrinsics.checkNotNullParameter((Object)((Object)atLeast), (String)"atLeast");
            if (this.priority.getAndUpdate(arg_0 -> CapeState.ensurePriorityAtLeast$lambda$5(atLeast, arg_0)).compareTo((Enum)atLeast) < 0) {
                ModelLoader.this.assetLoader.getAssetBytes(this.textureAsset, atLeast);
            }
        }

        private static final CompletionStage future$lambda$1(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (CompletionStage)$tmp0.invoke(p0);
        }

        private static final CompletionStage future$lambda$2(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (CompletionStage)$tmp0.invoke(p0);
        }

        private static final Pair future$lambda$3(Function2 $tmp0, Object p0, Object p1) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Pair)$tmp0.invoke(p0, p1);
        }

        private static final void future$lambda$4(Function2 $tmp0, Object p0, Object p1) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            $tmp0.invoke(p0, p1);
        }

        private static final AssetLoader.Priority ensurePriorityAtLeast$lambda$5(AssetLoader.Priority $atLeast, AssetLoader.Priority it) {
            Intrinsics.checkNotNullParameter((Object)((Object)$atLeast), (String)"$atLeast");
            return it.compareTo((Enum)$atLeast) < 0 ? $atLeast : it;
        }

        public static final /* synthetic */ EssentialAsset access$getTextureAsset$p(CapeState $this) {
            return $this.textureAsset;
        }

        public static final /* synthetic */ EssentialAsset access$getEmissiveTextureAsset$p(CapeState $this) {
            return $this.emissiveTextureAsset;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lgg/essential/network/connectionmanager/cosmetics/ModelLoader$Companion;", "", "()V", "LOGGER", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "essential-gui-essential"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020$R\u0016\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001f\u0010\u0010\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00010\n0\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u001f\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020!0\n0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\"\u001a\u0010\u0012\f\u0012\n %*\u0004\u0018\u00010$0$0#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010&\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010'\u0012\u0004\u0012\u00020\u001e0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010(\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010'\u0012\n\u0012\b\u0012\u0004\u0012\u00020)0\n0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010*\u001a\n\u0012\u0004\u0012\u00020+\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010,\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lgg/essential/network/connectionmanager/cosmetics/ModelLoader$ModelState;", "", "cosmetic", "Lgg/essential/network/cosmetics/Cosmetic;", "variant", "", "skinType", "Lgg/essential/mod/Model;", "(Lgg/essential/network/connectionmanager/cosmetics/ModelLoader;Lgg/essential/network/cosmetics/Cosmetic;Ljava/lang/String;Lgg/essential/mod/Model;)V", "animation", "Lgg/essential/network/connectionmanager/cosmetics/AssetLoader$Asset;", "Lgg/essential/model/file/AnimationFile;", "assets", "Lgg/essential/mod/cosmetics/CosmeticAssets;", "getCosmetic", "()Lgg/essential/network/cosmetics/Cosmetic;", "dependencies", "", "getDependencies", "()Ljava/util/List;", "emissiveTexture", "Lgg/essential/model/backend/RenderBackend$Texture;", "future", "Ljava/util/concurrent/CompletableFuture;", "Lgg/essential/model/BedrockModel;", "getFuture", "()Ljava/util/concurrent/CompletableFuture;", "model", "Lgg/essential/model/file/ModelFile;", "modelAsset", "Lgg/essential/mod/EssentialAsset;", "particles", "", "Lgg/essential/model/file/ParticlesFile;", "priority", "Ljava/util/concurrent/atomic/AtomicReference;", "Lgg/essential/network/connectionmanager/cosmetics/AssetLoader$Priority;", "kotlin.jvm.PlatformType", "skinMaskAssets", "Lgg/essential/model/Side;", "skinMasks", "Lgg/essential/cosmetics/skinmask/SkinMask;", "soundDefinitions", "Lgg/essential/model/file/SoundDefinitionsFile;", "texture", "ensurePriorityAtLeast", "", "atLeast", "essential-gui-essential"})
    @SourceDebugExtension(value={"SMAP\nModelLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModelLoader.kt\ngg/essential/network/connectionmanager/cosmetics/ModelLoader$ModelState\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,138:1\n1#2:139\n1#2:150\n135#3,9:140\n215#3:149\n216#3:151\n144#3:152\n453#4:153\n403#4:154\n453#4:159\n403#4:160\n1238#5,4:155\n1238#5,4:161\n1549#5:165\n1620#5,3:166\n1855#5,2:171\n37#6,2:169\n*S KotlinDebug\n*F\n+ 1 ModelLoader.kt\ngg/essential/network/connectionmanager/cosmetics/ModelLoader$ModelState\n*L\n63#1:150\n63#1:140,9\n63#1:149\n63#1:151\n63#1:152\n71#1:153\n71#1:154\n75#1:159\n75#1:160\n71#1:155,4\n75#1:161,4\n79#1:165\n79#1:166,3\n101#1:171,2\n79#1:169,2\n*E\n"})
    private final class ModelState {
        @NotNull
        private final Cosmetic cosmetic;
        @NotNull
        private final CosmeticAssets assets;
        @NotNull
        private final EssentialAsset modelAsset;
        @NotNull
        private final Map<Side, EssentialAsset> skinMaskAssets;
        @NotNull
        private final AssetLoader.Asset<ModelFile> model;
        @Nullable
        private final AssetLoader.Asset<AnimationFile> animation;
        @NotNull
        private final Map<String, AssetLoader.Asset<ParticlesFile>> particles;
        @Nullable
        private final AssetLoader.Asset<SoundDefinitionsFile> soundDefinitions;
        @Nullable
        private final AssetLoader.Asset<RenderBackend.Texture> texture;
        @Nullable
        private final AssetLoader.Asset<RenderBackend.Texture> emissiveTexture;
        @NotNull
        private final Map<Side, AssetLoader.Asset<SkinMask>> skinMasks;
        @NotNull
        private final List<AssetLoader.Asset<? extends Object>> dependencies;
        @NotNull
        private final CompletableFuture<BedrockModel> future;
        @NotNull
        private final AtomicReference<AssetLoader.Priority> priority;

        /*
         * WARNING - void declaration
         */
        public ModelState(@NotNull Cosmetic cosmetic2, @NotNull String variant, Model skinType) {
            void $this$toTypedArray$iv;
            void $this$mapTo$iv$iv;
            Collection $this$map$iv;
            AssetLoader.Asset asset;
            AssetLoader.Asset asset2;
            AssetLoader.Asset asset3;
            CompletableFuture[] it;
            AssetLoader.Asset asset4;
            Map.Entry it2;
            Object object;
            Object k;
            CompletableFuture[] $this$mapValuesTo$iv$iv;
            CompletableFuture[] $this$mapValues$iv;
            AssetLoader.Asset asset5;
            void it22;
            Object side;
            Object object2;
            ModelLoader $this$mapNotNullTo$iv$iv;
            Map<String, EssentialAsset> $this$mapNotNull$iv;
            Intrinsics.checkNotNullParameter((Object)cosmetic2, (String)"cosmetic");
            Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
            Intrinsics.checkNotNullParameter((Object)((Object)skinType), (String)"skinType");
            this.cosmetic = cosmetic2;
            this.assets = this.cosmetic.assets(variant);
            CosmeticAssets.Geometry geometry = this.assets.getGeometry();
            ModelState modelState = this;
            boolean $i$a$-let-ModelLoader$ModelState$modelAsset$232 = false;
            EssentialAsset steve = geometry.component1();
            EssentialAsset alex = geometry.component2();
            EssentialAsset essentialAsset = skinType == Model.ALEX ? alex : null;
            if (essentialAsset == null) {
                essentialAsset = steve;
            }
            modelState.modelAsset = essentialAsset;
            Object[] objectArray = MapsKt.plus(this.assets.getSidedSkinMasks(), (Pair)TuplesKt.to(null, (Object)this.assets.getDefaultSkinMask()));
            modelState = this;
            boolean $i$f$mapNotNull = false;
            void $i$a$-let-ModelLoader$ModelState$modelAsset$232 = $this$mapNotNull$iv;
            Object destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Pair pair;
                Map.Entry entry;
                Map.Entry element$iv$iv = entry = iterator2.next();
                boolean bl2 = false;
                object2 = element$iv$iv;
                boolean bl3 = false;
                side = (Side)((Object)object2.getKey());
                CosmeticAssets.SkinMask masks = (CosmeticAssets.SkinMask)object2.getValue();
                EssentialAsset steve2 = masks.component1();
                EssentialAsset alex2 = masks.component2();
                EssentialAsset essentialAsset2 = skinType == Model.ALEX ? alex2 : null;
                if (essentialAsset2 == null && (essentialAsset2 = steve2) == null) {
                    pair = null;
                } else {
                    EssentialAsset mask = essentialAsset2;
                    pair = TuplesKt.to((Object)side, (Object)mask);
                }
                if (pair == null) continue;
                Pair it$iv$iv = pair;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            modelState.skinMaskAssets = MapsKt.toMap((Iterable)((List)destination$iv$iv));
            this.model = ModelLoader.this.assetLoader.getAsset(this.modelAsset, AssetLoader.Priority.Passive, AssetLoader.AssetType.Model.INSTANCE);
            ModelState modelState2 = this;
            EssentialAsset essentialAsset3 = this.assets.getAnimations();
            if (essentialAsset3 != null) {
                EssentialAsset essentialAsset4 = essentialAsset3;
                $this$mapNotNullTo$iv$iv = ModelLoader.this;
                destination$iv$iv = essentialAsset4;
                modelState = modelState2;
                boolean bl5 = false;
                asset5 = $this$mapNotNullTo$iv$iv.assetLoader.getAsset((EssentialAsset)it22, AssetLoader.Priority.Passive, AssetLoader.AssetType.Animation.INSTANCE);
                modelState2 = modelState;
            } else {
                asset5 = null;
            }
            modelState2.animation = asset5;
            $this$mapNotNull$iv = this.assets.getParticles();
            CompletableFuture[] completableFutureArray = ModelLoader.this;
            modelState = this;
            boolean $i$f$mapValues22 = false;
            it22 = $this$mapValues$iv;
            Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it$iv$iv;
                Map.Entry bl2 = (Map.Entry)element$iv$iv$iv;
                object2 = destination$iv$iv2;
                boolean bl = false;
                side = (Map.Entry)element$iv$iv$iv;
                k = it$iv$iv.getKey();
                object = object2;
                boolean bl6 = false;
                asset4 = ((ModelLoader)completableFutureArray).assetLoader.getAsset((EssentialAsset)it2.getValue(), AssetLoader.Priority.Passive, AssetLoader.AssetType.Particle.INSTANCE);
                object.put(k, asset4);
            }
            modelState.particles = destination$iv$iv2;
            ModelState modelState3 = this;
            EssentialAsset essentialAsset4 = this.assets.getSoundDefinitions();
            if (essentialAsset4 != null) {
                completableFutureArray = essentialAsset4;
                ModelLoader $i$f$mapValues22 = ModelLoader.this;
                $this$mapValuesTo$iv$iv = completableFutureArray;
                modelState = modelState3;
                boolean bl7 = false;
                asset3 = $i$f$mapValues22.assetLoader.getAsset((EssentialAsset)it, AssetLoader.Priority.Passive, AssetLoader.AssetType.SoundDefinitions.INSTANCE);
                modelState3 = modelState;
            } else {
                asset3 = null;
            }
            modelState3.soundDefinitions = asset3;
            ModelState modelState4 = this;
            EssentialAsset essentialAsset5 = this.assets.getTexture();
            if (essentialAsset5 != null) {
                completableFutureArray = essentialAsset5;
                ModelLoader $i$f$mapValues22 = ModelLoader.this;
                it = completableFutureArray;
                modelState = modelState4;
                boolean bl8 = false;
                asset2 = $i$f$mapValues22.assetLoader.getAsset((EssentialAsset)it, AssetLoader.Priority.Passive, AssetLoader.AssetType.Texture.INSTANCE);
                modelState4 = modelState;
            } else {
                asset2 = null;
            }
            modelState4.texture = asset2;
            ModelState modelState5 = this;
            EssentialAsset essentialAsset6 = this.assets.getEmissiveTexture();
            if (essentialAsset6 != null) {
                completableFutureArray = essentialAsset6;
                ModelLoader $i$f$mapValues22 = ModelLoader.this;
                it = completableFutureArray;
                modelState = modelState5;
                boolean bl9 = false;
                asset = $i$f$mapValues22.assetLoader.getAsset((EssentialAsset)it, AssetLoader.Priority.Passive, AssetLoader.AssetType.Texture.INSTANCE);
                modelState5 = modelState;
            } else {
                asset = null;
            }
            modelState5.emissiveTexture = asset;
            $this$mapValues$iv = this.skinMaskAssets;
            completableFutureArray = ModelLoader.this;
            modelState = this;
            boolean $i$f$mapValues232 = false;
            it = $this$mapValues$iv;
            Map destination$iv$iv3 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            $i$f$mapValuesTo = false;
            $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                Map.Entry it$iv$iv = (Map.Entry)element$iv$iv$iv;
                object2 = destination$iv$iv3;
                boolean bl = false;
                it2 = (Map.Entry)element$iv$iv$iv;
                k = it$iv$iv.getKey();
                object = object2;
                boolean bl10 = false;
                asset4 = ((ModelLoader)completableFutureArray).assetLoader.getAsset((EssentialAsset)it2.getValue(), AssetLoader.Priority.Passive, AssetLoader.AssetType.Mask.INSTANCE);
                object.put(k, asset4);
            }
            modelState.skinMasks = destination$iv$iv3;
            objectArray = new AssetLoader.Asset[]{this.model, this.animation, this.soundDefinitions, this.texture, this.emissiveTexture};
            this.dependencies = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.listOfNotNull((Object[])objectArray), (Iterable)this.skinMasks.values()), (Iterable)this.particles.values());
            Iterable $i$f$mapValues232 = this.dependencies;
            modelState = this;
            boolean $i$f$map = false;
            destination$iv$iv3 = $this$map$iv;
            Collection destination$iv$iv32 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object t : $this$mapTo$iv$iv) {
                void it3;
                Object element$iv$iv$iv;
                element$iv$iv$iv = (AssetLoader.Asset)t;
                object = destination$iv$iv32;
                boolean bl11 = false;
                object.add(it3.getParsed());
            }
            $this$map$iv = (List)destination$iv$iv32;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            completableFutureArray = thisCollection$iv.toArray(new CompletableFuture[0]);
            CompletionStage completionStage = ((CompletableFuture)CompletableFuture.allOf(Arrays.copyOf(completableFutureArray, completableFutureArray.length)).handleAsync((arg_0, arg_1) -> ModelState.future$lambda$9((Function2)new Function2<Void, Throwable, BedrockModel>(this, variant){
                final /* synthetic */ ModelState this$0;
                final /* synthetic */ String $variant;
                {
                    this.this$0 = $receiver;
                    this.$variant = $variant;
                    super(2);
                }

                public final BedrockModel invoke(Void void_, Throwable throwable) {
                    Map map2;
                    Object object;
                    Map.Entry it;
                    Map map3;
                    Object object2;
                    Map.Entry it$iv$iv;
                    boolean bl;
                    Map map4;
                    Map $this$mapValuesTo$iv$iv;
                    Map $this$mapValues$iv;
                    Map map5 = ModelState.access$getParticles$p(this.this$0);
                    Object object3 = ModelState.access$getAnimation$p(this.this$0);
                    AnimationFile animationFile = object3 != null && (object3 = ((AssetLoader.Asset)object3).getParsed()) != null ? (AnimationFile)((CompletableFuture)object3).join() : null;
                    ModelFile modelFile = (ModelFile)ModelState.access$getModel$p(this.this$0).getParsed().join();
                    String string = this.$variant;
                    Cosmetic cosmetic2 = this.this$0.getCosmetic();
                    boolean $i$f$mapValues = false;
                    void var5_9 = $this$mapValues$iv;
                    Map destination$iv$iv = new LinkedHashMap<K, V>(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
                    boolean $i$f$mapValuesTo = false;
                    Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
                    boolean $i$f$associateByTo = false;
                    for (T element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                        Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                        map4 = destination$iv$iv;
                        bl = false;
                        Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                        object2 = it$iv$iv.getKey();
                        map3 = map4;
                        boolean bl2 = false;
                        object = (ParticlesFile)((AssetLoader.Asset)it.getValue()).getParsed().join();
                        map3.put(object2, object);
                    }
                    map3 = destination$iv$iv;
                    $this$mapValues$iv = ModelState.access$getSkinMasks$p(this.this$0);
                    Object object4 = ModelState.access$getEmissiveTexture$p(this.this$0);
                    RenderBackend.Texture texture = object4 != null && (object4 = ((AssetLoader.Asset)object4).getParsed()) != null ? (RenderBackend.Texture)((CompletableFuture)object4).join() : null;
                    Object object5 = ModelState.access$getTexture$p(this.this$0);
                    object = object5 != null && (object5 = ((AssetLoader.Asset)object5).getParsed()) != null ? (RenderBackend.Texture)((CompletableFuture)object5).join() : null;
                    Object object6 = ModelState.access$getSoundDefinitions$p(this.this$0);
                    object2 = object6 != null && (object6 = ((AssetLoader.Asset)object6).getParsed()) != null ? (SoundDefinitionsFile)((CompletableFuture)object6).join() : null;
                    $i$f$mapValues = false;
                    $this$mapValuesTo$iv$iv = $this$mapValues$iv;
                    destination$iv$iv = new LinkedHashMap<K, V>(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
                    $i$f$mapValuesTo = false;
                    $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
                    $i$f$associateByTo = false;
                    for (T element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                        it$iv$iv = (Map.Entry)element$iv$iv$iv;
                        map4 = destination$iv$iv;
                        bl = false;
                        it = (Map.Entry)element$iv$iv$iv;
                        K k = it$iv$iv.getKey();
                        map2 = map4;
                        boolean bl3 = false;
                        SkinMask skinMask = (SkinMask)((AssetLoader.Asset)it.getValue()).getParsed().join();
                        map2.put(k, skinMask);
                    }
                    Map map6 = map2 = destination$iv$iv;
                    RenderBackend.Texture texture2 = texture;
                    Object object7 = object;
                    Object object8 = object2;
                    Map map7 = map3;
                    AnimationFile animationFile2 = animationFile;
                    ModelFile modelFile2 = modelFile;
                    String string2 = string;
                    Cosmetic cosmetic3 = cosmetic2;
                    return new BedrockModel(cosmetic3, string2, modelFile2, animationFile2, map7, (SoundDefinitionsFile)object8, (RenderBackend.Texture)object7, texture2, map6);
                }
            }, arg_0, arg_1))).whenComplete((arg_0, arg_1) -> ModelState.future$lambda$10((Function2)new Function2<BedrockModel, Throwable, Unit>(this){
                final /* synthetic */ ModelState this$0;
                {
                    this.this$0 = $receiver;
                    super(2);
                }

                public final void invoke(BedrockModel bedrockModel, Throwable throwable) {
                    if (throwable != null) {
                        Logger logger2 = ModelLoader.access$getLOGGER$cp();
                        String string = "Failed to load cosmetic " + this.this$0.getCosmetic().getId() + ": ";
                        Throwable throwable2 = throwable instanceof CompletionException ? (CompletionException)throwable : null;
                        if (throwable2 == null || (throwable2 = throwable2.getCause()) == null) {
                            throwable2 = throwable;
                        }
                        logger2.error(string, throwable2);
                    }
                }
            }, arg_0, arg_1));
            Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"whenComplete(...)");
            modelState.future = completionStage;
            this.priority = new AtomicReference<AssetLoader.Priority>(AssetLoader.Priority.Passive);
        }

        @NotNull
        public final Cosmetic getCosmetic() {
            return this.cosmetic;
        }

        @NotNull
        public final List<AssetLoader.Asset<? extends Object>> getDependencies() {
            return this.dependencies;
        }

        @NotNull
        public final CompletableFuture<BedrockModel> getFuture() {
            return this.future;
        }

        /*
         * WARNING - void declaration
         */
        public final void ensurePriorityAtLeast(@NotNull AssetLoader.Priority atLeast) {
            Intrinsics.checkNotNullParameter((Object)((Object)atLeast), (String)"atLeast");
            if (this.priority.getAndUpdate(arg_0 -> ModelState.ensurePriorityAtLeast$lambda$11(atLeast, arg_0)).compareTo((Enum)atLeast) < 0) {
                void $this$forEach$iv;
                Iterable iterable = this.dependencies;
                ModelLoader modelLoader = ModelLoader.this;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    AssetLoader.Asset dependency = (AssetLoader.Asset)element$iv;
                    boolean bl = false;
                    modelLoader.assetLoader.getAssetBytes(dependency.getInfo(), atLeast);
                }
            }
        }

        private static final BedrockModel future$lambda$9(Function2 $tmp0, Object p0, Throwable p1) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (BedrockModel)$tmp0.invoke(p0, (Object)p1);
        }

        private static final void future$lambda$10(Function2 $tmp0, Object p0, Object p1) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            $tmp0.invoke(p0, p1);
        }

        private static final AssetLoader.Priority ensurePriorityAtLeast$lambda$11(AssetLoader.Priority $atLeast, AssetLoader.Priority it) {
            Intrinsics.checkNotNullParameter((Object)((Object)$atLeast), (String)"$atLeast");
            return it.compareTo((Enum)$atLeast) < 0 ? $atLeast : it;
        }

        public static final /* synthetic */ AssetLoader.Asset access$getModel$p(ModelState $this) {
            return $this.model;
        }

        public static final /* synthetic */ AssetLoader.Asset access$getAnimation$p(ModelState $this) {
            return $this.animation;
        }

        public static final /* synthetic */ Map access$getParticles$p(ModelState $this) {
            return $this.particles;
        }

        public static final /* synthetic */ AssetLoader.Asset access$getSoundDefinitions$p(ModelState $this) {
            return $this.soundDefinitions;
        }

        public static final /* synthetic */ AssetLoader.Asset access$getTexture$p(ModelState $this) {
            return $this.texture;
        }

        public static final /* synthetic */ AssetLoader.Asset access$getEmissiveTexture$p(ModelState $this) {
            return $this.emissiveTexture;
        }

        public static final /* synthetic */ Map access$getSkinMasks$p(ModelState $this) {
            return $this.skinMasks;
        }
    }
}

