/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.network.connectionmanager.notices;

import com.google.common.collect.Maps;
import gg.essential.connectionmanager.common.packet.Packet;
import gg.essential.connectionmanager.common.packet.notices.ClientNoticeBulkDismissPacket;
import gg.essential.connectionmanager.common.packet.notices.ClientNoticeRequestPacket;
import gg.essential.connectionmanager.common.packet.notices.ServerNoticeBulkDismissPacket;
import gg.essential.connectionmanager.common.packet.notices.ServerNoticePopulatePacket;
import gg.essential.connectionmanager.common.packet.notices.ServerNoticeRemovePacket;
import gg.essential.handlers.ShutdownHook;
import gg.essential.network.CMConnection;
import gg.essential.network.connectionmanager.NetworkedManager;
import gg.essential.network.connectionmanager.notices.INoticesManager;
import gg.essential.network.connectionmanager.notices.NoticeListener;
import gg.essential.notices.NoticeType;
import gg.essential.notices.model.Notice;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoticesManager
implements NetworkedManager,
INoticesManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(NoticesManager.class);
    @NotNull
    private final Map<String, Notice> notices = Maps.newConcurrentMap();
    @NotNull
    private final Set<String> dismissNoticesQueue = new HashSet<String>();
    @NotNull
    private final CMConnection connectionManager;
    private final List<NoticeListener> listeners = new ArrayList<NoticeListener>();

    public NoticesManager(@NotNull CMConnection connectionManager) {
        this.connectionManager = connectionManager;
        connectionManager.registerPacketHandler(ServerNoticePopulatePacket.class, packet -> {
            this.populateNotices(packet.getNotices());
            return Unit.INSTANCE;
        });
        connectionManager.registerPacketHandler(ServerNoticeRemovePacket.class, packet -> {
            this.removeNotices(packet.getIds());
            return Unit.INSTANCE;
        });
        ShutdownHook.INSTANCE.register(this::flushDismissNotices);
    }

    public void register(NoticeListener listener2) {
        this.listeners.add(listener2);
    }

    @NotNull
    public Map<String, Notice> getNotices() {
        return this.notices;
    }

    @NotNull
    public Optional<Notice> getNotice(@NotNull String notice) {
        return Optional.ofNullable(this.notices.get(notice));
    }

    @NotNull
    public List<Notice> getNotices(@NotNull NoticeType noticeType, @Nullable Set<String> metadataKeys, @Nullable Map<String, Object> metadataValues) {
        return this.notices.values().stream().filter(notice -> notice.getType() == noticeType).filter(notice -> {
            if (metadataKeys == null || metadataKeys.isEmpty()) {
                return true;
            }
            Map<String, Object> metadata2 = notice.getMetadata();
            if (metadata2.isEmpty()) {
                return false;
            }
            for (String metadataKey : metadataKeys) {
                if (metadata2.containsKey(metadataKey)) continue;
                return false;
            }
            return true;
        }).filter(notice -> {
            if (metadataValues == null || metadataValues.isEmpty()) {
                return true;
            }
            Map<String, Object> metadata2 = notice.getMetadata();
            if (metadata2.isEmpty()) {
                return false;
            }
            Iterator iterator2 = metadataValues.entrySet().iterator();
            if (iterator2.hasNext()) {
                @NotNull Map.Entry<K, V> entry = iterator2.next();
                Object metadataValue = metadata2.get(entry.getKey());
                if (metadataValue == null) {
                    return false;
                }
                return Objects.equals(metadataValue, entry.getValue());
            }
            return false;
        }).collect(Collectors.toList());
    }

    @Override
    public void populateNotices(@NotNull Collection<? extends Notice> notices) {
        for (Notice notice : notices) {
            this.notices.put(notice.getId(), notice);
            for (NoticeListener listener2 : this.listeners) {
                try {
                    listener2.noticeAdded(notice);
                }
                catch (Exception e) {
                    LOGGER.error("An error occurred within a notice listener for noticeAdded: {}", (Object)notice.getId(), (Object)e);
                }
            }
        }
    }

    @Override
    public void removeNotices(@Nullable Set<String> noticeIds) {
        if (noticeIds == null || noticeIds.isEmpty()) {
            for (Notice value : this.notices.values()) {
                for (NoticeListener listener2 : this.listeners) {
                    try {
                        listener2.noticeRemoved(value);
                    }
                    catch (Exception e) {
                        LOGGER.error("An error occurred within a notice listener for noticeRemoved: {}", (Object)value.getId(), (Object)e);
                    }
                }
            }
            this.notices.clear();
            return;
        }
        for (String noticeId : noticeIds) {
            Notice removed = this.notices.remove(noticeId);
            if (removed == null) continue;
            for (NoticeListener listener3 : this.listeners) {
                try {
                    listener3.noticeRemoved(removed);
                }
                catch (Exception e) {
                    LOGGER.error("An error occurred within a notice listener for noticeRemoved: {}", (Object)removed.getId(), (Object)e);
                }
            }
        }
    }

    @Override
    public void dismissNotice(String noticeId) {
        this.dismissNotices(SetsKt.setOf((Object)noticeId));
    }

    public void dismissNotices(Set<String> noticeIds) {
        this.dismissNoticesQueue.addAll(noticeIds);
        this.flushDismissNotices();
    }

    public void queueDismissNotice(String noticeId) {
        this.dismissNoticesQueue.add(noticeId);
    }

    public void flushDismissNotices() {
        if (this.dismissNoticesQueue.isEmpty()) {
            return;
        }
        HashSet<String> notices = new HashSet<String>(this.dismissNoticesQueue);
        this.dismissNoticesQueue.clear();
        this.connectionManager.send(new ClientNoticeBulkDismissPacket(notices), maybePacket -> {
            Packet packet;
            if (maybePacket.isPresent() && (packet = (Packet)maybePacket.get()) instanceof ServerNoticeBulkDismissPacket) {
                ServerNoticeBulkDismissPacket serverNoticeBulkDismissPacket = (ServerNoticeBulkDismissPacket)packet;
                Set<String> noticeIds = serverNoticeBulkDismissPacket.getNoticeIds();
                if (!noticeIds.isEmpty()) {
                    this.removeNotices(noticeIds);
                }
                block7: for (ServerNoticeBulkDismissPacket.ErrorDetails error2 : serverNoticeBulkDismissPacket.getErrors()) {
                    switch (error2.getReason()) {
                        case "NOTICE_NOT_FOUND": 
                        case "NOTICE_ALREADY_DISMISSED": {
                            this.removeNotices(SetsKt.setOf((Object)error2.getNoticeId()));
                            continue block7;
                        }
                    }
                    LOGGER.error("Notice unable to be dismissed: NoticeId: {}, Reason: {}", (Object)error2.getNoticeId(), (Object)error2.getReason());
                }
                return;
            }
            LOGGER.error("Unexpected notice response: {}", maybePacket);
        });
    }

    @Override
    public void resetState() {
        this.notices.clear();
        this.listeners.forEach(NoticeListener::resetState);
    }

    @Override
    public void onConnected() {
        this.resetState();
        this.connectionManager.call(new ClientNoticeRequestPacket(null, SetsKt.setOf((Object[])NoticeType.values()), null, null)).fireAndForget();
        this.listeners.forEach(NoticeListener::onConnect);
    }
}

