/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.network.connectionmanager.sps;

import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.platform.GlUtil;
import com.sparkuniverse.toolbox.util.DateTime;
import gg.essential.Essential;
import gg.essential.commands.EssentialCommandRegistry;
import gg.essential.compat.PlasmoVoiceCompat;
import gg.essential.connectionmanager.common.packet.telemetry.ClientTelemetryPacket;
import gg.essential.connectionmanager.common.packet.upnp.ClientUPnPSessionClosePacket;
import gg.essential.connectionmanager.common.packet.upnp.ClientUPnPSessionCreatePacket;
import gg.essential.connectionmanager.common.packet.upnp.ClientUPnPSessionInvitesAddPacket;
import gg.essential.connectionmanager.common.packet.upnp.ClientUPnPSessionInvitesRemovePacket;
import gg.essential.connectionmanager.common.packet.upnp.ClientUPnPSessionPingProxyUpdatePacket;
import gg.essential.connectionmanager.common.packet.upnp.ClientUPnPSessionUpdatePacket;
import gg.essential.connectionmanager.common.packet.upnp.ServerUPnPSessionInviteAddPacket;
import gg.essential.connectionmanager.common.packet.upnp.ServerUPnPSessionPopulatePacket;
import gg.essential.connectionmanager.common.packet.upnp.ServerUPnPSessionRemovePacket;
import gg.essential.data.SPSData;
import gg.essential.event.network.server.ServerLeaveEvent;
import gg.essential.event.sps.PlayerJoinSessionEvent;
import gg.essential.event.sps.PlayerLeaveSessionEvent;
import gg.essential.event.sps.SPSStartEvent;
import gg.essential.gui.elementa.state.v2.MutableState;
import gg.essential.gui.elementa.state.v2.State;
import gg.essential.gui.elementa.state.v2.StateKt;
import gg.essential.gui.friends.state.IStatusManager;
import gg.essential.gui.multiplayer.EssentialMultiplayerGui;
import gg.essential.lib.kbrewster.eventbus.Subscribe;
import gg.essential.mixins.transformers.server.integrated.LanConnectionsAccessor;
import gg.essential.network.connectionmanager.ConnectionManager;
import gg.essential.network.connectionmanager.NetworkedManager;
import gg.essential.network.connectionmanager.StateCallbackManager;
import gg.essential.network.connectionmanager.handler.upnp.ServerUPnPSessionInviteAddPacketHandler;
import gg.essential.network.connectionmanager.handler.upnp.ServerUPnPSessionPopulatePacketHandler;
import gg.essential.network.connectionmanager.handler.upnp.ServerUPnPSessionRemovePacketHandler;
import gg.essential.network.connectionmanager.queue.PacketQueue;
import gg.essential.network.connectionmanager.queue.SequentialPacketQueue;
import gg.essential.network.connectionmanager.sps.SPSSessionSource;
import gg.essential.sps.ResourcePackSharingHttpServer;
import gg.essential.sps.WindowTitleManager;
import gg.essential.universal.UMinecraft;
import gg.essential.upnp.UPnPPrivacy;
import gg.essential.upnp.model.UPnPSession;
import gg.essential.util.ExtensionsKt;
import gg.essential.util.HelpersKt;
import gg.essential.util.MinecraftUtils;
import gg.essential.util.ModLoaderUtil;
import gg.essential.util.Multithreading;
import gg.essential.util.UUIDUtil;
import gg.essential.util.UuidNameLookup;
import java.io.File;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.server.players.ServerOpList;
import net.minecraft.server.players.StoredUserEntry;
import net.minecraft.server.players.UserWhiteList;
import net.minecraft.server.players.UserWhiteListEntry;
import net.minecraft.util.HttpUtil;
import net.minecraft.world.Difficulty;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ServerLevelData;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SPSManager
extends StateCallbackManager<IStatusManager>
implements NetworkedManager {
    public static final String SPS_SERVER_TLD = ".essential-sps";
    @NotNull
    private final ConnectionManager connectionManager;
    @NotNull
    private final PacketQueue updateQueue;
    @NotNull
    private final Object whitelistSemaphore = new Object();
    @NotNull
    private final Map<UUID, UPnPSession> remoteSessions = Maps.newConcurrentMap();
    @Nullable
    private UPnPSession localSession;
    @Nullable
    private SPSSessionSource localSessionSource;
    private GameType currentGameMode;
    private boolean allowCheats;
    private Difficulty difficulty;
    private boolean difficultyLocked;
    @Nullable
    private String serverStatusResponse;
    private final Set<UUID> oppedPlayers = new HashSet<UUID>();
    private final Map<UUID, MutableState<Boolean>> onlinePlayerStates = new HashMap<UUID, MutableState<Boolean>>();
    private boolean shareResourcePack = false;
    @Nullable
    private ResourcePackSharingHttpServer.PackInfo packInfo;
    private String resourcePackUrl = null;
    private String resourcePackChecksum = null;
    private Instant sessionStartTime = Instant.now();
    private UUID sessionId = null;
    private int maxConcurrentGuests = 0;

    public SPSManager(@NotNull ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
        this.updateQueue = new SequentialPacketQueue.Builder(connectionManager).onTimeoutRetransmit().create();
        connectionManager.registerPacketHandler(ServerUPnPSessionInviteAddPacket.class, new ServerUPnPSessionInviteAddPacketHandler());
        connectionManager.registerPacketHandler(ServerUPnPSessionPopulatePacket.class, new ServerUPnPSessionPopulatePacketHandler());
        connectionManager.registerPacketHandler(ServerUPnPSessionRemovePacket.class, new ServerUPnPSessionRemovePacketHandler());
        Runtime.getRuntime().addShutdownHook(new Thread(this::closeLocalSession));
    }

    @NotNull
    public String getSpsAddress(@NotNull UUID hostUUID) {
        return hostUUID.toString() + SPS_SERVER_TLD;
    }

    public GameType getCurrentGameMode() {
        return this.currentGameMode;
    }

    public boolean isAllowCheats() {
        return this.allowCheats;
    }

    public boolean isSpsAddress(String address) {
        return address.endsWith(SPS_SERVER_TLD);
    }

    @Nullable
    public UUID getHostFromSpsAddress(@NotNull String address) {
        if (!address.endsWith(SPS_SERVER_TLD)) {
            return null;
        }
        address = address.substring(0, address.length() - SPS_SERVER_TLD.length());
        try {
            return UUID.fromString(address);
        }
        catch (IllegalArgumentException ignored) {
            return null;
        }
    }

    @Nullable
    public UPnPSession getRemoteSession(UUID hostUUID) {
        return this.remoteSessions.get(hostUUID);
    }

    @NotNull
    public Collection<UPnPSession> getRemoteSessions() {
        return Collections.unmodifiableCollection(this.remoteSessions.values());
    }

    public void addRemoteSession(@NotNull UPnPSession session) {
        UPnPSession previousSession = this.remoteSessions.put(session.getHostUUID(), session);
        EssentialMultiplayerGui gui2 = EssentialMultiplayerGui.getInstance();
        if (gui2 != null) {
            gui2.updateSpsSessions();
        }
        for (IStatusManager manager : this.getCallbacks()) {
            manager.refreshActivity(session.getHostUUID());
        }
    }

    public void removeRemoteSession(@NotNull UUID hostUUID) {
        this.remoteSessions.remove(hostUUID);
        for (IStatusManager manager : this.getCallbacks()) {
            manager.refreshActivity(hostUUID);
        }
        EssentialMultiplayerGui gui2 = EssentialMultiplayerGui.getInstance();
        if (gui2 != null) {
            gui2.updateSpsSessions();
        }
    }

    @NotNull
    public Set<UUID> getInvitedUsers() {
        UPnPSession session = this.localSession;
        return session != null ? session.getInvites() : Collections.emptySet();
    }

    private void sendInvites(Set<UUID> invited) {
        if (invited.isEmpty()) {
            return;
        }
        this.updateQueue.enqueue(new ClientUPnPSessionInvitesAddPacket(invited), null);
    }

    private void revokeInvites(Set<UUID> removed) {
        if (removed.isEmpty()) {
            return;
        }
        this.updateQueue.enqueue(new ClientUPnPSessionInvitesRemovePacket(removed), null);
    }

    public synchronized void updateInvitedUsers(Set<UUID> invited) {
        if (this.localSession == null) {
            throw new IllegalStateException("Cannot update invites while no session is active.");
        }
        invited = new HashSet<UUID>(invited);
        invited.remove(UUIDUtil.getClientUUID());
        invited = Collections.unmodifiableSet(invited);
        this.revokeInvites(SetsKt.minus(this.localSession.getInvites(), invited));
        this.sendInvites(SetsKt.minus(invited, this.localSession.getInvites()));
        this.localSession = new UPnPSession(this.localSession.getHostUUID(), this.localSession.getIp(), this.localSession.getPort(), this.localSession.getPrivacy(), invited, this.localSession.getCreatedAt(), MinecraftUtils.getCurrentProtocolVersion(), MinecraftUtils.INSTANCE.getWorldName());
        Multithreading.runAsync(this::refreshWhitelist);
        this.persistSettings();
    }

    public synchronized void reinviteUsers(Set<UUID> users2) {
        if (this.localSession == null) {
            throw new IllegalStateException("Cannot update invites while no session is active.");
        }
        Set<UUID> offlineUsers = users2.stream().filter(uuid -> this.getInvitedUsers().contains(uuid) && this.getOnlineState((UUID)uuid).getUntracked() == false).collect(Collectors.toSet());
        this.revokeInvites(offlineUsers);
        this.updateInvitedUsers(SetsKt.plus(this.localSession.getInvites(), users2));
    }

    @Nullable
    public UPnPSession getLocalSession() {
        return this.localSession;
    }

    public Difficulty getDifficulty() {
        return this.difficulty;
    }

    public boolean isDifficultyLocked() {
        return this.difficultyLocked;
    }

    public Instant getSessionStartTime() {
        return this.sessionStartTime;
    }

    public void startLocalSession(SPSSessionSource sessionSource) {
        Optional<Integer> plasmoPort;
        this.sessionStartTime = Instant.now();
        this.sessionId = UUID.randomUUID();
        this.currentGameMode = GameType.ADVENTURE;
        this.localSessionSource = sessionSource;
        this.maxConcurrentGuests = 0;
        Multithreading.runAsync(ResourcePackSharingHttpServer.INSTANCE::startServer);
        this.updateResourcePack(this.packInfo);
        IntegratedServer server = UMinecraft.getMinecraft().m_91092_();
        if (server == null) {
            return;
        }
        ServerLevel world = server.m_129880_(Level.f_46428_);
        ServerLevelData worldInfo = (ServerLevelData)world.m_6106_();
        this.allowCheats = worldInfo.m_5468_();
        this.difficulty = worldInfo.m_5472_();
        this.difficultyLocked = worldInfo.m_5474_();
        server.m_6846_().m_6628_(true);
        this.updateOppedPlayers(new HashSet<UUID>(), false);
        int port = HttpUtil.m_13939_();
        if (!server.m_7386_(this.currentGameMode, false, port)) {
            return;
        }
        int voicePort = port;
        if (ModLoaderUtil.INSTANCE.isModLoaded("plasmo_voice")) {
            voicePort = 60606;
        } else if (ModLoaderUtil.INSTANCE.isModLoaded("plasmovoice") && (plasmoPort = PlasmoVoiceCompat.getPort()).isPresent()) {
            voicePort = plasmoPort.get();
        }
        this.connectionManager.getIceManager().setVoicePort(voicePort);
        String address = this.getSpsAddress(UUIDUtil.getClientUUID());
        this.updateLocalSession(address, 0);
        Essential.EVENT_BUS.post(new SPSStartEvent(address));
        EssentialCommandRegistry.INSTANCE.registerSPSHostCommands();
        WindowTitleManager.INSTANCE.updateTitle();
    }

    public synchronized void updateLocalSession(@NotNull String ip, int port) {
        UPnPPrivacy privacy = UPnPPrivacy.INVITE_ONLY;
        int protocolVersion = MinecraftUtils.getCurrentProtocolVersion();
        String worldName = MinecraftUtils.INSTANCE.getWorldName();
        UPnPSession oldSession = this.localSession;
        UPnPSession session = new UPnPSession(UUIDUtil.getClientUUID(), ip, port, privacy, oldSession != null ? oldSession.getInvites() : Collections.emptySet(), oldSession != null ? oldSession.getCreatedAt() : new DateTime(), protocolVersion, worldName);
        if (this.localSession == null) {
            this.updateQueue.enqueue(new ClientUPnPSessionCreatePacket(ip, port, privacy, protocolVersion, worldName));
        } else {
            this.updateQueue.enqueue(new ClientUPnPSessionUpdatePacket(ip, port, privacy));
        }
        this.localSession = session;
        Multithreading.runAsync(this::refreshWhitelist);
    }

    public synchronized void closeLocalSession() {
        IntegratedServer server = Minecraft.m_91087_().m_91092_();
        UPnPSession oldSession = this.localSession;
        if (oldSession != null) {
            if (server != null) {
                this.sendSessionTelemetry(server, oldSession);
            }
            this.revokeInvites(oldSession.getInvites());
        }
        this.currentGameMode = null;
        this.allowCheats = false;
        this.oppedPlayers.clear();
        this.onlinePlayerStates.clear();
        this.localSession = null;
        this.localSessionSource = null;
        ResourcePackSharingHttpServer.INSTANCE.stopServer();
        this.resourcePackUrl = null;
        this.resourcePackChecksum = null;
        this.shareResourcePack = false;
        ExtensionsKt.getExecutor(Minecraft.m_91087_()).execute(EssentialCommandRegistry.INSTANCE::unregisterSPSHostCommands);
        this.updateQueue.enqueue(new ClientUPnPSessionClosePacket());
    }

    private static String cpuInfo() {
        return GlUtil.m_84819_();
    }

    private void sendSessionTelemetry(IntegratedServer server, final UPnPSession oldSession) {
        final File worldDirectory = ExtensionsKt.getWorldDirectory(server).toFile();
        HashMap<String, Object> metadata2 = new HashMap<String, Object>(){
            {
                this.put("userCPU", SPSManager.cpuInfo());
                this.put("worldNameHash", DigestUtils.sha256Hex((String)(String.valueOf(UUIDUtil.getClientUUID()) + worldDirectory.getName())));
                this.put("inviteCount", oldSession.getInvites().size());
                this.put("shareRP", SPSManager.this.shareResourcePack);
                this.put("maxConcurrentGuests", SPSManager.this.maxConcurrentGuests);
                this.put("allocatedMemoryMb", Runtime.getRuntime().maxMemory() / 1000000L);
                this.put("sessionDurationSeconds", TimeUnit.MILLISECONDS.toSeconds(Duration.between(SPSManager.this.sessionStartTime, Instant.now()).toMillis()));
                this.put("sessionId", SPSManager.this.sessionId);
                this.put("initiatedFrom", SPSManager.this.localSessionSource);
            }
        };
        Multithreading.runAsync(() -> {
            long worldSizeBytes = FileUtils.sizeOfDirectory((File)worldDirectory);
            metadata2.put("worldSizeMb", worldSizeBytes / 1000000L);
            ExtensionsKt.getExecutor(Minecraft.m_91087_()).execute(() -> this.connectionManager.getTelemetryManager().enqueue(new ClientTelemetryPacket("SPS_SESSION_3", metadata2)));
        });
    }

    public void updateServerStatusResponse(@NotNull String updatedResponse) {
        if (this.localSession == null) {
            return;
        }
        if (updatedResponse.equals(this.serverStatusResponse)) {
            return;
        }
        this.serverStatusResponse = updatedResponse;
        ExtensionsKt.getExecutor(Minecraft.m_91087_()).execute(() -> this.updateQueue.enqueue(new ClientUPnPSessionPingProxyUpdatePacket(updatedResponse)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshWhitelist() {
        Object object = this.whitelistSemaphore;
        synchronized (object) {
            this.doRefreshWhitelist();
        }
    }

    private void doRefreshWhitelist() {
        UPnPSession session = this.localSession;
        if (session == null) {
            return;
        }
        Set<UUID> invited = session.getPrivacy() == UPnPPrivacy.INVITE_ONLY ? session.getInvites() : new HashSet<UUID>(this.connectionManager.getRelationshipManager().getFriends().keySet());
        CollectionsKt.map(invited, UuidNameLookup::getName).forEach(CompletableFuture::join);
        IntegratedServer server = UMinecraft.getMinecraft().m_91092_();
        if (server == null) {
            return;
        }
        ExtensionsKt.getExecutor((MinecraftServer)server).execute(() -> {
            UserWhiteList whitelist = server.m_6846_().m_11305_();
            for (String userName : whitelist.m_5875_()) {
                GameProfile profile2 = server.m_129927_().m_10996_(userName).orElse(null);
                if (profile2 == null || invited.contains(profile2.getId())) continue;
                whitelist.m_11393_((Object)profile2);
            }
            for (UUID uuid : invited) {
                String userName;
                GameProfile profile3 = new GameProfile(uuid, userName = UUIDUtil.getName(uuid).join());
                if (whitelist.m_11388_((Object)profile3) != null) continue;
                whitelist.m_11381_((StoredUserEntry)new UserWhiteListEntry(profile3));
            }
            for (ServerPlayer entity : ((LanConnectionsAccessor)server.m_6846_()).getPlayerEntityList()) {
                if (invited.contains(entity.m_20148_()) || UUIDUtil.getClientUUID().equals(entity.m_20148_())) continue;
                entity.f_8906_.m_9942_((Component)HelpersKt.textTranslatable("multiplayer.disconnect.server_shutdown", new Object[0]));
            }
        });
    }

    @Subscribe
    private void onDisconnect(ServerLeaveEvent event) {
        this.closeLocalSession();
    }

    @Override
    public synchronized void onConnected() {
        this.updateQueue.reset();
        UPnPSession session = this.localSession;
        if (session != null) {
            this.updateQueue.enqueue(new ClientUPnPSessionCreatePacket(session.getIp(), session.getPort(), session.getPrivacy(), session.getProtocolVersion(), session.getWorldName()));
            this.updateQueue.enqueue(new ClientUPnPSessionInvitesAddPacket(session.getInvites()));
            String serverStatusResponse = this.serverStatusResponse;
            if (serverStatusResponse != null) {
                this.updateQueue.enqueue(new ClientUPnPSessionPingProxyUpdatePacket(serverStatusResponse));
            }
        }
        this.resetState();
    }

    @Override
    public void resetState() {
        this.remoteSessions.clear();
    }

    public void updateWorldSettings(boolean cheats, @NotNull GameType gameType, @NotNull Difficulty difficulty2, boolean difficultyLocked2) {
        IntegratedServer integratedServer = UMinecraft.getMinecraft().m_91092_();
        if (integratedServer != null) {
            ExtensionsKt.getExecutor((MinecraftServer)integratedServer).execute(() -> {
                integratedServer.m_7835_(gameType);
                this.updateCheatSettings(integratedServer, cheats);
                integratedServer.m_129827_(difficulty2, true);
            });
        }
        if (UMinecraft.getWorld() != null && !UMinecraft.getWorld().m_6106_().m_5474_()) {
            UMinecraft.getWorld().m_6106_().m_104851_(difficulty2);
        }
        this.allowCheats = cheats;
        this.currentGameMode = gameType;
        this.difficulty = difficulty2;
        this.difficultyLocked = difficultyLocked2;
        this.persistSettings();
    }

    private void persistSettings() {
        IntegratedServer integratedServer = UMinecraft.getMinecraft().m_91092_();
        if (integratedServer != null) {
            SPSData.SPSSettings spsSettings = new SPSData.SPSSettings(this.currentGameMode, this.difficulty, this.difficultyLocked, this.allowCheats, this.getInvitedUsers(), this.shareResourcePack, this.oppedPlayers);
            SPSData.INSTANCE.saveSPSSettings(spsSettings, ExtensionsKt.getWorldDirectory(integratedServer));
        }
    }

    public void updateWorldGameRules(final GameRules gameRules, Map<String, String> gameRuleSettings) {
        final HashMap<String, String> immutableGameRules = new HashMap<String, String>(gameRuleSettings);
        final IntegratedServer integratedServer = UMinecraft.getMinecraft().m_91092_();
        if (integratedServer != null) {
            ExtensionsKt.getExecutor((MinecraftServer)integratedServer).execute(() -> GameRules.m_46164_((GameRules.GameRuleTypeVisitor)new GameRules.GameRuleTypeVisitor(){

                public <T extends GameRules.Value<T>> void m_6889_(GameRules.Key<T> key, GameRules.Type<T> type) {
                    super.m_6889_(key, type);
                    if (immutableGameRules.containsKey(key.m_46328_())) {
                        String setting2 = (String)immutableGameRules.get(key.m_46328_());
                        GameRules.Value value = gameRules.m_46170_(key);
                        if (value instanceof GameRules.BooleanValue) {
                            GameRules.BooleanValue newValue = new GameRules.BooleanValue(type, Boolean.parseBoolean(setting2));
                            ((GameRules.BooleanValue)value).m_5614_(newValue, (MinecraftServer)integratedServer);
                        } else if (value instanceof GameRules.IntegerValue) {
                            GameRules.IntegerValue newValue = new GameRules.IntegerValue(type, Integer.parseInt(setting2));
                            ((GameRules.IntegerValue)value).m_5614_(newValue, (MinecraftServer)integratedServer);
                        }
                    }
                }
            }));
        }
    }

    private void updateCheatSettings(IntegratedServer integratedServer, boolean cheats) {
        this.allowCheats = cheats;
        this.updateOppedPlayers(new HashSet<UUID>(this.getOppedPlayers()), false);
    }

    public void updateOppedPlayers(Set<UUID> oppedPlayers) {
        this.updateOppedPlayers(oppedPlayers, true);
    }

    private void updateOppedPlayers(Set<UUID> oppedPlayers, boolean persistSettings) {
        IntegratedServer integratedServer = Minecraft.m_91087_().m_91092_();
        if (integratedServer == null) {
            throw new IllegalStateException("No local session is currently active.");
        }
        this.oppedPlayers.clear();
        this.oppedPlayers.addAll(oppedPlayers);
        HashSet<UUID> immutableOppedPlayers = new HashSet<UUID>();
        if (this.allowCheats) {
            immutableOppedPlayers.addAll(this.oppedPlayers);
            immutableOppedPlayers.add(UUIDUtil.getClientUUID());
        }
        if (persistSettings) {
            this.persistSettings();
        }
        ExtensionsKt.getExecutor((MinecraftServer)integratedServer).execute(() -> {
            PlayerList playerList = integratedServer.m_6846_();
            ServerOpList opList = playerList.m_11307_();
            List allProfiles = Arrays.stream(opList.m_5875_()).map(username -> integratedServer.m_129927_().m_10996_(username)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
            for (GameProfile profile2 : allProfiles) {
                if (immutableOppedPlayers.contains(profile2.getId())) continue;
                playerList.m_5750_(profile2);
            }
            for (UUID oppedPlayer : immutableOppedPlayers) {
                GameProfile gameProfile2 = new GameProfile(oppedPlayer, UUIDUtil.getName(oppedPlayer).join());
                if (opList.m_11388_((Object)gameProfile2) != null) continue;
                playerList.m_5749_(gameProfile2);
            }
        });
    }

    public Set<UUID> getOppedPlayers() {
        return this.oppedPlayers;
    }

    public State<Boolean> getOnlineState(UUID uuid) {
        if (uuid.equals(UUIDUtil.getClientUUID())) {
            return StateKt.stateOf(true);
        }
        return this.onlinePlayerStates.computeIfAbsent(uuid, k -> StateKt.mutableStateOf(false));
    }

    @Subscribe
    public void onPlayerJoinSession(PlayerJoinSessionEvent event) {
        this.onlinePlayerStates.computeIfAbsent(event.getProfile().getId(), k -> StateKt.mutableStateOf(true)).set(true);
        this.maxConcurrentGuests = (int)Math.max((long)this.maxConcurrentGuests, this.onlinePlayerStates.values().stream().filter(State::getUntracked).count());
    }

    @Subscribe
    public void onPlayerLeaveSession(PlayerLeaveSessionEvent event) {
        MutableState<Boolean> onlineState = this.onlinePlayerStates.remove(event.getProfile().getId());
        if (onlineState != null) {
            onlineState.set(false);
        }
    }

    public boolean isShareResourcePack() {
        return this.shareResourcePack;
    }

    public void setShareResourcePack(boolean shareResourcePack2) {
        this.shareResourcePack = shareResourcePack2;
        if (shareResourcePack2) {
            ResourcePackSharingHttpServer.INSTANCE.onShareResourcePackEnable();
        }
        this.updateResourcePack(this.packInfo);
        this.persistSettings();
    }

    public void updateResourcePack(@Nullable ResourcePackSharingHttpServer.PackInfo info) {
        this.packInfo = info;
        IntegratedServer integratedServer = Minecraft.m_91087_().m_91092_();
        if (integratedServer != null) {
            if (this.packInfo == null || !this.shareResourcePack) {
                this.setServerResourcePack(null, null);
            } else {
                String url = "http://" + String.valueOf(UUIDUtil.getClientUUID()) + ".essential-sps/" + this.packInfo.getChecksum();
                this.setServerResourcePack(url, this.packInfo.getChecksum());
            }
        }
    }

    private void setServerResourcePack(String url, String checksum) {
        this.resourcePackUrl = url;
        this.resourcePackChecksum = checksum;
    }

    public String getResourcePackUrl() {
        return this.resourcePackUrl;
    }

    public String getResourcePackChecksum() {
        return this.resourcePackChecksum;
    }

    public UUID getSessionId() {
        return this.sessionId;
    }
}

