/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.util.lwjgl3.impl;

import gg.essential.util.lwjgl3.api.ImageData;
import gg.essential.util.lwjgl3.api.NativeImageReader;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.EnumSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.stb.STBIWriteCallback;
import org.lwjgl.stb.STBImage;
import org.lwjgl.stb.STBImageWrite;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u000e\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\bH\u0016R2\u0010\u0003\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lgg/essential/util/lwjgl3/impl/NativeImageReaderImpl;", "Lgg/essential/util/lwjgl3/api/NativeImageReader;", "()V", "fileOptions", "Ljava/util/EnumSet;", "Ljava/nio/file/StandardOpenOption;", "kotlin.jvm.PlatformType", "getImageData", "Lgg/essential/util/lwjgl3/api/ImageData;", "buf", "Lio/netty/buffer/ByteBuf;", "allocator", "Lio/netty/buffer/ByteBufAllocator;", "inputBuffer", "Ljava/nio/ByteBuffer;", "path", "Ljava/nio/file/Path;", "readResource", "inputStream", "Ljava/io/InputStream;", "saveImage", "", "imageData", "WriteCallback", "impl"})
@SourceDebugExtension(value={"SMAP\nNativeImageReaderImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NativeImageReaderImpl.kt\ngg/essential/util/lwjgl3/impl/NativeImageReaderImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,157:1\n1#2:158\n*E\n"})
public final class NativeImageReaderImpl
implements NativeImageReader {
    private final EnumSet<StandardOpenOption> fileOptions = EnumSet.of((Enum)StandardOpenOption.WRITE, (Enum)StandardOpenOption.CREATE, (Enum)StandardOpenOption.TRUNCATE_EXISTING);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ImageData getImageData(@NotNull Path path, @NotNull ByteBufAllocator allocator2) {
        ByteBuffer byteBuffer;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)allocator2, (String)"allocator");
        Object object = Files.newInputStream(path, new OpenOption[0]);
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)object;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            byteBuffer = this.readResource(it);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        ByteBuffer fileData = byteBuffer;
        fileData.rewind();
        try {
            object = this.getImageData(fileData, allocator2);
            return object;
        }
        finally {
            MemoryUtil.memFree((Buffer)fileData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ImageData getImageData(@NotNull ByteBuf buf, @NotNull ByteBufAllocator allocator2) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        Intrinsics.checkNotNullParameter((Object)allocator2, (String)"allocator");
        if (!buf.isDirect()) {
            ByteBuf directBuf = Unpooled.directBuffer((int)buf.readableBytes());
            try {
                directBuf.writeBytes(buf, buf.readerIndex(), buf.readableBytes());
                ByteBuffer byteBuffer = directBuf.nioBuffer();
                Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"nioBuffer(...)");
                ImageData imageData = this.getImageData(byteBuffer, allocator2);
                return imageData;
            }
            finally {
                directBuf.release();
            }
        }
        ByteBuffer byteBuffer = buf.nioBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"nioBuffer(...)");
        return this.getImageData(byteBuffer, allocator2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ImageData getImageData(ByteBuffer inputBuffer, ByteBufAllocator allocator2) {
        AutoCloseable autoCloseable = (AutoCloseable)MemoryStack.stackPush();
        Throwable throwable = null;
        try {
            ImageData imageData;
            MemoryStack memoryStack = (MemoryStack)autoCloseable;
            boolean bl = false;
            IntBuffer widthBuffer = memoryStack.mallocInt(1);
            IntBuffer heightBuffer = memoryStack.mallocInt(1);
            IntBuffer fileChannels = memoryStack.mallocInt(1);
            ByteBuffer byteBuffer = STBImage.stbi_load_from_memory((ByteBuffer)inputBuffer, (IntBuffer)widthBuffer, (IntBuffer)heightBuffer, (IntBuffer)fileChannels, (int)0);
            if (byteBuffer == null) {
                throw new IOException("Could not load image: " + STBImage.stbi_failure_reason());
            }
            ByteBuffer byteBuffer2 = byteBuffer;
            Intrinsics.checkNotNull((Object)byteBuffer2);
            ByteBuffer nativeBuffer = byteBuffer2;
            try {
                ByteBuf buffer = allocator2.directBuffer(nativeBuffer.remaining());
                buffer.writeBytes(nativeBuffer);
                Intrinsics.checkNotNull((Object)buffer);
                imageData = new ImageData(buffer, widthBuffer.get(0), heightBuffer.get(0), fileChannels.get(0));
                nativeBuffer.rewind();
            }
            catch (Throwable throwable2) {
                try {
                    nativeBuffer.rewind();
                    STBImage.stbi_image_free((ByteBuffer)nativeBuffer);
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            STBImage.stbi_image_free((ByteBuffer)nativeBuffer);
            ImageData imageData2 = imageData;
            return imageData2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveImage(@NotNull Path path, @NotNull ImageData imageData) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)((Object)imageData), (String)"imageData");
        Closeable closeable = Files.newByteChannel(path, (Set<? extends OpenOption>)this.fileOptions, new FileAttribute[0]);
        Throwable throwable = null;
        try {
            boolean bl;
            SeekableByteChannel it = (SeekableByteChannel)closeable;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it);
            Closeable closeable2 = new WriteCallback(it);
            Throwable throwable2 = null;
            try {
                WriteCallback writeCallback = (WriteCallback)closeable2;
                boolean bl3 = false;
                bl = STBImageWrite.nstbi_write_png_to_func((long)writeCallback.address(), (long)0L, (int)imageData.getWidth(), (int)imageData.getHeight(), (int)imageData.getFileChannels(), (long)MemoryUtil.memAddress((ByteBuffer)imageData.getData().nioBuffer()), (int)0) != 0;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            boolean bl4 = bl;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final ByteBuffer readResource(@NotNull InputStream inputStream) throws IOException {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        ByteBuffer byteBuffer = null;
        try {
            ByteBuffer byteBuffer2;
            if (inputStream instanceof FileInputStream) {
                FileChannel fileChannel = ((FileInputStream)inputStream).getChannel();
                byteBuffer = MemoryUtil.memAlloc((int)((int)fileChannel.size() + 1));
                while (fileChannel.read(byteBuffer) != -1) {
                }
            } else {
                byteBuffer = MemoryUtil.memAlloc((int)8192);
                ReadableByteChannel fileInputStream = Channels.newChannel(inputStream);
                while (fileInputStream.read(byteBuffer) != -1) {
                    ByteBuffer byteBuffer3 = byteBuffer;
                    boolean bl = byteBuffer3 != null ? byteBuffer3.remaining() == 0 : false;
                    if (!bl) continue;
                    byteBuffer = MemoryUtil.memRealloc((ByteBuffer)byteBuffer, (int)(byteBuffer.capacity() * 2));
                }
            }
            ByteBuffer byteBuffer4 = byteBuffer;
            Intrinsics.checkNotNull((Object)byteBuffer4);
            ByteBuffer it = byteBuffer2 = byteBuffer4;
            boolean bl = false;
            byteBuffer = null;
            return byteBuffer2;
        }
        catch (Throwable throwable) {
            if (byteBuffer != null) {
                MemoryUtil.memFree((Buffer)byteBuffer);
            }
            throw throwable;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J!\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0096\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lgg/essential/util/lwjgl3/impl/NativeImageReaderImpl$WriteCallback;", "Lorg/lwjgl/stb/STBIWriteCallback;", "Ljava/io/Closeable;", "channel", "Ljava/nio/channels/WritableByteChannel;", "(Ljava/nio/channels/WritableByteChannel;)V", "exception", "Ljava/io/IOException;", "close", "", "invoke", "context", "", "data", "size", "", "impl"})
    public static final class WriteCallback
    extends STBIWriteCallback
    implements Closeable {
        @NotNull
        private final WritableByteChannel channel;
        @Nullable
        private IOException exception;

        public WriteCallback(@NotNull WritableByteChannel channel2) {
            Intrinsics.checkNotNullParameter((Object)channel2, (String)"channel");
            this.channel = channel2;
        }

        public void invoke(long context, long data, int size) {
            ByteBuffer byteBuffer = STBIWriteCallback.getData((long)data, (int)size);
            try {
                this.channel.write(byteBuffer);
            }
            catch (IOException var8) {
                this.exception = var8;
            }
        }

        @Override
        public void close() {
            this.free();
        }
    }
}

