/*
 * Decompiled with CFR 0.152.
 */
package vazkii.neat;

import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;
import vazkii.neat.NeatConfig;

public class NeatForgeConfig {
    public static void init() {
        Pair specPair = new ForgeConfigSpec.Builder().configure(ForgeNeatConfig::new);
        NeatConfig.instance = (NeatConfig.ConfigAccess)specPair.getLeft();
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)specPair.getRight());
    }

    private static class ForgeNeatConfig
    implements NeatConfig.ConfigAccess {
        private final ForgeConfigSpec.ConfigValue<Integer> maxDistance;
        private final ForgeConfigSpec.ConfigValue<Integer> maxDistanceWithoutLineOfSight;
        private final ForgeConfigSpec.ConfigValue<Boolean> renderInF1;
        private final ForgeConfigSpec.ConfigValue<Double> heightAbove;
        private final ForgeConfigSpec.ConfigValue<Boolean> drawBackground;
        private final ForgeConfigSpec.ConfigValue<Integer> backgroundPadding;
        private final ForgeConfigSpec.ConfigValue<Integer> backgroundHeight;
        private final ForgeConfigSpec.ConfigValue<Integer> barHeight;
        private final ForgeConfigSpec.ConfigValue<Integer> plateSize;
        private final ForgeConfigSpec.ConfigValue<Integer> plateSizeBoss;
        private final ForgeConfigSpec.ConfigValue<Boolean> showAttributes;
        private final ForgeConfigSpec.ConfigValue<Boolean> showArmor;
        private final ForgeConfigSpec.ConfigValue<Boolean> groupArmor;
        private final ForgeConfigSpec.ConfigValue<Boolean> colorByType;
        private final ForgeConfigSpec.ConfigValue<String> textColor;
        private final ForgeConfigSpec.ConfigValue<Integer> hpTextHeight;
        private final ForgeConfigSpec.ConfigValue<Boolean> showMaxHP;
        private final ForgeConfigSpec.ConfigValue<Boolean> showCurrentHP;
        private final ForgeConfigSpec.ConfigValue<Boolean> showPercentage;
        private final ForgeConfigSpec.ConfigValue<Boolean> showOnPassive;
        private final ForgeConfigSpec.ConfigValue<Boolean> showOnHostile;
        private final ForgeConfigSpec.ConfigValue<Boolean> showOnPlayers;
        private final ForgeConfigSpec.ConfigValue<Boolean> showOnBosses;
        private final ForgeConfigSpec.ConfigValue<Boolean> showOnlyFocused;
        private final ForgeConfigSpec.ConfigValue<Boolean> showFullHealth;
        private final ForgeConfigSpec.ConfigValue<Boolean> enableDebugInfo;
        private final ForgeConfigSpec.ConfigValue<Boolean> showEntityName;
        private final ForgeConfigSpec.ConfigValue<Boolean> disableNameTag;
        private final ForgeConfigSpec.ConfigValue<Boolean> disableNameTagIfHealthbar;
        private final ForgeConfigSpec.ConfigValue<Double> iconOffsetX;
        private final ForgeConfigSpec.ConfigValue<Double> iconOffsetY;
        private final ForgeConfigSpec.ConfigValue<String> decimalFormat;
        private final ForgeConfigSpec.ConfigValue<List<? extends String>> blacklist;

        public ForgeNeatConfig(ForgeConfigSpec.Builder builder) {
            builder.push("general");
            this.maxDistance = builder.comment("Maximum distance in blocks at which health bars should render").define("max_distance", (Object)24);
            this.maxDistanceWithoutLineOfSight = builder.comment("Maximum distance in blocks at which health bars should render without line of sight").define("max_distance_without_line_of_sight", (Object)8);
            this.renderInF1 = builder.comment("Whether health bars should render when the HUD is disabled with F1").define("render_without_gui", false);
            this.heightAbove = builder.comment("How far above the mob the health bars should render").define("height_above_mob", (Object)0.6);
            this.drawBackground = builder.comment("Whether the gray background plate should be drawn").define("draw_background", true);
            this.backgroundPadding = builder.comment("Amount of extra padding space around the background plate").define("background_padding", (Object)2);
            this.backgroundHeight = builder.comment("How tall the background plate should be").define("background_height", (Object)6);
            this.barHeight = builder.comment("How tall the health bar should be").define("health_bar_height", (Object)4);
            this.plateSize = builder.comment("How wide the health bar should be. If the entity has a long name, the bar will increase in size to match it.").define("plate_size", (Object)25);
            this.plateSizeBoss = builder.comment("plateSize but for bosses").define("plate_size_boss", (Object)50);
            this.showAttributes = builder.comment("Show mob attributes such as arthropod or undead").define("show_attributes", true);
            this.showArmor = builder.comment("Show armor points").define("show_armor", true);
            this.groupArmor = builder.comment("Group 5 iron icons into 1 diamond icon").define("group_armor", true);
            this.colorByType = builder.comment("Color health bar by mob type instead of health percentage").define("color_health_bar_by_type", false);
            this.textColor = builder.comment("Text color in hex code format").define("text_color", (Object)"FFFFFF");
            this.hpTextHeight = builder.comment("Height of the text on the health bar").define("hp_text_height", (Object)14);
            this.showMaxHP = builder.comment("Whether the maximum health of the mob should be shown").define("show_max_hp", true);
            this.showCurrentHP = builder.comment("Whether the current health of the mob should be shown").define("show_current_hp", true);
            this.showPercentage = builder.comment("Whether the percentage health of the mob should be shown").define("show_hp_percentage", true);
            this.showOnPassive = builder.comment("Whether bars on passive mobs should be shown").define("show_on_passive", true);
            this.showOnHostile = builder.comment("Whether bars on hostile mobs should be shown (does not include bosses)").define("show_on_hostile", true);
            this.showOnPlayers = builder.comment("Whether bars on players should be shown").define("display_on_players", true);
            this.showOnBosses = builder.comment("Whether bars on bosses should be shown").define("display_on_bosses", true);
            this.showOnlyFocused = builder.comment("Only show bars for mobs you are targeting").define("only_health_bar_for_target", false);
            this.showFullHealth = builder.comment("Show bars for mobs that are at full health").define("show_entity_full_health", true);
            this.enableDebugInfo = builder.comment("Show extra debug info on the bar when F3 is enabled").define("show_debug_with_f3", true);
            this.showEntityName = builder.comment("Show entity name").define("show_entity_name", true);
            this.disableNameTag = builder.comment("Disables the rendering of the vanilla name tag").define("disable_name_tag", false);
            this.disableNameTagIfHealthbar = builder.comment("If this is enabled and the \"disableNameTag\" option is true, the vanilla nametag is only hidden if the mob has a Neat healthbar rendered").define("disable_name_tag_if_healthbar", true);
            this.iconOffsetX = builder.comment("Offsets the healtbar icons on the x axis").define("icon_offset_x", (Object)0.0);
            this.iconOffsetY = builder.comment("Offsets the healtbar icons on the y axis").define("icon_offset_y", (Object)0.0);
            this.decimalFormat = builder.comment("This value changes the decimal format of the HP. Only change this value if you are familiar with how the decimal format works!").define("decimal_format", (Object)"#.##");
            this.blacklist = builder.comment("Blacklist uses entity IDs, not their display names. Use F3 to see them in the Neat bar.").defineList("blacklist", NeatConfig.DEFAULT_DISABLED, a -> true);
            builder.pop();
        }

        @Override
        public int maxDistance() {
            return (Integer)this.maxDistance.get();
        }

        @Override
        public int maxDistanceWithoutLineOfSight() {
            return (Integer)this.maxDistanceWithoutLineOfSight.get();
        }

        @Override
        public boolean renderInF1() {
            return (Boolean)this.renderInF1.get();
        }

        @Override
        public double heightAbove() {
            return (Double)this.heightAbove.get();
        }

        @Override
        public boolean drawBackground() {
            return (Boolean)this.drawBackground.get();
        }

        @Override
        public int backgroundPadding() {
            return (Integer)this.backgroundPadding.get();
        }

        @Override
        public int backgroundHeight() {
            return (Integer)this.backgroundHeight.get();
        }

        @Override
        public int barHeight() {
            return (Integer)this.barHeight.get();
        }

        @Override
        public int plateSize() {
            return (Integer)this.plateSize.get();
        }

        @Override
        public int plateSizeBoss() {
            return (Integer)this.plateSizeBoss.get();
        }

        @Override
        public boolean showAttributes() {
            return (Boolean)this.showAttributes.get();
        }

        @Override
        public boolean showArmor() {
            return (Boolean)this.showArmor.get();
        }

        @Override
        public boolean groupArmor() {
            return (Boolean)this.groupArmor.get();
        }

        @Override
        public boolean colorByType() {
            return (Boolean)this.colorByType.get();
        }

        @Override
        public String textColor() {
            return (String)this.textColor.get();
        }

        @Override
        public int hpTextHeight() {
            return (Integer)this.hpTextHeight.get();
        }

        @Override
        public boolean showMaxHP() {
            return (Boolean)this.showMaxHP.get();
        }

        @Override
        public boolean showCurrentHP() {
            return (Boolean)this.showCurrentHP.get();
        }

        @Override
        public boolean showPercentage() {
            return (Boolean)this.showPercentage.get();
        }

        @Override
        public boolean showOnPassive() {
            return (Boolean)this.showOnPassive.get();
        }

        @Override
        public boolean showOnHostile() {
            return (Boolean)this.showOnHostile.get();
        }

        @Override
        public boolean showOnPlayers() {
            return (Boolean)this.showOnPlayers.get();
        }

        @Override
        public boolean showOnBosses() {
            return (Boolean)this.showOnBosses.get();
        }

        @Override
        public boolean showOnlyFocused() {
            return (Boolean)this.showOnlyFocused.get();
        }

        @Override
        public boolean showFullHealth() {
            return (Boolean)this.showFullHealth.get();
        }

        @Override
        public boolean enableDebugInfo() {
            return (Boolean)this.enableDebugInfo.get();
        }

        @Override
        public boolean showEntityName() {
            return (Boolean)this.showEntityName.get();
        }

        @Override
        public boolean disableNameTag() {
            return (Boolean)this.disableNameTag.get();
        }

        @Override
        public boolean disableNameTagIfHealthbar() {
            return (Boolean)this.disableNameTagIfHealthbar.get();
        }

        @Override
        public double iconOffsetX() {
            return (Double)this.iconOffsetX.get();
        }

        @Override
        public double iconOffsetY() {
            return (Double)this.iconOffsetY.get();
        }

        @Override
        public String decimalFormat() {
            return (String)this.decimalFormat.get();
        }

        @Override
        public List<String> blacklist() {
            return (List)this.blacklist.get();
        }
    }
}

